/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsByteArrayLimit;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.UnpackedObject$1;
import org.eclipse.jgit.internal.storage.file.UnpackedObject$LargeObject;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectLoader$SmallObject;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class UnpackedObject {
    private static final int BUFFER_SIZE = 8192;

    public static ObjectLoader parse(byte[] byArray, AnyObjectId anyObjectId) {
        try (WindowCursor windowCursor = new WindowCursor(null);){
            ObjectLoader objectLoader = UnpackedObject.open(new ByteArrayInputStream(byArray), null, anyObjectId, windowCursor);
            return objectLoader;
        }
    }

    static ObjectLoader open(InputStream inputStream, File file, AnyObjectId anyObjectId, WindowCursor windowCursor) {
        try {
            inputStream = UnpackedObject.buffer(inputStream);
            inputStream.mark(20);
            byte[] byArray = new byte[64];
            IO.readFully(inputStream, byArray, 0, 2);
            if (UnpackedObject.isStandardFormat(byArray)) {
                inputStream.reset();
                Inflater inflater = windowCursor.inflater();
                InflaterInputStream inflaterInputStream = UnpackedObject.inflate(inputStream, inflater);
                int n2 = UnpackedObject.readSome(inflaterInputStream, byArray, 0, 64);
                if (n2 < 5) {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger mutableInteger = new MutableInteger();
                int n3 = Constants.decodeTypeString(anyObjectId, byArray, (byte)32, mutableInteger);
                long l2 = RawParseUtils.parseLongBase10(byArray, mutableInteger.value, mutableInteger);
                if (l2 < 0L) {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectNegativeSize);
                }
                if (byArray[mutableInteger.value++] != 0) {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectGarbageAfterSize);
                }
                if (file == null && Integer.MAX_VALUE < l2) {
                    LargeObjectException$ExceedsByteArrayLimit largeObjectException$ExceedsByteArrayLimit = new LargeObjectException$ExceedsByteArrayLimit();
                    largeObjectException$ExceedsByteArrayLimit.setObjectId(anyObjectId);
                    throw largeObjectException$ExceedsByteArrayLimit;
                }
                if (l2 < (long)windowCursor.getStreamFileThreshold() || file == null) {
                    byte[] byArray2 = new byte[(int)l2];
                    int n4 = n2 - mutableInteger.value;
                    if (n4 > 0) {
                        System.arraycopy(byArray, mutableInteger.value, byArray2, 0, n4);
                    }
                    IO.readFully(inflaterInputStream, byArray2, n4, byArray2.length - n4);
                    UnpackedObject.checkValidEndOfStream(inputStream, inflater, anyObjectId, byArray);
                    return new ObjectLoader$SmallObject(n3, byArray2);
                }
                return new UnpackedObject$LargeObject(n3, l2, file, anyObjectId, windowCursor.db);
            }
            UnpackedObject.readSome(inputStream, byArray, 2, 18);
            int n5 = byArray[0] & 0xFF;
            int n6 = n5 >> 4 & 7;
            long l3 = n5 & 0xF;
            int n7 = 4;
            int n8 = 1;
            while ((n5 & 0x80) != 0) {
                n5 = byArray[n8++] & 0xFF;
                l3 += (long)(n5 & 0x7F) << n7;
                n7 += 7;
            }
            switch (n6) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectInvalidType);
                }
            }
            if (file == null && Integer.MAX_VALUE < l3) {
                LargeObjectException$ExceedsByteArrayLimit largeObjectException$ExceedsByteArrayLimit = new LargeObjectException$ExceedsByteArrayLimit();
                largeObjectException$ExceedsByteArrayLimit.setObjectId(anyObjectId);
                throw largeObjectException$ExceedsByteArrayLimit;
            }
            if (l3 < (long)windowCursor.getStreamFileThreshold() || file == null) {
                inputStream.reset();
                IO.skipFully(inputStream, n8);
                Inflater inflater = windowCursor.inflater();
                InflaterInputStream inflaterInputStream = UnpackedObject.inflate(inputStream, inflater);
                byte[] byArray3 = new byte[(int)l3];
                IO.readFully(inflaterInputStream, byArray3, 0, byArray3.length);
                UnpackedObject.checkValidEndOfStream(inputStream, inflater, anyObjectId, byArray);
                return new ObjectLoader$SmallObject(n6, byArray3);
            }
            return new UnpackedObject$LargeObject(n6, l3, file, anyObjectId, windowCursor.db);
        }
        catch (ZipException zipException) {
            CorruptObjectException corruptObjectException = new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
            corruptObjectException.initCause(zipException);
            throw corruptObjectException;
        }
    }

    static long getSize(InputStream inputStream, AnyObjectId anyObjectId, WindowCursor windowCursor) {
        try {
            inputStream = UnpackedObject.buffer(inputStream);
            inputStream.mark(20);
            byte[] byArray = new byte[64];
            IO.readFully(inputStream, byArray, 0, 2);
            if (UnpackedObject.isStandardFormat(byArray)) {
                inputStream.reset();
                Inflater inflater = windowCursor.inflater();
                InflaterInputStream inflaterInputStream = UnpackedObject.inflate(inputStream, inflater);
                int n2 = UnpackedObject.readSome(inflaterInputStream, byArray, 0, 64);
                if (n2 < 5) {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger mutableInteger = new MutableInteger();
                Constants.decodeTypeString(anyObjectId, byArray, (byte)32, mutableInteger);
                long l2 = RawParseUtils.parseLongBase10(byArray, mutableInteger.value, mutableInteger);
                if (l2 < 0L) {
                    throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectNegativeSize);
                }
                return l2;
            }
            UnpackedObject.readSome(inputStream, byArray, 2, 18);
            int n3 = byArray[0] & 0xFF;
            long l3 = n3 & 0xF;
            int n4 = 4;
            int n5 = 1;
            while ((n3 & 0x80) != 0) {
                n3 = byArray[n5++] & 0xFF;
                l3 += (long)(n3 & 0x7F) << n4;
                n4 += 7;
            }
            return l3;
        }
        catch (ZipException zipException) {
            CorruptObjectException corruptObjectException = new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
            corruptObjectException.initCause(zipException);
            throw corruptObjectException;
        }
    }

    static void checkValidEndOfStream(InputStream inputStream, Inflater inflater, AnyObjectId anyObjectId, byte[] byArray) {
        while (true) {
            int n2;
            try {
                n2 = inflater.inflate(byArray);
            }
            catch (DataFormatException dataFormatException) {
                CorruptObjectException corruptObjectException = new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
                corruptObjectException.initCause(dataFormatException);
                throw corruptObjectException;
            }
            if (n2 != 0) {
                throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectIncorrectLength);
            }
            if (inflater.finished()) {
                if (inflater.getRemaining() == 0 && inputStream.read() == -1) break;
                throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
            }
            if (!inflater.needsInput()) {
                throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
            }
            n2 = inputStream.read(byArray);
            if (n2 <= 0) {
                throw new CorruptObjectException(anyObjectId, JGitText.get().corruptObjectBadStream);
            }
            inflater.setInput(byArray, 0, n2);
        }
    }

    static boolean isStandardFormat(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        return (n2 & 0x8F) == 8 && (n2 << 8 | byArray[1] & 0xFF) % 31 == 0;
    }

    static InputStream inflate(InputStream inputStream, long l2, ObjectId objectId) {
        Inflater inflater = InflaterCache.get();
        return new UnpackedObject$1(inputStream, inflater, l2, objectId);
    }

    private static InflaterInputStream inflate(InputStream inputStream, Inflater inflater) {
        return new InflaterInputStream(inputStream, inflater, 8192);
    }

    static BufferedInputStream buffer(InputStream inputStream) {
        return new BufferedInputStream(inputStream, 8192);
    }

    static int readSome(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        while (0 < n3 && (n4 = inputStream.read(byArray, n2, n3)) >= 0) {
            n5 += n4;
            n2 += n4;
            n3 -= n4;
        }
        return n5;
    }
}

