/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ObjectStream$Filter;
import org.eclipse.jgit.util.IO;

final class UnpackedObject$LargeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final File path;
    private final ObjectId id;
    private final FileObjectDatabase source;

    UnpackedObject$LargeObject(int n2, long l2, File file, AnyObjectId anyObjectId, FileObjectDatabase fileObjectDatabase) {
        this.type = n2;
        this.size = l2;
        this.path = file;
        this.id = anyObjectId.copy();
        this.source = fileObjectDatabase;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() {
        throw new LargeObjectException(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectStream openStream() {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = UnpackedObject.buffer(new FileInputStream(this.path));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.path.exists()) {
                throw fileNotFoundException;
            }
            return this.source.open(this.id, this.type).openStream();
        }
        boolean bl2 = false;
        try {
            byte[] byArray = new byte[64];
            ((InputStream)bufferedInputStream).mark(20);
            IO.readFully(bufferedInputStream, byArray, 0, 2);
            if (UnpackedObject.isStandardFormat(byArray)) {
                ((InputStream)bufferedInputStream).reset();
                bufferedInputStream = UnpackedObject.buffer(UnpackedObject.inflate(bufferedInputStream, this.size, this.id));
                while (0 < ((InputStream)bufferedInputStream).read()) {
                }
            } else {
                UnpackedObject.readSome(bufferedInputStream, byArray, 2, 18);
                int n2 = byArray[0] & 0xFF;
                int n3 = 1;
                while ((n2 & 0x80) != 0) {
                    n2 = byArray[n3++] & 0xFF;
                }
                ((InputStream)bufferedInputStream).reset();
                IO.skipFully(bufferedInputStream, n3);
                bufferedInputStream = UnpackedObject.buffer(UnpackedObject.inflate(bufferedInputStream, this.size, this.id));
            }
            bl2 = true;
            ObjectStream$Filter objectStream$Filter = new ObjectStream$Filter(this.type, this.size, bufferedInputStream);
            return objectStream$Filter;
        }
        finally {
            if (!bl2) {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }
}

