/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.DataInput;
import java.io.InputStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class SimpleDataInput
implements DataInput {
    private final InputStream fd;
    private final byte[] buf = new byte[8];

    SimpleDataInput(InputStream inputStream) {
        this.fd = inputStream;
    }

    @Override
    public int readInt() {
        this.readFully(this.buf, 0, 4);
        return NB.decodeInt32(this.buf, 0);
    }

    @Override
    public long readLong() {
        this.readFully(this.buf, 0, 8);
        return NB.decodeInt64(this.buf, 0);
    }

    public long readUnsignedInt() {
        this.readFully(this.buf, 0, 4);
        return NB.decodeUInt32(this.buf, 0);
    }

    @Override
    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) {
        IO.readFully(this.fd, byArray, n2, n3);
    }

    @Override
    public int skipBytes(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public char readChar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        throw new UnsupportedOperationException();
    }
}

