/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig$LogRefUpdates;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class ReflogWriter {
    private final RefDirectory refdb;
    private final boolean forceWrite;

    public static String refLockFor(String string) {
        return string + ".lock";
    }

    public ReflogWriter(RefDirectory refDirectory) {
        this(refDirectory, false);
    }

    public ReflogWriter(RefDirectory refDirectory, boolean bl2) {
        this.refdb = refDirectory;
        this.forceWrite = bl2;
    }

    public ReflogWriter create() {
        FileUtils.mkdir(this.refdb.logsDir);
        FileUtils.mkdir(this.refdb.logsRefsDir);
        FileUtils.mkdir(new File(this.refdb.logsRefsDir, "refs/heads/".substring("refs/".length())));
        return this;
    }

    public ReflogWriter log(String string, ReflogEntry reflogEntry) {
        return this.log(string, reflogEntry.getOldId(), reflogEntry.getNewId(), reflogEntry.getWho(), reflogEntry.getComment());
    }

    public ReflogWriter log(String string, ObjectId objectId, ObjectId objectId2, PersonIdent personIdent, String string2) {
        byte[] byArray = this.encode(objectId, objectId2, personIdent, string2);
        return this.log(string, byArray);
    }

    public ReflogWriter log(RefUpdate refUpdate, String string, boolean bl2) {
        ObjectId objectId = refUpdate.getOldObjectId();
        ObjectId objectId2 = refUpdate.getNewObjectId();
        Ref ref = refUpdate.getRef();
        PersonIdent personIdent = refUpdate.getRefLogIdent();
        personIdent = personIdent == null ? new PersonIdent(this.refdb.getRepository()) : new PersonIdent(personIdent);
        byte[] byArray = this.encode(objectId, objectId2, personIdent, string);
        if (bl2 && ref.isSymbolic()) {
            this.log(ref.getName(), byArray);
            this.log(ref.getLeaf().getName(), byArray);
        } else {
            this.log(ref.getName(), byArray);
        }
        return this;
    }

    private byte[] encode(ObjectId objectId, ObjectId objectId2, PersonIdent personIdent, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ObjectId.toString(objectId));
        stringBuilder.append(' ');
        stringBuilder.append(ObjectId.toString(objectId2));
        stringBuilder.append(' ');
        stringBuilder.append(personIdent.toExternalString());
        stringBuilder.append('\t');
        stringBuilder.append(string.replace("\r\n", " ").replace("\n", " "));
        stringBuilder.append('\n');
        return Constants.encode(stringBuilder.toString());
    }

    private FileOutputStream getFileOutputStream(File file) {
        try {
            return new FileOutputStream(file, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = file.getParentFile();
            if (file2.exists()) {
                throw fileNotFoundException;
            }
            if (!file2.mkdirs() && !file2.isDirectory()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, file2));
            }
            return new FileOutputStream(file, true);
        }
    }

    private ReflogWriter log(String string, byte[] byArray) {
        boolean bl2;
        File file = this.refdb.logFor(string);
        boolean bl3 = bl2 = this.forceWrite || this.shouldAutoCreateLog(string) || file.isFile();
        if (!bl2) {
            return this;
        }
        WriteConfig writeConfig = (WriteConfig)this.refdb.getRepository().getConfig().get(WriteConfig.KEY);
        try (FileOutputStream fileOutputStream = this.getFileOutputStream(file);){
            if (writeConfig.getFSyncRefFiles()) {
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                while (0 < byteBuffer.remaining()) {
                    fileChannel.write(byteBuffer);
                }
                fileChannel.force(true);
            } else {
                fileOutputStream.write(byArray);
            }
        }
        return this;
    }

    private boolean shouldAutoCreateLog(String string) {
        Repository repository = this.refdb.getRepository();
        CoreConfig$LogRefUpdates coreConfig$LogRefUpdates = repository.isBare() ? CoreConfig$LogRefUpdates.FALSE : CoreConfig$LogRefUpdates.TRUE;
        coreConfig$LogRefUpdates = (CoreConfig$LogRefUpdates)repository.getConfig().getEnum("core", null, "logallrefupdates", coreConfig$LogRefUpdates);
        if (coreConfig$LogRefUpdates != null) {
            switch (coreConfig$LogRefUpdates) {
                case FALSE: {
                    break;
                }
                case TRUE: {
                    return string.equals("HEAD") || string.startsWith("refs/heads/") || string.startsWith("refs/remotes/") || string.startsWith("refs/notes/");
                }
                case ALWAYS: {
                    return string.equals("HEAD") || string.startsWith("refs/");
                }
            }
        }
        return false;
    }
}

