/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.ReflogEntryImpl;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class ReflogReaderImpl
implements ReflogReader {
    private File logName;

    public ReflogReaderImpl(Repository repository, String string) {
        this.logName = repository.getDirectoryChild("logs/" + string);
    }

    @Override
    public ReflogEntry getLastEntry() {
        return this.getReverseEntry(0);
    }

    @Override
    public List getReverseEntries() {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    @Override
    public ReflogEntry getReverseEntry(int n2) {
        byte[] byArray;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        try {
            byArray = IO.readFully(this.logName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.logName.exists()) {
                throw fileNotFoundException;
            }
            return null;
        }
        int n3 = RawParseUtils.prevLF(byArray, byArray.length);
        int n4 = 0;
        while (n3 >= 0) {
            n3 = RawParseUtils.prevLF(byArray, n3);
            if (n2 == n4) {
                return new ReflogEntryImpl(byArray, n3 < 0 ? 0 : n3 + 2);
            }
            ++n4;
        }
        return null;
    }

    @Override
    public List getReverseEntries(int n2) {
        byte[] byArray;
        try {
            byArray = IO.readFully(this.logName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.logName.exists()) {
                throw fileNotFoundException;
            }
            return Collections.emptyList();
        }
        int n3 = RawParseUtils.prevLF(byArray, byArray.length);
        ArrayList<ReflogEntryImpl> arrayList = new ArrayList<ReflogEntryImpl>();
        while (n3 >= 0 && n2-- > 0) {
            ReflogEntryImpl reflogEntryImpl = new ReflogEntryImpl(byArray, (n3 = RawParseUtils.prevLF(byArray, n3)) < 0 ? 0 : n3 + 2);
            arrayList.add(reflogEntryImpl);
        }
        return arrayList;
    }

    public File getLogName() {
        return this.logName;
    }
}

