/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.Serializable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.CheckoutEntryImpl;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.JGitIllegalArgumentException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.util.RawParseUtils;

public class ReflogEntryImpl
implements Serializable,
ReflogEntry {
    private static final long serialVersionUID = 1L;
    private ObjectId oldId;
    private ObjectId newId;
    private PersonIdent who;
    private String comment;

    ReflogEntryImpl(byte[] byArray, int n2) {
        int n3;
        this.oldId = ObjectId.fromString(byArray, n2);
        n2 += 40;
        if (byArray[n2++] != 32) {
            throw new JGitIllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.newId = ObjectId.fromString(byArray, n2);
        n2 += 40;
        if (byArray[n2++] != 32) {
            throw new JGitIllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.who = RawParseUtils.parsePersonIdentOnly(byArray, n2);
        int n4 = RawParseUtils.next(byArray, n2, '\t');
        this.comment = n4 >= byArray.length ? "" : ((n3 = RawParseUtils.nextLF(byArray, n4)) > n4 ? RawParseUtils.decode(byArray, n4, n3 - 1) : "");
    }

    @Override
    public ObjectId getOldId() {
        return this.oldId;
    }

    @Override
    public ObjectId getNewId() {
        return this.newId;
    }

    @Override
    public PersonIdent getWho() {
        return this.who;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Entry[" + this.oldId.name() + ", " + this.newId.name() + ", " + this.getWho() + ", " + this.getComment() + "]";
    }

    @Override
    public CheckoutEntry parseCheckout() {
        if (this.getComment().startsWith("checkout: moving from ")) {
            return new CheckoutEntryImpl(this);
        }
        return null;
    }
}

