/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;

class RefDirectoryUpdate
extends RefUpdate {
    private final RefDirectory database;
    private boolean shouldDeref;
    private LockFile lock;

    RefDirectoryUpdate(RefDirectory refDirectory, Ref ref) {
        super(ref);
        this.database = refDirectory;
    }

    @Override
    protected RefDirectory getRefDatabase() {
        return this.database;
    }

    @Override
    protected Repository getRepository() {
        return this.database.getRepository();
    }

    @Override
    protected boolean tryLock(boolean bl2) {
        this.shouldDeref = bl2;
        Ref ref = this.getRef();
        if (bl2) {
            ref = ref.getLeaf();
        }
        String string = ref.getName();
        this.lock = new LockFile(this.database.fileFor(string), this.getRepository().getFS());
        if (this.lock.lock()) {
            ref = this.database.findRef(string);
            this.setOldObjectId(ref != null ? ref.getObjectId() : null);
            return true;
        }
        return false;
    }

    @Override
    protected void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    @Override
    protected RefUpdate$Result doUpdate(RefUpdate$Result refUpdate$Result) {
        WriteConfig writeConfig = (WriteConfig)this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(writeConfig.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(this.getNewObjectId());
        String string = this.getRefLogMessage();
        if (string != null) {
            String string2;
            if (this.isRefLogIncludingResult() && (string2 = this.toResultString(refUpdate$Result)) != null) {
                string = string.length() > 0 ? string + ": " + string2 : string2;
            }
            this.database.log(this.isForceRefLog(), this, string, this.shouldDeref);
        }
        if (!this.lock.commit()) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        this.database.stored(this, this.lock.getCommitSnapshot());
        return refUpdate$Result;
    }

    private String toResultString(RefUpdate$Result refUpdate$Result) {
        switch (refUpdate$Result) {
            case FORCED: {
                return "forced-update";
            }
            case FAST_FORWARD: {
                return "fast-forward";
            }
            case NEW: {
                return "created";
            }
        }
        return null;
    }

    @Override
    protected RefUpdate$Result doDelete(RefUpdate$Result refUpdate$Result) {
        if (this.getRef().getStorage() != Ref$Storage.NEW) {
            this.database.delete(this);
        }
        return refUpdate$Result;
    }

    @Override
    protected RefUpdate$Result doLink(String string) {
        WriteConfig writeConfig = (WriteConfig)this.database.getRepository().getConfig().get(WriteConfig.KEY);
        this.lock.setFSync(writeConfig.getFSyncRefFiles());
        this.lock.setNeedStatInformation(true);
        this.lock.write(Constants.encode("ref: " + string + '\n'));
        String string2 = this.getRefLogMessage();
        if (string2 != null) {
            this.database.log(this.isForceRefLog(), this, string2, false);
        }
        if (!this.lock.commit()) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        this.database.storedSymbolicRef(this, this.lock.getCommitSnapshot(), string);
        if (this.getRef().getStorage() == Ref$Storage.NEW) {
            return RefUpdate$Result.NEW;
        }
        return RefUpdate$Result.FORCED;
    }
}

