/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.StandardCopyOption;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefDirectoryRename
extends RefRename {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectoryRename.class);
    private final RefDirectory refdb;
    private ObjectId objId;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate refDirectoryUpdate, RefDirectoryUpdate refDirectoryUpdate2) {
        super(refDirectoryUpdate, refDirectoryUpdate2);
        this.refdb = refDirectoryUpdate.getRefDatabase();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected RefUpdate$Result doRename() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 66[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean renameLog(RefUpdate refUpdate, RefUpdate refUpdate2) {
        File file = this.refdb.logFor(refUpdate.getName());
        File file2 = this.refdb.logFor(refUpdate2.getName());
        if (!file.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(file, file2)) {
            return false;
        }
        try {
            int n2 = RefDirectory.levelsIn(refUpdate.getName()) - 2;
            RefDirectory.delete(file, n2);
            return true;
        }
        catch (IOException iOException) {
            RefDirectoryRename.rename(file2, file);
            return false;
        }
    }

    private static boolean rename(File file, File file2) {
        try {
            FileUtils.rename(file, file2, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            LOG.error(atomicMoveNotSupportedException.getMessage(), (Throwable)atomicMoveNotSupportedException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file3 = file2.getParentFile();
        if (!(!file3.exists() && file3.mkdirs() || file3.isDirectory())) {
            return false;
        }
        try {
            FileUtils.rename(file, file2, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            return false;
        }
    }

    private boolean linkHEAD(RefUpdate refUpdate) {
        try {
            RefDirectoryUpdate refDirectoryUpdate = this.refdb.newUpdate("HEAD", false);
            refDirectoryUpdate.disableRefLog();
            switch (refDirectoryUpdate.link(refUpdate.getName())) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

