/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.PackedBatchRefUpdate;
import org.eclipse.jgit.internal.storage.file.RefDirectory$1;
import org.eclipse.jgit.internal.storage.file.RefDirectory$LooseRef;
import org.eclipse.jgit.internal.storage.file.RefDirectory$LooseScanner;
import org.eclipse.jgit.internal.storage.file.RefDirectory$LooseSymbolicRef;
import org.eclipse.jgit.internal.storage.file.RefDirectory$LooseUnpeeled;
import org.eclipse.jgit.internal.storage.file.RefDirectory$PackedRefList;
import org.eclipse.jgit.internal.storage.file.RefDirectoryRename;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefList$Builder;
import org.eclipse.jgit.util.RefMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefDirectory
extends RefDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectory.class);
    public static final String SYMREF = "ref: ";
    public static final String PACKED_REFS_HEADER = "# pack-refs with:";
    public static final String PACKED_REFS_PEELED = " peeled";
    private static final String[] additionalRefsNames = new String[]{"MERGE_HEAD", "FETCH_HEAD", "ORIG_HEAD", "CHERRY_PICK_HEAD"};
    private static final List RETRY_SLEEP_MS = Collections.unmodifiableList(Arrays.asList(0, 100, 200, 400, 800, 1600));
    private final FileRepository parent;
    private final File gitDir;
    final File refsDir;
    final File packedRefsFile;
    final File logsDir;
    final File logsRefsDir;
    private final AtomicReference looseRefs = new AtomicReference();
    final AtomicReference packedRefs = new AtomicReference();
    final ReentrantLock inProcessPackedRefsLock = new ReentrantLock(true);
    private final AtomicInteger modCnt = new AtomicInteger();
    private final AtomicInteger lastNotifiedModCnt = new AtomicInteger();
    private List retrySleepMs = RETRY_SLEEP_MS;
    private static final RefDirectory$PackedRefList NO_PACKED_REFS = new RefDirectory$PackedRefList(RefList.emptyList(), FileSnapshot.MISSING_FILE, ObjectId.zeroId(), null);

    RefDirectory(FileRepository fileRepository) {
        this.parent = fileRepository;
        this.gitDir = fileRepository.getDirectory();
        this.refsDir = fileRepository.resolveDirectoryChild("refs");
        this.logsDir = fileRepository.resolveDirectoryChild("logs");
        this.logsRefsDir = fileRepository.resolveDirectoryChild("logs/refs");
        this.packedRefsFile = fileRepository.resolveDirectoryChild("packed-refs");
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
    }

    Repository getRepository() {
        return this.parent;
    }

    ReflogWriter newLogWriter(boolean bl2) {
        return new ReflogWriter(this, bl2);
    }

    public File logFor(String string) {
        if (string.startsWith("refs/")) {
            string = string.substring("refs/".length());
            return new File(this.logsRefsDir, string);
        }
        return new File(this.logsDir, string);
    }

    @Override
    public void create() {
        FileUtils.mkdir(this.refsDir);
        FileUtils.mkdir(new File(this.refsDir, "refs/heads/".substring("refs/".length())));
        FileUtils.mkdir(new File(this.refsDir, "refs/tags/".substring("refs/".length())));
        this.newLogWriter(false).create();
    }

    @Override
    public void close() {
        this.clearReferences();
    }

    private void clearReferences() {
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.clearReferences();
    }

    @Override
    public boolean isNameConflicting(String string) {
        int n2 = string.lastIndexOf(47);
        while (0 < n2) {
            String string2 = string.substring(0, n2);
            if (this.exactRef(string2) != null) {
                return true;
            }
            n2 = string.lastIndexOf(47, n2 - 1);
        }
        return !this.getRefsByPrefix(string + '/').isEmpty();
    }

    @Nullable
    private Ref readAndResolve(String string, RefList refList) {
        try {
            Ref ref = this.readRef(string, refList);
            if (ref != null) {
                ref = this.resolve(ref, 0, null, null, refList);
            }
            return ref;
        }
        catch (IOException iOException) {
            if (string.contains("/") || !(iOException.getCause() instanceof InvalidObjectIdException)) {
                throw iOException;
            }
            return null;
        }
    }

    @Override
    public Ref exactRef(String string) {
        try {
            Ref ref = this.readAndResolve(string, this.getPackedRefs());
            return ref;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map exactRef(String ... stringArray) {
        try {
            RefDirectory$PackedRefList refDirectory$PackedRefList = this.getPackedRefs();
            HashMap<String, Ref> hashMap = new HashMap<String, Ref>(stringArray.length);
            for (String string : stringArray) {
                Ref ref = this.readAndResolve(string, refDirectory$PackedRefList);
                if (ref == null) continue;
                hashMap.put(string, ref);
            }
            HashMap<String, Ref> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Ref firstExactRef(String ... stringArray) {
        try {
            RefDirectory$PackedRefList refDirectory$PackedRefList = this.getPackedRefs();
            for (String string : stringArray) {
                Ref ref = this.readAndResolve(string, refDirectory$PackedRefList);
                if (ref == null) continue;
                Ref ref2 = ref;
                return ref2;
            }
            String[] stringArray2 = null;
            return stringArray2;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    @Override
    public Map getRefs(String string) {
        RefList refList;
        RefList refList2 = (RefList)this.looseRefs.get();
        RefDirectory$LooseScanner refDirectory$LooseScanner = new RefDirectory$LooseScanner(this, refList2);
        refDirectory$LooseScanner.scan(string);
        RefDirectory$PackedRefList refDirectory$PackedRefList = this.getPackedRefs();
        if (refDirectory$LooseScanner.newLoose != null) {
            refDirectory$LooseScanner.newLoose.sort();
            refList = refDirectory$LooseScanner.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(refList2, refList)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            refList = refList2;
        }
        this.fireRefsChanged();
        RefList$Builder refList$Builder = refDirectory$LooseScanner.symbolic;
        int n2 = 0;
        while (n2 < refList$Builder.size()) {
            Ref ref = refList$Builder.get(n2);
            Ref ref2 = this.resolve(ref, 0, string, refList, refDirectory$PackedRefList);
            if (ref2 != null && ref2.getObjectId() != null) {
                refList$Builder.set(n2, ref2);
                ++n2;
                continue;
            }
            refList$Builder.remove(n2);
            int n3 = refList.find(ref.getName());
            if (0 > n3) continue;
            refList = refList.remove(n3);
        }
        refList$Builder.sort();
        return new RefMap(string, refDirectory$PackedRefList, this.upcast(refList), refList$Builder.toRefList());
    }

    @Override
    public List getAdditionalRefs() {
        LinkedList<Ref> linkedList = new LinkedList<Ref>();
        for (String string : additionalRefsNames) {
            Ref ref = this.exactRef(string);
            if (ref == null) continue;
            linkedList.add(ref);
        }
        return linkedList;
    }

    private RefList upcast(RefList refList) {
        return refList;
    }

    @Override
    public Ref peel(Ref ref) {
        RefList refList;
        int n2;
        Ref ref2 = ref.getLeaf();
        if (ref2.isPeeled() || ref2.getObjectId() == null) {
            return ref;
        }
        ObjectIdRef objectIdRef = this.doPeel(ref2);
        if (ref2.getStorage().isLoose() && 0 <= (n2 = (refList = (RefList)this.looseRefs.get()).find(ref2.getName())) && refList.get(n2) == ref2) {
            RefDirectory$LooseRef refDirectory$LooseRef = ((RefDirectory$LooseRef)ref2).peel(objectIdRef);
            RefList refList2 = refList.set(n2, refDirectory$LooseRef);
            this.looseRefs.compareAndSet(refList, refList2);
        }
        return RefDirectory.recreate(ref, objectIdRef);
    }

    private ObjectIdRef doPeel(Ref ref) {
        try (RevWalk revWalk = new RevWalk(this.getRepository());){
            RevObject revObject = revWalk.parseAny(ref.getObjectId());
            if (revObject instanceof RevTag) {
                ObjectIdRef$PeeledTag objectIdRef$PeeledTag = new ObjectIdRef$PeeledTag(ref.getStorage(), ref.getName(), ref.getObjectId(), revWalk.peel(revObject).copy());
                return objectIdRef$PeeledTag;
            }
            ObjectIdRef$PeeledNonTag objectIdRef$PeeledNonTag = new ObjectIdRef$PeeledNonTag(ref.getStorage(), ref.getName(), ref.getObjectId());
            return objectIdRef$PeeledNonTag;
        }
    }

    private static Ref recreate(Ref ref, ObjectIdRef objectIdRef) {
        if (ref.isSymbolic()) {
            Ref ref2 = RefDirectory.recreate(ref.getTarget(), objectIdRef);
            return new SymbolicRef(ref.getName(), ref2);
        }
        return objectIdRef;
    }

    void storedSymbolicRef(RefDirectoryUpdate refDirectoryUpdate, FileSnapshot fileSnapshot, String string) {
        this.putLooseRef(RefDirectory.newSymbolicRef(fileSnapshot, refDirectoryUpdate.getRef().getName(), string));
        this.fireRefsChanged();
    }

    @Override
    public RefDirectoryUpdate newUpdate(String string, boolean bl2) {
        boolean bl3 = false;
        RefDirectory$PackedRefList refDirectory$PackedRefList = this.getPackedRefs();
        Ref ref = this.readRef(string, refDirectory$PackedRefList);
        if (ref != null) {
            ref = this.resolve(ref, 0, null, null, refDirectory$PackedRefList);
        }
        if (ref == null) {
            ref = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null);
        } else {
            bl3 = bl2 && ref.isSymbolic();
        }
        RefDirectoryUpdate refDirectoryUpdate = new RefDirectoryUpdate(this, ref);
        if (bl3) {
            refDirectoryUpdate.setDetachingSymbolicRef();
        }
        return refDirectoryUpdate;
    }

    @Override
    public RefDirectoryRename newRename(String string, String string2) {
        RefDirectoryUpdate refDirectoryUpdate = this.newUpdate(string, false);
        RefDirectoryUpdate refDirectoryUpdate2 = this.newUpdate(string2, false);
        return new RefDirectoryRename(refDirectoryUpdate, refDirectoryUpdate2);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate() {
        return new PackedBatchRefUpdate(this);
    }

    public PackedBatchRefUpdate newBatchUpdate(boolean bl2) {
        return new PackedBatchRefUpdate(this, bl2);
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    void stored(RefDirectoryUpdate refDirectoryUpdate, FileSnapshot fileSnapshot) {
        ObjectId objectId = refDirectoryUpdate.getNewObjectId().copy();
        Ref ref = refDirectoryUpdate.getRef().getLeaf();
        this.putLooseRef(new RefDirectory$LooseUnpeeled(fileSnapshot, ref.getName(), objectId));
    }

    private void putLooseRef(RefDirectory$LooseRef refDirectory$LooseRef) {
        RefList refList;
        RefList refList2;
        while (!this.looseRefs.compareAndSet(refList2 = (RefList)this.looseRefs.get(), refList = refList2.put(refDirectory$LooseRef))) {
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(RefDirectoryUpdate refDirectoryUpdate) {
        int n2;
        RefList refList;
        Object object;
        Ref ref = refDirectoryUpdate.getRef();
        if (!refDirectoryUpdate.isDetachingSymbolicRef()) {
            ref = ref.getLeaf();
        }
        String string = ref.getName();
        RefDirectory$PackedRefList refDirectory$PackedRefList = this.getPackedRefs();
        if (refDirectory$PackedRefList.contains(string)) {
            this.inProcessPackedRefsLock.lock();
            try {
                object = this.lockPackedRefsOrThrow();
                try {
                    refList = this.readPackedRefs();
                    n2 = refList.find(string);
                    if (0 <= n2) {
                        this.commitPackedRefs((LockFile)object, refList.remove(n2), refDirectory$PackedRefList, true);
                    }
                }
                finally {
                    ((LockFile)object).unlock();
                }
            }
            finally {
                this.inProcessPackedRefsLock.unlock();
            }
        }
        while ((n2 = ((RefList)(object = (RefList)this.looseRefs.get())).find(string)) >= 0 && !this.looseRefs.compareAndSet(object, refList = ((RefList)object).remove(n2))) {
        }
        n2 = RefDirectory.levelsIn(string) - 2;
        RefDirectory.delete(this.logFor(string), n2);
        if (ref.getStorage().isLoose()) {
            refDirectoryUpdate.unlock();
            RefDirectory.delete(this.fileFor(string), n2);
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    public void pack(List list) {
        this.pack(list, Collections.emptyMap());
    }

    RefDirectory$PackedRefList pack(Map map) {
        return this.pack(map.keySet(), map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefDirectory$PackedRefList pack(Collection collection, Map map) {
        for (LockFile lockFile : map.values()) {
            lockFile.requireLock();
        }
        if (collection.isEmpty()) {
            return null;
        }
        FS fS = this.parent.getFS();
        this.inProcessPackedRefsLock.lock();
        try {
            Object object;
            Object object2;
            RefList refList;
            RefDirectory$PackedRefList refDirectory$PackedRefList;
            LockFile lockFile;
            block20: {
                lockFile = this.lockPackedRefsOrThrow();
                refDirectory$PackedRefList = this.getPackedRefs();
                refList = this.readPackedRefs();
                boolean bl2 = false;
                for (Object object3 : collection) {
                    Object object4 = this.readRef((String)object3, refList);
                    if (object4 == null || object4.isSymbolic() || (object2 = this.peeledPackedRef((Ref)object4)) == object4) continue;
                    bl2 = true;
                    int n2 = refList.find((String)object3);
                    if (n2 >= 0) {
                        refList = refList.set(n2, (Ref)object2);
                        continue;
                    }
                    refList = refList.add(n2, (Ref)object2);
                }
                if (bl2) break block20;
                object = refDirectory$PackedRefList;
                lockFile.unlock();
                return object;
            }
            try {
                Object object3;
                object = this.commitPackedRefs(lockFile, refList, refDirectory$PackedRefList, false);
                for (Object object4 : collection) {
                    boolean bl3;
                    object2 = this.fileFor((String)object4);
                    if (!fS.exists((File)object2)) continue;
                    LockFile lockFile2 = (LockFile)map.get(object4);
                    if (lockFile2 == null) {
                        lockFile2 = new LockFile((File)object2, fS);
                        if (!lockFile2.lock()) continue;
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                    try {
                        RefList refList2;
                        RefList refList3;
                        int n3;
                        RefDirectory$LooseRef refDirectory$LooseRef = this.scanRef(null, (String)object4);
                        if (refDirectory$LooseRef == null || refDirectory$LooseRef.isSymbolic()) continue;
                        Ref ref = refList.get((String)object4);
                        ObjectId objectId = refDirectory$LooseRef.getObjectId();
                        if (objectId == null || !objectId.equals(ref.getObjectId())) continue;
                        while ((n3 = (refList3 = (RefList)this.looseRefs.get()).find((String)object4)) >= 0 && !this.looseRefs.compareAndSet(refList3, refList2 = refList3.remove(n3))) {
                        }
                        n3 = RefDirectory.levelsIn((String)object4) - 2;
                        RefDirectory.delete((File)object2, n3, lockFile2);
                    }
                    finally {
                        if (!bl3) continue;
                        lockFile2.unlock();
                    }
                }
                object3 = object;
                lockFile.unlock();
                return object3;
            }
            catch (Throwable throwable) {
                lockFile.unlock();
                throw throwable;
            }
        }
        finally {
            this.inProcessPackedRefsLock.unlock();
        }
    }

    @Nullable
    LockFile lockPackedRefs() {
        LockFile lockFile = new LockFile(this.packedRefsFile, this.parent.getFS());
        Iterator iterator = this.getRetrySleepMs().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            RefDirectory.sleep(n2);
            if (!lockFile.lock()) continue;
            return lockFile;
        }
        return null;
    }

    private LockFile lockPackedRefsOrThrow() {
        LockFile lockFile = this.lockPackedRefs();
        if (lockFile == null) {
            throw new LockFailedException(this.packedRefsFile);
        }
        return lockFile;
    }

    private Ref peeledPackedRef(Ref ref) {
        ObjectId objectId;
        if (ref.getStorage().isPacked() && ref.isPeeled()) {
            return ref;
        }
        if (!ref.isPeeled()) {
            ref = this.peel(ref);
        }
        if ((objectId = ref.getPeeledObjectId()) != null) {
            return new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, ref.getName(), ref.getObjectId(), objectId);
        }
        return new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, ref.getName(), ref.getObjectId());
    }

    void log(boolean bl2, RefUpdate refUpdate, String string, boolean bl3) {
        this.newLogWriter(bl2).log(refUpdate, string, bl3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ref resolve(Ref ref, int n2, String string, RefList refList, RefList refList2) {
        if (!ref.isSymbolic()) return ref;
        Ref ref2 = ref.getTarget();
        if (5 <= n2) {
            return null;
        }
        if (refList != null && ref2.getName().startsWith(string)) {
            int n3 = refList.find(ref2.getName());
            if (0 <= n3) {
                ref2 = refList.get(n3);
            } else {
                n3 = refList2.find(ref2.getName());
                if (0 > n3) return ref;
                ref2 = refList2.get(n3);
            }
        } else if ((ref2 = this.readRef(ref2.getName(), refList2)) == null) {
            return ref;
        }
        if ((ref2 = this.resolve(ref2, n2 + 1, string, refList, refList2)) != null) return new SymbolicRef(ref.getName(), ref2);
        return null;
    }

    RefDirectory$PackedRefList getPackedRefs() {
        boolean bl2 = this.getRepository().getConfig().getBoolean("core", "trustfolderstat", true);
        RefDirectory$PackedRefList refDirectory$PackedRefList = (RefDirectory$PackedRefList)this.packedRefs.get();
        if (bl2 && !RefDirectory$PackedRefList.access$000(refDirectory$PackedRefList).isModified(this.packedRefsFile)) {
            return refDirectory$PackedRefList;
        }
        RefDirectory$PackedRefList refDirectory$PackedRefList2 = this.readPackedRefs();
        if (this.packedRefs.compareAndSet(refDirectory$PackedRefList, refDirectory$PackedRefList2) && !RefDirectory$PackedRefList.access$100(refDirectory$PackedRefList).equals(RefDirectory$PackedRefList.access$100(refDirectory$PackedRefList2))) {
            this.modCnt.incrementAndGet();
        }
        return refDirectory$PackedRefList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefDirectory$PackedRefList readPackedRefs() {
        int n2 = 5;
        int n3 = 0;
        while (true) {
            FileSnapshot fileSnapshot = FileSnapshot.save(this.packedRefsFile, FS.DETECTED);
            MessageDigest messageDigest = Constants.newMessageDigest();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new DigestInputStream(new FileInputStream(this.packedRefsFile), messageDigest), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    RefDirectory$PackedRefList refDirectory$PackedRefList = new RefDirectory$PackedRefList(this.parsePackedRefs(bufferedReader), fileSnapshot, ObjectId.fromRaw(messageDigest.digest()), null);
                    return refDirectory$PackedRefList;
                }
                catch (IOException iOException) {
                    if (FileUtils.isStaleFileHandleInCausalChain(iOException) && n3 < n2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(MessageFormat.format(JGitText.get().packedRefsHandleIsStale, n3), (Throwable)iOException);
                        }
                        ++n3;
                        continue;
                    }
                    try {
                        throw iOException;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!this.packedRefsFile.exists()) return NO_PACKED_REFS;
                throw fileNotFoundException;
            }
        }
    }

    private RefList parsePackedRefs(BufferedReader bufferedReader) {
        String string;
        RefList$Builder refList$Builder = new RefList$Builder();
        Ref ref = null;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.charAt(0) == '#') {
                if (!string.startsWith(PACKED_REFS_HEADER)) continue;
                string = string.substring(PACKED_REFS_HEADER.length());
                bl2 = string.contains(PACKED_REFS_PEELED);
                continue;
            }
            if (string.charAt(0) == '^') {
                if (ref == null) {
                    throw new IOException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId objectId = ObjectId.parse(string.substring(1));
                ref = new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, ref.getName(), ref.getObjectId(), objectId);
                refList$Builder.set(refList$Builder.size() - 1, ref);
                continue;
            }
            int n2 = string.indexOf(32);
            if (n2 < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().packedRefsCorruptionDetected, this.packedRefsFile.getAbsolutePath()));
            }
            ObjectId objectId = ObjectId.parse(string.substring(0, n2));
            String string2 = RefDirectory.copy(string, n2 + 1, string.length());
            ObjectIdRef objectIdRef = bl2 ? new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, string2, objectId) : new ObjectIdRef$Unpeeled(Ref$Storage.PACKED, string2, objectId);
            if (ref != null && RefComparator.compareTo(ref, objectIdRef) > 0) {
                bl3 = true;
            }
            refList$Builder.add(objectIdRef);
            ref = objectIdRef;
        }
        if (bl3) {
            refList$Builder.sort();
        }
        return refList$Builder.toRefList();
    }

    private static String copy(String string, int n2, int n3) {
        return new StringBuilder(n3 - n2).append(string, n2, n3).toString();
    }

    RefDirectory$PackedRefList commitPackedRefs(LockFile lockFile, RefList refList, RefDirectory$PackedRefList refDirectory$PackedRefList, boolean bl2) {
        AtomicReference atomicReference = new AtomicReference();
        new RefDirectory$1(this, refList, lockFile, refList, refDirectory$PackedRefList, bl2, atomicReference).writePackedRefs();
        return (RefDirectory$PackedRefList)atomicReference.get();
    }

    private Ref readRef(String string, RefList refList) {
        RefList refList2 = (RefList)this.looseRefs.get();
        int n2 = refList2.find(string);
        if (0 <= n2) {
            RefDirectory$LooseRef refDirectory$LooseRef = (RefDirectory$LooseRef)refList2.get(n2);
            RefDirectory$LooseRef refDirectory$LooseRef2 = this.scanRef(refDirectory$LooseRef, string);
            if (refDirectory$LooseRef2 == null) {
                if (this.looseRefs.compareAndSet(refList2, refList2.remove(n2))) {
                    this.modCnt.incrementAndGet();
                }
                return refList.get(string);
            }
            if (refDirectory$LooseRef == refDirectory$LooseRef2) {
                return refDirectory$LooseRef2;
            }
            if (this.looseRefs.compareAndSet(refList2, refList2.set(n2, refDirectory$LooseRef2))) {
                this.modCnt.incrementAndGet();
            }
            return refDirectory$LooseRef2;
        }
        RefDirectory$LooseRef refDirectory$LooseRef = this.scanRef(null, string);
        if (refDirectory$LooseRef == null) {
            return refList.get(string);
        }
        for (String string2 : additionalRefsNames) {
            if (!string.equals(string2)) continue;
            return refDirectory$LooseRef;
        }
        if (this.looseRefs.compareAndSet(refList2, refList2.add(n2, refDirectory$LooseRef))) {
            this.modCnt.incrementAndGet();
        }
        return refDirectory$LooseRef;
    }

    RefDirectory$LooseRef scanRef(RefDirectory$LooseRef refDirectory$LooseRef, String string) {
        ObjectId objectId;
        int n2;
        byte[] byArray;
        FileSnapshot fileSnapshot;
        File file = this.fileFor(string);
        FileSnapshot fileSnapshot2 = null;
        if (refDirectory$LooseRef != null) {
            fileSnapshot2 = refDirectory$LooseRef.getSnapShot();
            if (!fileSnapshot2.isModified(file)) {
                return refDirectory$LooseRef;
            }
            string = refDirectory$LooseRef.getName();
        }
        int n3 = 4096;
        try {
            fileSnapshot = FileSnapshot.save(file, this.parent.getFS());
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException(invalidPathException);
        }
        try {
            byArray = IO.readSome(file, 4096);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file.isFile()) {
                throw fileNotFoundException;
            }
            return null;
        }
        if (n2 == 0) {
            return null;
        }
        if (RefDirectory.isSymRef(byArray, n2)) {
            if (n2 == 4096) {
                return null;
            }
            for (n2 = byArray.length; 0 < n2 && Character.isWhitespace(byArray[n2 - 1]); --n2) {
            }
            if (n2 < 6) {
                String string2 = RawParseUtils.decode(byArray, 0, n2);
                throw new IOException(MessageFormat.format(JGitText.get().notARef, string, string2));
            }
            String string3 = RawParseUtils.decode(byArray, 5, n2);
            if (refDirectory$LooseRef != null && refDirectory$LooseRef.isSymbolic() && refDirectory$LooseRef.getTarget().getName().equals(string3)) {
                assert (fileSnapshot2 != null);
                fileSnapshot2.setClean(fileSnapshot);
                return refDirectory$LooseRef;
            }
            return RefDirectory.newSymbolicRef(fileSnapshot, string, string3);
        }
        if (n2 < 40) {
            LOG.warn("Invalid ref '" + string + "': '" + RawParseUtils.decode(byArray, 0, n2) + "'");
            return null;
        }
        try {
            objectId = ObjectId.fromString(byArray, 0);
            if (refDirectory$LooseRef != null && !refDirectory$LooseRef.isSymbolic() && objectId.equals(refDirectory$LooseRef.getTarget().getObjectId())) {
                assert (fileSnapshot2 != null);
                fileSnapshot2.setClean(fileSnapshot);
                return refDirectory$LooseRef;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Invalid ref '" + string + "': '" + RawParseUtils.decode(byArray, 0, Math.min(n2, 128)) + "'");
            return null;
        }
        return new RefDirectory$LooseUnpeeled(fileSnapshot, string, objectId);
    }

    private static boolean isSymRef(byte[] byArray, int n2) {
        if (n2 < 6) {
            return false;
        }
        return byArray[0] == 114 && byArray[1] == 101 && byArray[2] == 102 && byArray[3] == 58 && byArray[4] == 32;
    }

    boolean isInClone() {
        return this.hasDanglingHead() && !this.packedRefsFile.exists() && !this.hasLooseRef();
    }

    private boolean hasDanglingHead() {
        Ref ref = this.exactRef("HEAD");
        if (ref != null) {
            ObjectId objectId = ref.getObjectId();
            return objectId == null || objectId.equals(ObjectId.zeroId());
        }
        return false;
    }

    private boolean hasLooseRef() {
        try (Stream<Path> stream = Files.walk(this.refsDir.toPath(), new FileVisitOption[0]);){
            boolean bl2 = stream.anyMatch(path -> Files.isRegularFile(path, new LinkOption[0]));
            return bl2;
        }
    }

    void fireRefsChanged() {
        int n2;
        int n3 = this.lastNotifiedModCnt.get();
        if (n3 != (n2 = this.modCnt.get()) && this.lastNotifiedModCnt.compareAndSet(n3, n2) && n3 != 0) {
            this.parent.fireEvent(new RefsChangedEvent());
        }
    }

    RefDirectoryUpdate newTemporaryUpdate() {
        File file = File.createTempFile("renamed_", "_ref", this.refsDir);
        String string = "refs/" + file.getName();
        ObjectIdRef$Unpeeled objectIdRef$Unpeeled = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null);
        return new RefDirectoryUpdate(this, objectIdRef$Unpeeled);
    }

    File fileFor(String string) {
        if (string.startsWith("refs/")) {
            string = string.substring("refs/".length());
            return new File(this.refsDir, string);
        }
        return new File(this.gitDir, string);
    }

    static int levelsIn(String string) {
        int n2 = 0;
        int n3 = string.indexOf(47);
        while (n3 >= 0) {
            ++n2;
            n3 = string.indexOf(47, n3 + 1);
        }
        return n2;
    }

    static void delete(File file, int n2) {
        RefDirectory.delete(file, n2, null);
    }

    private static void delete(File file, int n2, LockFile lockFile) {
        if (!file.delete() && file.isFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileCannotBeDeleted, file));
        }
        if (lockFile != null) {
            lockFile.unlock();
        }
        File file2 = file.getParentFile();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                Files.deleteIfExists(file2.toPath());
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                break;
            }
            catch (IOException iOException) {
                LOG.warn(MessageFormat.format(JGitText.get().unableToRemovePath, file2), (Throwable)iOException);
                break;
            }
            file2 = file2.getParentFile();
        }
    }

    Iterable getRetrySleepMs() {
        return this.retrySleepMs;
    }

    void setRetrySleepMs(List list) {
        if (list == null || list.isEmpty() || (Integer)list.get(0) != 0) {
            throw new IllegalArgumentException();
        }
        this.retrySleepMs = list;
    }

    static void sleep(long l2) {
        if (l2 <= 0L) {
            return;
        }
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException();
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
    }

    private static RefDirectory$LooseSymbolicRef newSymbolicRef(FileSnapshot fileSnapshot, String string, String string2) {
        ObjectIdRef$Unpeeled objectIdRef$Unpeeled = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string2, null);
        return new RefDirectory$LooseSymbolicRef(fileSnapshot, string, objectIdRef$Unpeeled);
    }

    static /* synthetic */ AtomicInteger access$300(RefDirectory refDirectory) {
        return refDirectory.modCnt;
    }
}

