/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.transport.ReceiveCommand$Type;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefList$Builder;

class PackedBatchRefUpdate
extends BatchRefUpdate {
    private RefDirectory refdb;
    private boolean shouldLockLooseRefs;

    PackedBatchRefUpdate(RefDirectory refDirectory) {
        this(refDirectory, true);
    }

    PackedBatchRefUpdate(RefDirectory refDirectory, boolean bl2) {
        super(refDirectory);
        this.refdb = refDirectory;
        this.shouldLockLooseRefs = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(RevWalk var1_1, ProgressMonitor var2_2, List var3_3) {
        block35: {
            block33: {
                block38: {
                    block31: {
                        if (!this.isAtomic()) {
                            super.execute(var1_1, var2_2, var3_3);
                            return;
                        }
                        var4_4 = ReceiveCommand.filter(this.getCommands(), ReceiveCommand$Result.NOT_ATTEMPTED);
                        if (var4_4.isEmpty()) {
                            return;
                        }
                        if (var4_4.size() == 1) {
                            super.execute(var1_1, var2_2, var3_3);
                            return;
                        }
                        if (PackedBatchRefUpdate.containsSymrefs(var4_4)) {
                            PackedBatchRefUpdate.reject((ReceiveCommand)var4_4.get(0), ReceiveCommand$Result.REJECTED_OTHER_REASON, JGitText.get().atomicSymRefNotSupported, var4_4);
                            return;
                        }
                        if (!this.blockUntilTimestamps(PackedBatchRefUpdate.MAX_WAIT)) {
                            return;
                        }
                        if (var3_3 != null) {
                            this.setPushOptions(var3_3);
                        }
                        if (!this.checkConflictingNames(var4_4)) {
                            return;
                        }
                        if (!this.checkObjectExistence(var1_1, var4_4)) {
                            return;
                        }
                        if (!this.checkNonFastForwards(var1_1, var4_4)) {
                            return;
                        }
                        try {
                            this.refdb.pack(var4_4.stream().map((Function<ReceiveCommand, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRefName(), (Lorg/eclipse/jgit/transport/ReceiveCommand;)Ljava/lang/String;)()).collect(Collectors.toList()));
                        }
                        catch (LockFailedException var5_5) {
                            PackedBatchRefUpdate.lockFailure((ReceiveCommand)var4_4.get(0), var4_4);
                            return;
                        }
                        var5_6 = null;
                        this.refdb.inProcessPackedRefsLock.lock();
                        try {
                            if (this.refdb.isInClone() || !this.shouldLockLooseRefs) ** GOTO lbl56
                            var5_6 = this.lockLooseRefs(var4_4);
                            if (var5_6 != null) break block31;
                        }
                        catch (Throwable var11_14) {
                            try {
                                PackedBatchRefUpdate.unlockAll(var5_6);
                            }
                            finally {
                                this.refdb.inProcessPackedRefsLock.unlock();
                            }
                            throw var11_14;
                        }
                        try {
                            PackedBatchRefUpdate.unlockAll(var5_6);
                        }
                        finally {
                            this.refdb.inProcessPackedRefsLock.unlock();
                        }
                        return;
                    }
                    var6_9 = this.refdb.pack(var5_6);
                    break block38;
lbl56:
                    // 1 sources

                    var6_9 = this.refdb.getPackedRefs();
                }
                var7_8 = PackedBatchRefUpdate.applyUpdates(var1_1, var6_9, var4_4);
                if (var7_8 != null) break block33;
                try {
                    PackedBatchRefUpdate.unlockAll(var5_6);
                }
                finally {
                    this.refdb.inProcessPackedRefsLock.unlock();
                }
                return;
            }
            var8_11 = this.refdb.lockPackedRefs();
            if (var8_11 != null) break block35;
            PackedBatchRefUpdate.lockFailure((ReceiveCommand)var4_4.get(0), var4_4);
            try {
                PackedBatchRefUpdate.unlockAll(var5_6);
            }
            finally {
                this.refdb.inProcessPackedRefsLock.unlock();
            }
            return;
        }
        this.refdb.commitPackedRefs(var8_11, var7_8, var6_9, true);
        try {
            PackedBatchRefUpdate.unlockAll(var5_6);
        }
        finally {
            this.refdb.inProcessPackedRefsLock.unlock();
        }
        this.refdb.fireRefsChanged();
        var4_4.forEach((Consumer<ReceiveCommand>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$0(org.eclipse.jgit.transport.ReceiveCommand ), (Lorg/eclipse/jgit/transport/ReceiveCommand;)V)());
        this.writeReflog(var4_4);
    }

    private static boolean containsSymrefs(List list) {
        for (ReceiveCommand receiveCommand : list) {
            if (receiveCommand.getOldSymref() == null && receiveCommand.getNewSymref() == null) continue;
            return true;
        }
        return false;
    }

    private boolean checkConflictingNames(List list) {
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (Object object2 : list) {
            if (((ReceiveCommand)object2).getType() != ReceiveCommand$Type.DELETE) {
                hashSet.add(((ReceiveCommand)object2).getRefName());
                PackedBatchRefUpdate.addPrefixesTo(((ReceiveCommand)object2).getRefName(), hashSet2);
                continue;
            }
            hashSet3.add(((ReceiveCommand)object2).getRefName());
        }
        Set set = this.refdb.getRefs("").keySet();
        object2 = set.iterator();
        while (object2.hasNext()) {
            Object object3 = (String)object2.next();
            if (hashSet3.contains(object3)) continue;
            hashSet.add((String)object3);
            PackedBatchRefUpdate.addPrefixesTo((String)object3, hashSet2);
        }
        for (Object object3 : list) {
            if (((ReceiveCommand)object3).getType() != ReceiveCommand$Type.DELETE && hashSet2.contains(((ReceiveCommand)object3).getRefName())) {
                PackedBatchRefUpdate.lockFailure((ReceiveCommand)object3, list);
                return false;
            }
            for (String string : PackedBatchRefUpdate.getPrefixes(((ReceiveCommand)object3).getRefName())) {
                if (!hashSet.contains(string)) continue;
                PackedBatchRefUpdate.lockFailure((ReceiveCommand)object3, list);
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectExistence(RevWalk revWalk, List list) {
        for (ReceiveCommand receiveCommand : list) {
            try {
                if (receiveCommand.getNewId().equals(ObjectId.zeroId())) continue;
                revWalk.parseAny(receiveCommand.getNewId());
            }
            catch (MissingObjectException missingObjectException) {
                PackedBatchRefUpdate.reject(receiveCommand, ReceiveCommand$Result.REJECTED_MISSING_OBJECT, list);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk revWalk, List list) {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand receiveCommand : list) {
            receiveCommand.updateType(revWalk);
            if (receiveCommand.getType() != ReceiveCommand$Type.UPDATE_NONFASTFORWARD) continue;
            PackedBatchRefUpdate.reject(receiveCommand, ReceiveCommand$Result.REJECTED_NONFASTFORWARD, list);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map lockLooseRefs(List list) {
        Object object = null;
        HashMap<String, LockFile> hashMap = new HashMap<String, LockFile>();
        try {
            Iterator iterator = this.refdb.getRetrySleepMs().iterator();
            block3: while (iterator.hasNext()) {
                Object object22;
                int n2 = (Integer)iterator.next();
                object = null;
                PackedBatchRefUpdate.unlockAll(hashMap);
                hashMap.clear();
                RefDirectory.sleep(n2);
                for (Object object22 : list) {
                    LockFile lockFile;
                    String string = ((ReceiveCommand)object22).getRefName();
                    if (hashMap.put(string, lockFile = new LockFile(this.refdb.fileFor(string), this.refdb.getRepository().getFS())) != null) {
                        throw new IOException(MessageFormat.format(JGitText.get().duplicateRef, string));
                    }
                    if (lockFile.lock()) continue;
                    object = object22;
                    continue block3;
                }
                HashMap<String, LockFile> hashMap2 = hashMap;
                hashMap = null;
                object22 = hashMap2;
                return object22;
            }
        }
        finally {
            PackedBatchRefUpdate.unlockAll(hashMap);
        }
        PackedBatchRefUpdate.lockFailure(object != null ? object : (ReceiveCommand)list.get(0), list);
        return null;
    }

    private static RefList applyUpdates(RevWalk revWalk, RefList refList, List list) {
        Collections.sort(list, Comparator.comparing(ReceiveCommand::getRefName));
        int n2 = 0;
        for (ReceiveCommand receiveCommand : list) {
            switch (receiveCommand.getType()) {
                case DELETE: {
                    --n2;
                    break;
                }
                case CREATE: {
                    ++n2;
                    break;
                }
            }
        }
        RefList$Builder refList$Builder = new RefList$Builder(refList.size() + n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < refList.size() || n4 < list.size()) {
            Ref ref = n3 < refList.size() ? refList.get(n3) : null;
            ReceiveCommand receiveCommand = n4 < list.size() ? (ReceiveCommand)list.get(n4) : null;
            int n5 = 0;
            if (ref != null && receiveCommand != null) {
                n5 = ref.getName().compareTo(receiveCommand.getRefName());
            } else if (ref == null) {
                n5 = 1;
            } else if (receiveCommand == null) {
                n5 = -1;
            }
            if (n5 < 0) {
                refList$Builder.add(ref);
                ++n3;
                continue;
            }
            if (n5 > 0) {
                assert (receiveCommand != null);
                if (receiveCommand.getType() != ReceiveCommand$Type.CREATE) {
                    PackedBatchRefUpdate.lockFailure(receiveCommand, list);
                    return null;
                }
                refList$Builder.add(PackedBatchRefUpdate.peeledRef(revWalk, receiveCommand));
                ++n4;
                continue;
            }
            assert (receiveCommand != null);
            assert (ref != null);
            if (!receiveCommand.getOldId().equals(ref.getObjectId())) {
                PackedBatchRefUpdate.lockFailure(receiveCommand, list);
                return null;
            }
            if (receiveCommand.getType() != ReceiveCommand$Type.DELETE) {
                refList$Builder.add(PackedBatchRefUpdate.peeledRef(revWalk, receiveCommand));
            }
            ++n4;
            ++n3;
        }
        return refList$Builder.toRefList();
    }

    private void writeReflog(List list) {
        PersonIdent personIdent = this.getRefLogIdent();
        if (personIdent == null) {
            personIdent = new PersonIdent(this.refdb.getRepository());
        }
        for (ReceiveCommand receiveCommand : list) {
            String string;
            if (receiveCommand.getResult() != ReceiveCommand$Result.OK) continue;
            String string2 = receiveCommand.getRefName();
            if (receiveCommand.getType() == ReceiveCommand$Type.DELETE) {
                try {
                    RefDirectory.delete(this.refdb.logFor(string2), RefDirectory.levelsIn(string2));
                }
                catch (IOException iOException) {}
                continue;
            }
            if (this.isRefLogDisabled(receiveCommand)) continue;
            String string3 = this.getRefLogMessage(receiveCommand);
            if (this.isRefLogIncludingResult(receiveCommand) && (string = this.toResultString(receiveCommand)) != null) {
                string3 = string3.isEmpty() ? string : string3 + ": " + string;
            }
            try {
                new ReflogWriter(this.refdb, this.isForceRefLog(receiveCommand)).log(string2, receiveCommand.getOldId(), receiveCommand.getNewId(), personIdent, string3);
            }
            catch (IOException iOException) {}
        }
    }

    private String toResultString(ReceiveCommand receiveCommand) {
        switch (receiveCommand.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static Ref peeledRef(RevWalk revWalk, ReceiveCommand receiveCommand) {
        ObjectId objectId = receiveCommand.getNewId().copy();
        RevObject revObject = revWalk.parseAny(objectId);
        if (revObject instanceof RevTag) {
            return new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, receiveCommand.getRefName(), objectId, revWalk.peel(revObject).copy());
        }
        return new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, receiveCommand.getRefName(), objectId);
    }

    private static void unlockAll(@Nullable Map map) {
        if (map != null) {
            map.values().forEach(LockFile::unlock);
        }
    }

    private static void lockFailure(ReceiveCommand receiveCommand, List list) {
        PackedBatchRefUpdate.reject(receiveCommand, ReceiveCommand$Result.LOCK_FAILURE, list);
    }

    private static void reject(ReceiveCommand receiveCommand, ReceiveCommand$Result receiveCommand$Result, List list) {
        PackedBatchRefUpdate.reject(receiveCommand, receiveCommand$Result, null, list);
    }

    private static void reject(ReceiveCommand receiveCommand, ReceiveCommand$Result receiveCommand$Result, String string, List list) {
        receiveCommand.setResult(receiveCommand$Result, string);
        for (ReceiveCommand receiveCommand2 : list) {
            if (receiveCommand2.getResult() != ReceiveCommand$Result.OK) continue;
            receiveCommand2.setResult(ReceiveCommand$Result.NOT_ATTEMPTED);
        }
        ReceiveCommand.abort(list);
    }

    private static /* synthetic */ void lambda$execute$0(ReceiveCommand receiveCommand) {
        receiveCommand.setResult(ReceiveCommand$Result.OK);
    }
}

