/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.lib.ObjectId;

public class PackReverseIndex {
    private final PackIndex index;
    private final long bucketSize;
    private final int[] offsetIndex;
    private final int[] nth;

    public PackReverseIndex(PackIndex packIndex) {
        int n2;
        Object object;
        int n3;
        Object object22;
        this.index = packIndex;
        long l2 = this.index.getObjectCount();
        if (l2 + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(JGitText.get().hugeIndexesAreNotSupportedByJgitYet);
        }
        if (l2 == 0L) {
            this.bucketSize = Long.MAX_VALUE;
            this.offsetIndex = new int[1];
            this.nth = new int[0];
            return;
        }
        long[] lArray = new long[(int)l2];
        long l3 = 0L;
        int n4 = 0;
        for (Object object22 : this.index) {
            long l4 = ((PackIndex$MutableEntry)object22).getOffset();
            lArray[n4++] = l4;
            if (l4 <= l3) continue;
            l3 = l4;
        }
        this.bucketSize = l3 / l2 + 1L;
        Object object3 = new int[(int)l2];
        object22 = new int[(int)l2 + 1];
        for (n3 = 0; n3 < lArray.length; ++n3) {
            long l5 = lArray[n3];
            object = (int)(l5 / this.bucketSize);
            n2 = n3 + 1;
            Object object4 = object3[object];
            object3[object] = n2;
            object22[n2] = object4;
        }
        n3 = 0;
        this.nth = new int[lArray.length];
        this.offsetIndex = (int[])object3;
        for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
            int n5 = n3;
            object = object3[i2];
            while (object > 0) {
                n2 = object - 1;
                long l6 = lArray[n2];
                for (int i3 = n3++; n5 < i3 && l6 <= lArray[this.nth[i3 - 1]]; --i3) {
                    this.nth[i3] = this.nth[i3 - 1];
                }
                this.nth[i3] = n2;
                object = object22[object];
            }
            this.offsetIndex[i2] = n3;
        }
    }

    public ObjectId findObject(long l2) {
        int n2 = this.binarySearch(l2);
        if (n2 < 0) {
            return null;
        }
        return this.index.getObjectId(this.nth[n2]);
    }

    public long findNextOffset(long l2, long l3) {
        int n2 = this.binarySearch(l2);
        if (n2 < 0) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().cantFindObjectInReversePackIndexForTheSpecifiedOffset, l2));
        }
        if (n2 + 1 == this.nth.length) {
            return l3;
        }
        return this.index.getOffset(this.nth[n2 + 1]);
    }

    int findPostion(long l2) {
        return this.binarySearch(l2);
    }

    private int binarySearch(long l2) {
        int n2 = (int)(l2 / this.bucketSize);
        int n3 = n2 == 0 ? 0 : this.offsetIndex[n2 - 1];
        int n4 = this.offsetIndex[n2];
        while (n3 < n4) {
            int n5 = n3 + n4 >>> 1;
            long l3 = this.index.getOffset(this.nth[n5]);
            if (l2 < l3) {
                n4 = n5;
                continue;
            }
            if (l2 == l3) {
                return n5;
            }
            n3 = n5 + 1;
        }
        return -1;
    }

    ObjectId findObjectByPosition(int n2) {
        return this.index.getObjectId(this.nth[n2]);
    }
}

