/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class PackLock {
    private final File keepFile;
    private final FS fs;

    public PackLock(File file, FS fS) {
        this.fs = fS;
        File file2 = file.getParentFile();
        String string = file.getName();
        this.keepFile = new File(file2, string.substring(0, string.length() - 5) + ".keep");
    }

    public boolean lock(String string) {
        LockFile lockFile;
        if (string == null) {
            return false;
        }
        if (!string.endsWith("\n")) {
            string = string + "\n";
        }
        if (!(lockFile = new LockFile(this.keepFile, this.fs)).lock()) {
            return false;
        }
        lockFile.write(Constants.encode(string));
        return lockFile.commit();
    }

    public void unlock() {
        FileUtils.delete(this.keepFile);
    }
}

