/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.file.PackInserter$PackStream;
import org.eclipse.jgit.internal.storage.file.PackInserter$Reader;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.sha1.SHA1;

public class PackInserter
extends ObjectInserter {
    private static final int INDEX_VERSION = 2;
    private final ObjectDirectory db;
    private List objectList;
    private ObjectIdOwnerMap objectMap;
    private boolean rollback;
    private boolean checkExisting = true;
    private int compression = 9;
    private File tmpPack;
    private PackInserter$PackStream packOut;
    private Inflater cachedInflater;
    private PackConfig pconfig;

    PackInserter(ObjectDirectory objectDirectory) {
        this.db = objectDirectory;
        this.pconfig = new PackConfig(objectDirectory.getConfig());
    }

    public void checkExisting(boolean bl2) {
        this.checkExisting = bl2;
    }

    public void setCompressionLevel(int n2) {
        this.compression = n2;
    }

    int getBufferSize() {
        return this.buffer().length;
    }

    @Override
    public ObjectId insert(int n2, byte[] byArray, int n3, int n4) {
        ObjectId objectId = this.idFor(n2, byArray, n3, n4);
        if (this.objectMap != null && this.objectMap.contains(objectId)) {
            return objectId;
        }
        if (this.checkExisting && this.db.hasPackedObject(objectId)) {
            return objectId;
        }
        long l2 = this.beginObject(n2, n4);
        this.packOut.compress.write(byArray, n3, n4);
        this.packOut.compress.finish();
        return this.endObject(objectId, l2);
    }

    @Override
    public ObjectId insert(int n2, long l2, InputStream inputStream) {
        byte[] byArray = this.buffer();
        if (l2 <= (long)byArray.length) {
            IO.readFully(inputStream, byArray, 0, (int)l2);
            return this.insert(n2, byArray, 0, (int)l2);
        }
        long l3 = this.beginObject(n2, l2);
        SHA1 sHA1 = this.digest();
        sHA1.update(Constants.encodedTypeString(n2));
        sHA1.update((byte)32);
        sHA1.update(Constants.encodeASCII(l2));
        sHA1.update((byte)0);
        while (0L < l2) {
            int n3 = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l2));
            if (n3 <= 0) {
                throw new EOFException();
            }
            sHA1.update(byArray, 0, n3);
            this.packOut.compress.write(byArray, 0, n3);
            l2 -= (long)n3;
        }
        this.packOut.compress.finish();
        return this.endObject(sHA1.toObjectId(), l3);
    }

    private long beginObject(int n2, long l2) {
        if (this.packOut == null) {
            this.beginPack();
        }
        long l3 = this.packOut.getOffset();
        this.packOut.beginObject(n2, l2);
        return l3;
    }

    private ObjectId endObject(ObjectId objectId, long l2) {
        PackedObjectInfo packedObjectInfo = new PackedObjectInfo(objectId);
        packedObjectInfo.setOffset(l2);
        packedObjectInfo.setCRC((int)this.packOut.crc32.getValue());
        this.objectList.add(packedObjectInfo);
        this.objectMap.addIfAbsent(packedObjectInfo);
        return objectId;
    }

    private static File idxFor(File file) {
        String string = file.getName();
        return new File(file.getParentFile(), string.substring(0, string.lastIndexOf(46)) + ".idx");
    }

    private void beginPack() {
        this.objectList = new BlockList();
        this.objectMap = new ObjectIdOwnerMap();
        this.rollback = true;
        this.tmpPack = File.createTempFile("insert_", ".pack", this.db.getDirectory());
        this.packOut = new PackInserter$PackStream(this, this.tmpPack);
        this.packOut.write(this.packOut.hdrBuf, 0, PackInserter.writePackHeader(this.packOut.hdrBuf, 1));
    }

    private static int writePackHeader(byte[] byArray, int n2) {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, byArray, 0, 4);
        NB.encodeInt32(byArray, 4, 2);
        NB.encodeInt32(byArray, 8, n2);
        return 12;
    }

    @Override
    public PackParser newPackParser(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectReader newReader() {
        return new PackInserter$Reader(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        byte[] byArray;
        if (this.tmpPack == null) {
            return;
        }
        if (this.packOut == null) {
            throw new IOException();
        }
        try {
            byArray = this.packOut.finishPack();
        }
        finally {
            this.packOut = null;
        }
        Collections.sort(this.objectList);
        File file = PackInserter.idxFor(this.tmpPack);
        PackInserter.writePackIndex(file, byArray, this.objectList);
        PackFile packFile = new PackFile(this.db.getPackDirectory(), this.computeName(this.objectList), PackExt.PACK);
        this.db.closeAllPackHandles(packFile);
        this.tmpPack.setReadOnly();
        FileUtils.rename(this.tmpPack, packFile, StandardCopyOption.ATOMIC_MOVE);
        PackFile packFile2 = packFile.create(PackExt.INDEX);
        file.setReadOnly();
        try {
            FileUtils.rename(file, packFile2, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            IOException iOException2;
            File file2 = new File(packFile2.getParentFile(), packFile2.getName() + ".new");
            try {
                FileUtils.rename(file, file2, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException iOException3) {
                file2 = file;
                iOException2 = iOException3;
            }
            throw new IOException(MessageFormat.format(JGitText.get().panicCantRenameIndexFile, file2, packFile2), iOException2);
        }
        boolean bl2 = false;
        try {
            FileSnapshot fileSnapshot = FileSnapshot.save(packFile, FS.DETECTED);
            if (this.pconfig.doWaitPreventRacyPack(fileSnapshot.size())) {
                fileSnapshot.waitUntilNotRacy();
            }
        }
        catch (InterruptedException interruptedException) {
            bl2 = true;
        }
        try {
            this.db.openPack(packFile);
            this.rollback = false;
        }
        finally {
            this.clear();
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void writePackIndex(File file, byte[] byArray, List list) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            PackIndexWriter packIndexWriter = PackIndexWriter.createVersion(fileOutputStream, 2);
            packIndexWriter.write(list, byArray);
        }
    }

    private ObjectId computeName(List list) {
        SHA1 sHA1 = this.digest().reset();
        byte[] byArray = this.buffer();
        for (PackedObjectInfo packedObjectInfo : list) {
            packedObjectInfo.copyRawTo(byArray, 0);
            sHA1.update(byArray, 0, 20);
        }
        return ObjectId.fromRaw(sHA1.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block15: {
            try {
                if (this.packOut != null) {
                    try {
                        this.packOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!this.rollback || this.tmpPack == null) break block15;
                try {
                    FileUtils.delete(this.tmpPack);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    FileUtils.delete(PackInserter.idxFor(this.tmpPack));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.rollback = false;
            }
            finally {
                this.clear();
                try {
                    InflaterCache.release(this.cachedInflater);
                }
                finally {
                    this.cachedInflater = null;
                }
            }
        }
    }

    private void clear() {
        this.objectList = null;
        this.objectMap = null;
        this.tmpPack = null;
        this.packOut = null;
    }

    private Inflater inflater() {
        if (this.cachedInflater == null) {
            this.cachedInflater = InflaterCache.get();
        } else {
            this.cachedInflater.reset();
        }
        return this.cachedInflater;
    }

    static /* synthetic */ int access$100(PackInserter packInserter) {
        return packInserter.compression;
    }

    static /* synthetic */ List access$200(PackInserter packInserter) {
        return packInserter.objectList;
    }

    static /* synthetic */ int access$300(byte[] byArray, int n2) {
        return PackInserter.writePackHeader(byArray, n2);
    }

    static /* synthetic */ byte[] access$400(PackInserter packInserter) {
        return packInserter.buffer();
    }

    static /* synthetic */ SHA1 access$500(PackInserter packInserter) {
        return packInserter.digest();
    }

    static /* synthetic */ byte[] access$600(PackInserter packInserter) {
        return packInserter.buffer();
    }

    static /* synthetic */ Inflater access$700(PackInserter packInserter) {
        return packInserter.inflater();
    }

    static /* synthetic */ ObjectDirectory access$800(PackInserter packInserter) {
        return packInserter.db;
    }

    static /* synthetic */ ObjectIdOwnerMap access$900(PackInserter packInserter) {
        return packInserter.objectMap;
    }

    static /* synthetic */ byte[] access$1000(PackInserter packInserter) {
        return packInserter.buffer();
    }

    static /* synthetic */ PackInserter$PackStream access$1100(PackInserter packInserter) {
        return packInserter.packOut;
    }

    static /* synthetic */ File access$1300(PackInserter packInserter) {
        return packInserter.tmpPack;
    }

    static /* synthetic */ byte[] access$1400(PackInserter packInserter) {
        return packInserter.buffer();
    }
}

