/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.internal.storage.file.PackInserter$1;
import org.eclipse.jgit.internal.storage.file.PackInserter$PackStream;
import org.eclipse.jgit.internal.storage.file.PackInserter$Reader$StreamLoader;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectLoader$SmallObject;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackedObjectInfo;

class PackInserter$Reader
extends ObjectReader {
    private final ObjectReader ctx;
    final /* synthetic */ PackInserter this$0;

    private PackInserter$Reader(PackInserter packInserter) {
        this.this$0 = packInserter;
        this.ctx = PackInserter.access$800(packInserter).newReader();
        this.setStreamFileThreshold(this.ctx.getStreamFileThreshold());
    }

    @Override
    public ObjectReader newReader() {
        return PackInserter.access$800(this.this$0).newReader();
    }

    @Override
    public ObjectInserter getCreatedFromInserter() {
        return this.this$0;
    }

    @Override
    public Collection resolve(AbbreviatedObjectId abbreviatedObjectId) {
        Collection collection = this.ctx.resolve(abbreviatedObjectId);
        if (PackInserter.access$200(this.this$0) == null) {
            return collection;
        }
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>(collection.size() + 2);
        hashSet.addAll(collection);
        for (PackedObjectInfo packedObjectInfo : PackInserter.access$200(this.this$0)) {
            if (abbreviatedObjectId.prefixCompare(packedObjectInfo) != 0) continue;
            hashSet.add(packedObjectInfo.copy());
        }
        return hashSet;
    }

    @Override
    public ObjectLoader open(AnyObjectId anyObjectId, int n2) {
        byte[] byArray;
        if (PackInserter.access$900(this.this$0) == null) {
            return this.ctx.open(anyObjectId, n2);
        }
        PackedObjectInfo packedObjectInfo = (PackedObjectInfo)PackInserter.access$900(this.this$0).get(anyObjectId);
        if (packedObjectInfo == null) {
            return this.ctx.open(anyObjectId, n2);
        }
        byte[] byArray2 = PackInserter.access$1000(this.this$0);
        PackInserter.access$1100(this.this$0).seek(packedObjectInfo.getOffset());
        int n3 = PackInserter$PackStream.access$1200(PackInserter.access$1100(this.this$0)).read(byArray2, 0, 20);
        if (n3 <= 0) {
            throw new EOFException(JGitText.get().unexpectedEofInPack);
        }
        int n4 = byArray2[0] & 0xFF;
        int n5 = n4 >> 4 & 7;
        if (n5 == 6 || n5 == 7) {
            throw new IOException(MessageFormat.format(JGitText.get().cannotReadBackDelta, Integer.toString(n5)));
        }
        if (n2 != -1 && n5 != n2) {
            throw new IncorrectObjectTypeException(anyObjectId.copy(), n2);
        }
        long l2 = n4 & 0xF;
        int n6 = 1;
        int n7 = 4;
        while ((n4 & 0x80) != 0) {
            if (n6 >= n3) {
                throw new EOFException(JGitText.get().unexpectedEofInPack);
            }
            n4 = byArray2[n6++] & 0xFF;
            l2 += (long)(n4 & 0x7F) << n7;
            n7 += 7;
        }
        long l3 = packedObjectInfo.getOffset() + (long)n6;
        if (l2 < (long)this.getStreamFileThreshold() && (byArray = this.inflate(packedObjectInfo, l3, (int)l2)) != null) {
            return new ObjectLoader$SmallObject(n5, byArray);
        }
        return new PackInserter$Reader$StreamLoader(this, n5, l2, l3);
    }

    private byte[] inflate(PackedObjectInfo packedObjectInfo, long l2, int n2) {
        try {
            return PackInserter.access$1100(this.this$0).inflate(l2, n2);
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, packedObjectInfo.getOffset(), PackInserter.access$1300(this.this$0).getAbsolutePath()), dataFormatException);
        }
    }

    @Override
    public Set getShallowCommits() {
        return this.ctx.getShallowCommits();
    }

    @Override
    public void close() {
        this.ctx.close();
    }

    /* synthetic */ PackInserter$Reader(PackInserter packInserter, PackInserter$1 packInserter$1) {
        this(packInserter);
    }
}

