/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.util.io.CountingOutputStream;
import org.eclipse.jgit.util.sha1.SHA1;

class PackInserter$PackStream
extends OutputStream {
    final byte[] hdrBuf;
    final CRC32 crc32;
    final DeflaterOutputStream compress;
    private final RandomAccessFile file;
    private final CountingOutputStream out;
    private final Deflater deflater;
    private boolean atEnd;
    final /* synthetic */ PackInserter this$0;

    PackInserter$PackStream(PackInserter packInserter, File file) {
        this.this$0 = packInserter;
        this.file = new RandomAccessFile(file, "rw");
        this.out = new CountingOutputStream(new FileOutputStream(this.file.getFD()));
        this.deflater = new Deflater(PackInserter.access$100(packInserter));
        this.compress = new DeflaterOutputStream((OutputStream)this, this.deflater, 8192);
        this.hdrBuf = new byte[32];
        this.crc32 = new CRC32();
        this.atEnd = true;
    }

    long getOffset() {
        return this.out.getCount();
    }

    void seek(long l2) {
        this.file.seek(l2);
        this.atEnd = false;
    }

    void beginObject(int n2, long l2) {
        this.crc32.reset();
        this.deflater.reset();
        this.write(this.hdrBuf, 0, this.encodeTypeSize(n2, l2));
    }

    private int encodeTypeSize(int n2, long l2) {
        long l3 = l2 >>> 4;
        this.hdrBuf[0] = (byte)((long)((l3 > 0L ? 128 : 0) | n2 << 4) | l2 & 0xFL);
        l2 = l3;
        int n3 = 1;
        while (l2 > 0L) {
            this.hdrBuf[n3++] = (byte)((long)((l3 >>>= 7) > 0L ? 128 : 0) | l2 & 0x7FL);
            l2 = l3;
        }
        return n3;
    }

    @Override
    public void write(int n2) {
        this.hdrBuf[0] = (byte)n2;
        this.write(this.hdrBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.crc32.update(byArray, n2, n3);
        if (!this.atEnd) {
            this.file.seek(this.file.length());
            this.atEnd = true;
        }
        this.out.write(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] finishPack() {
        try {
            int n2;
            this.file.seek(0L);
            this.out.write(this.hdrBuf, 0, PackInserter.access$300(this.hdrBuf, PackInserter.access$200(this.this$0).size()));
            byte[] byArray = PackInserter.access$400(this.this$0);
            SHA1 sHA1 = PackInserter.access$500(this.this$0).reset();
            this.file.seek(0L);
            while ((n2 = this.file.read(byArray)) >= 0) {
                sHA1.update(byArray, 0, n2);
            }
            byte[] byArray2 = sHA1.digest();
            this.out.write(byArray2, 0, byArray2.length);
            byte[] byArray3 = byArray2;
            return byArray3;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        this.deflater.end();
        try {
            this.out.close();
        }
        finally {
            this.file.close();
        }
    }

    byte[] inflate(long l2, int n2) {
        byte[] byArray;
        try {
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        byte[] byArray2 = PackInserter.access$600(this.this$0);
        Inflater inflater = PackInserter.access$700(this.this$0);
        l2 += (long)this.setInput(l2, inflater, byArray2);
        int n3 = 0;
        while (true) {
            int n4 = inflater.inflate(byArray, n3, byArray.length - n3);
            n3 += n4;
            if (inflater.finished()) {
                return byArray;
            }
            if (inflater.needsInput()) {
                l2 += (long)this.setInput(l2, inflater, byArray2);
                continue;
            }
            if (n4 == 0) break;
        }
        throw new DataFormatException();
    }

    private int setInput(long l2, Inflater inflater, byte[] byArray) {
        int n2;
        if (this.file.getFilePointer() != l2) {
            this.seek(l2);
        }
        if ((n2 = this.file.read(byArray)) < 0) {
            throw new EOFException(JGitText.get().unexpectedEofInPack);
        }
        inflater.setInput(byArray, 0, n2);
        return n2;
    }

    static /* synthetic */ RandomAccessFile access$1200(PackInserter$PackStream packInserter$PackStream) {
        return packInserter$PackStream.file;
    }

    static /* synthetic */ boolean access$1502(PackInserter$PackStream packInserter$PackStream, boolean bl2) {
        packInserter$PackStream.atEnd = bl2;
        return packInserter$PackStream.atEnd;
    }
}

