/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.InputStream;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.WindowCursor;

class PackInputStream
extends InputStream {
    private final WindowCursor wc;
    private final Pack pack;
    private long pos;

    PackInputStream(Pack pack, long l2, WindowCursor windowCursor) {
        this.pack = pack;
        this.pos = l2;
        this.wc = windowCursor;
        windowCursor.pin(pack, l2);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.wc.copy(this.pack, this.pos, byArray, n2, n3);
        this.pos += (long)n4;
        return n4;
    }

    @Override
    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        return n2 == 1 ? byArray[0] & 0xFF : -1;
    }

    @Override
    public void close() {
        this.wc.close();
    }
}

