/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.OutputStream;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

class PackIndexWriterV2
extends PackIndexWriter {
    private static final int MAX_OFFSET_32 = Integer.MAX_VALUE;
    private static final int IS_OFFSET_64 = Integer.MIN_VALUE;

    PackIndexWriterV2(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected void writeImpl() {
        this.writeTOC(2);
        this.writeFanOutTable();
        this.writeObjectNames();
        this.writeCRCs();
        this.writeOffset32();
        this.writeOffset64();
        this.writeChecksumFooter();
    }

    private void writeObjectNames() {
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            packedObjectInfo.copyRawTo(this.out);
        }
    }

    private void writeCRCs() {
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            NB.encodeInt32(this.tmp, 0, packedObjectInfo.getCRC());
            this.out.write(this.tmp, 0, 4);
        }
    }

    private void writeOffset32() {
        int n2 = 0;
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            long l2 = packedObjectInfo.getOffset();
            if (l2 <= Integer.MAX_VALUE) {
                NB.encodeInt32(this.tmp, 0, (int)l2);
            } else {
                NB.encodeInt32(this.tmp, 0, Integer.MIN_VALUE | n2++);
            }
            this.out.write(this.tmp, 0, 4);
        }
    }

    private void writeOffset64() {
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            long l2 = packedObjectInfo.getOffset();
            if (Integer.MAX_VALUE >= l2) continue;
            NB.encodeInt64(this.tmp, 0, l2);
            this.out.write(this.tmp, 0, 8);
        }
    }
}

