/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

class PackIndexWriterV1
extends PackIndexWriter {
    static boolean canStore(PackedObjectInfo packedObjectInfo) {
        return packedObjectInfo.getOffset() >>> 1 < Integer.MAX_VALUE;
    }

    PackIndexWriterV1(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    protected void writeImpl() {
        this.writeFanOutTable();
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            if (!PackIndexWriterV1.canStore(packedObjectInfo)) {
                throw new IOException(JGitText.get().packTooLargeForIndexVersion1);
            }
            NB.encodeInt32(this.tmp, 0, (int)packedObjectInfo.getOffset());
            packedObjectInfo.copyRawTo(this.tmp, 4);
            this.out.write(this.tmp);
        }
        this.writeChecksumFooter();
    }
}

