/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexWriterV1;
import org.eclipse.jgit.internal.storage.file.PackIndexWriterV2;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;

public abstract class PackIndexWriter {
    protected static final byte[] TOC = new byte[]{-1, 116, 79, 99};
    protected final DigestOutputStream out;
    protected final byte[] tmp;
    protected List entries;
    protected byte[] packChecksum;

    public static PackIndexWriter createOldestPossible(OutputStream outputStream, List list) {
        return PackIndexWriter.createVersion(outputStream, PackIndexWriter.oldestPossibleFormat(list));
    }

    public static int oldestPossibleFormat(List list) {
        for (PackedObjectInfo packedObjectInfo : list) {
            if (PackIndexWriterV1.canStore(packedObjectInfo)) continue;
            return 2;
        }
        return 1;
    }

    public static PackIndexWriter createVersion(OutputStream outputStream, int n2) {
        switch (n2) {
            case 1: {
                return new PackIndexWriterV1(outputStream);
            }
            case 2: {
                return new PackIndexWriterV2(outputStream);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, n2));
    }

    protected PackIndexWriter(OutputStream outputStream) {
        this.out = new DigestOutputStream(outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream), Constants.newMessageDigest());
        this.tmp = new byte[24];
    }

    public void write(List list, byte[] byArray) {
        this.entries = list;
        this.packChecksum = byArray;
        this.writeImpl();
        this.out.flush();
    }

    protected abstract void writeImpl();

    protected void writeTOC(int n2) {
        this.out.write(TOC);
        NB.encodeInt32(this.tmp, 0, n2);
        this.out.write(this.tmp, 0, 4);
    }

    protected void writeFanOutTable() {
        int[] nArray = new int[256];
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            int n2 = packedObjectInfo.getFirstByte() & 0xFF;
            nArray[n2] = nArray[n2] + 1;
        }
        for (int i2 = 1; i2 < 256; ++i2) {
            int n3 = i2;
            nArray[n3] = nArray[n3] + nArray[i2 - 1];
        }
        for (int n4 : nArray) {
            NB.encodeInt32(this.tmp, 0, n4);
            this.out.write(this.tmp, 0, 4);
        }
    }

    protected void writeChecksumFooter() {
        this.out.write(this.packChecksum);
        this.out.on(false);
        this.out.write(this.out.getMessageDigest().digest());
    }
}

