/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndexV2$EntriesIteratorV2;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackIndexV2
extends PackIndex {
    private static final long IS_O64 = 0x80000000L;
    private static final int FANOUT = 256;
    private static final int[] NO_INTS = new int[0];
    private static final byte[] NO_BYTES = new byte[0];
    private long objectCnt;
    private final long[] fanoutTable;
    int[][] names;
    byte[][] offset32;
    private byte[][] crc32;
    byte[] offset64;

    PackIndexV2(InputStream inputStream) {
        int n2;
        byte[] byArray = new byte[1024];
        IO.readFully(inputStream, byArray, 0, byArray.length);
        this.fanoutTable = new long[256];
        for (n2 = 0; n2 < 256; ++n2) {
            this.fanoutTable[n2] = NB.decodeUInt32(byArray, n2 * 4);
        }
        this.objectCnt = this.fanoutTable[255];
        this.names = new int[256][];
        this.offset32 = new byte[256][];
        this.crc32 = new byte[256][];
        for (n2 = 0; n2 < 256; ++n2) {
            long l2 = n2 == 0 ? this.fanoutTable[n2] : this.fanoutTable[n2] - this.fanoutTable[n2 - 1];
            if (l2 == 0L) {
                this.names[n2] = NO_INTS;
                this.offset32[n2] = NO_BYTES;
                this.crc32[n2] = NO_BYTES;
                continue;
            }
            if (l2 < 0L) {
                throw new IOException(MessageFormat.format(JGitText.get().indexFileCorruptedNegativeBucketCount, l2));
            }
            long l3 = l2 * 20L;
            if (l3 > 0x7FFFFFF7L) {
                throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
            }
            int n3 = (int)l3;
            byte[] byArray2 = new byte[n3];
            int[] nArray = new int[n3 >>> 2];
            IO.readFully(inputStream, byArray2, 0, byArray2.length);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = NB.decodeInt32(byArray2, i2 << 2);
            }
            this.names[n2] = nArray;
            this.offset32[n2] = new byte[(int)(l2 * 4L)];
            this.crc32[n2] = new byte[(int)(l2 * 4L)];
        }
        for (n2 = 0; n2 < 256; ++n2) {
            IO.readFully(inputStream, this.crc32[n2], 0, this.crc32[n2].length);
        }
        n2 = 0;
        for (int i3 = 0; i3 < 256; ++i3) {
            byte[] byArray3 = this.offset32[i3];
            IO.readFully(inputStream, byArray3, 0, byArray3.length);
            for (int i4 = 0; i4 < byArray3.length; i4 += 4) {
                if (byArray3[i4] >= 0) continue;
                ++n2;
            }
        }
        if (n2 > 0) {
            this.offset64 = new byte[n2 * 8];
            IO.readFully(inputStream, this.offset64, 0, this.offset64.length);
        } else {
            this.offset64 = NO_BYTES;
        }
        this.packChecksum = new byte[20];
        IO.readFully(inputStream, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        return this.offset64.length / 8;
    }

    private int findLevelOne(long l2) {
        int n2 = Arrays.binarySearch(this.fanoutTable, l2 + 1L);
        if (n2 >= 0) {
            long l3 = this.fanoutTable[n2];
            while (n2 > 0 && l3 == this.fanoutTable[n2 - 1]) {
                --n2;
            }
        } else {
            n2 = -(n2 + 1);
        }
        return n2;
    }

    private int getLevelTwo(long l2, int n2) {
        long l3 = n2 > 0 ? this.fanoutTable[n2 - 1] : 0L;
        return (int)(l2 - l3);
    }

    @Override
    public ObjectId getObjectId(long l2) {
        int n2 = this.findLevelOne(l2);
        int n3 = this.getLevelTwo(l2, n2);
        int n4 = n3 << 2;
        return ObjectId.fromRaw(this.names[n2], n4 + n3);
    }

    @Override
    public long getOffset(long l2) {
        int n2 = this.findLevelOne(l2);
        int n3 = this.getLevelTwo(l2, n2);
        return this.getOffset(n2, n3);
    }

    @Override
    public long findOffset(AnyObjectId anyObjectId) {
        int n2 = anyObjectId.getFirstByte();
        int n3 = this.binarySearchLevelTwo(anyObjectId, n2);
        if (n3 == -1) {
            return -1L;
        }
        return this.getOffset(n2, n3);
    }

    private long getOffset(int n2, int n3) {
        long l2 = NB.decodeUInt32(this.offset32[n2], n3 << 2);
        if ((l2 & 0x80000000L) != 0L) {
            return NB.decodeUInt64(this.offset64, 8 * (int)(l2 & 0xFFFFFFFF7FFFFFFFL));
        }
        return l2;
    }

    @Override
    public long findCRC32(AnyObjectId anyObjectId) {
        int n2 = anyObjectId.getFirstByte();
        int n3 = this.binarySearchLevelTwo(anyObjectId, n2);
        if (n3 == -1) {
            throw new MissingObjectException(anyObjectId.copy(), "unknown");
        }
        return NB.decodeUInt32(this.crc32[n2], n3 << 2);
    }

    @Override
    public boolean hasCRC32Support() {
        return true;
    }

    @Override
    public Iterator iterator() {
        return new PackIndexV2$EntriesIteratorV2(this, null);
    }

    @Override
    public void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        int[] nArray = this.names[abbreviatedObjectId.getFirstByte()];
        int n3 = this.offset32[abbreviatedObjectId.getFirstByte()].length >>> 2;
        int n4 = n3;
        if (n4 == 0) {
            return;
        }
        int n5 = 0;
        do {
            int n6;
            int n7;
            if ((n7 = abbreviatedObjectId.prefixCompare(nArray, PackIndexV2.idOffset(n6 = n5 + n4 >>> 1))) < 0) {
                n4 = n6;
                continue;
            }
            if (n7 == 0) {
                while (0 < n6 && abbreviatedObjectId.prefixCompare(nArray, PackIndexV2.idOffset(n6 - 1)) == 0) {
                    --n6;
                }
                while (n6 < n3 && abbreviatedObjectId.prefixCompare(nArray, PackIndexV2.idOffset(n6)) == 0) {
                    set.add(ObjectId.fromRaw(nArray, PackIndexV2.idOffset(n6)));
                    if (set.size() > n2) break;
                    ++n6;
                }
                return;
            }
            n5 = n6 + 1;
        } while (n5 < n4);
    }

    private static int idOffset(int n2) {
        return (n2 << 2) + n2;
    }

    private int binarySearchLevelTwo(AnyObjectId anyObjectId, int n2) {
        int[] nArray = this.names[n2];
        int n3 = this.offset32[n2].length >>> 2;
        if (n3 == 0) {
            return -1;
        }
        int n4 = 0;
        do {
            int n5;
            int n6;
            int n7;
            if ((n7 = anyObjectId.compareTo(nArray, (n6 = (n5 = n4 + n3 >>> 1) << 2) + n5)) < 0) {
                n3 = n5;
                continue;
            }
            if (n7 == 0) {
                return n5;
            }
            n4 = n5 + 1;
        } while (n4 < n3);
        return -1;
    }
}

