/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.internal.storage.file.PackIndexV1$IndexV1Iterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackIndexV1
extends PackIndex {
    private static final int IDX_HDR_LEN = 1024;
    private final long[] idxHeader;
    byte[][] idxdata;
    private long objectCnt;

    PackIndexV1(InputStream inputStream, byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[1024];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        IO.readFully(inputStream, byArray2, byArray.length, 1024 - byArray.length);
        this.idxHeader = new long[256];
        for (n2 = 0; n2 < this.idxHeader.length; ++n2) {
            this.idxHeader[n2] = NB.decodeUInt32(byArray2, n2 * 4);
        }
        this.idxdata = new byte[this.idxHeader.length][];
        for (n2 = 0; n2 < this.idxHeader.length; ++n2) {
            long l2 = n2 == 0 ? this.idxHeader[n2] : this.idxHeader[n2] - this.idxHeader[n2 - 1];
            if (l2 <= 0L) continue;
            long l3 = l2 * 24L;
            if (l3 > 0x7FFFFFF7L) {
                throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
            }
            this.idxdata[n2] = new byte[(int)l3];
            IO.readFully(inputStream, this.idxdata[n2], 0, this.idxdata[n2].length);
        }
        this.objectCnt = this.idxHeader[255];
        this.packChecksum = new byte[20];
        IO.readFully(inputStream, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        long l2 = 0L;
        for (PackIndex$MutableEntry packIndex$MutableEntry : this) {
            if (packIndex$MutableEntry.getOffset() < Integer.MAX_VALUE) continue;
            ++l2;
        }
        return l2;
    }

    private int findLevelOne(long l2) {
        int n2 = Arrays.binarySearch(this.idxHeader, l2 + 1L);
        if (n2 >= 0) {
            long l3 = this.idxHeader[n2];
            while (n2 > 0 && l3 == this.idxHeader[n2 - 1]) {
                --n2;
            }
        } else {
            n2 = -(n2 + 1);
        }
        return n2;
    }

    private int getLevelTwo(long l2, int n2) {
        long l3 = n2 > 0 ? this.idxHeader[n2 - 1] : 0L;
        return (int)(l2 - l3);
    }

    @Override
    public ObjectId getObjectId(long l2) {
        int n2 = this.findLevelOne(l2);
        int n3 = this.getLevelTwo(l2, n2);
        int n4 = PackIndexV1.idOffset(n3);
        return ObjectId.fromRaw(this.idxdata[n2], n4);
    }

    @Override
    long getOffset(long l2) {
        int n2 = this.findLevelOne(l2);
        int n3 = this.getLevelTwo(l2, n2);
        int n4 = 24 * n3;
        return NB.decodeUInt32(this.idxdata[n2], n4);
    }

    @Override
    public long findOffset(AnyObjectId anyObjectId) {
        int n2 = anyObjectId.getFirstByte();
        byte[] byArray = this.idxdata[n2];
        if (byArray == null) {
            return -1L;
        }
        int n3 = byArray.length / 24;
        int n4 = 0;
        do {
            int n5;
            int n6;
            int n7;
            if ((n7 = anyObjectId.compareTo(byArray, n6 = PackIndexV1.idOffset(n5 = n4 + n3 >>> 1))) < 0) {
                n3 = n5;
                continue;
            }
            if (n7 == 0) {
                int n8 = byArray[n6 - 4] & 0xFF;
                int n9 = byArray[n6 - 3] & 0xFF;
                int n10 = byArray[n6 - 2] & 0xFF;
                int n11 = byArray[n6 - 1] & 0xFF;
                return (long)n8 << 24 | (long)(n9 << 16) | (long)(n10 << 8) | (long)n11;
            }
            n4 = n5 + 1;
        } while (n4 < n3);
        return -1L;
    }

    @Override
    public long findCRC32(AnyObjectId anyObjectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCRC32Support() {
        return false;
    }

    @Override
    public Iterator iterator() {
        return new PackIndexV1$IndexV1Iterator(this, null);
    }

    @Override
    public void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        int n3;
        byte[] byArray = this.idxdata[abbreviatedObjectId.getFirstByte()];
        if (byArray == null) {
            return;
        }
        int n4 = n3 = byArray.length / 24;
        int n5 = 0;
        do {
            int n6;
            int n7;
            if ((n7 = abbreviatedObjectId.prefixCompare(byArray, PackIndexV1.idOffset(n6 = n5 + n4 >>> 1))) < 0) {
                n4 = n6;
                continue;
            }
            if (n7 == 0) {
                while (0 < n6 && abbreviatedObjectId.prefixCompare(byArray, PackIndexV1.idOffset(n6 - 1)) == 0) {
                    --n6;
                }
                while (n6 < n3 && abbreviatedObjectId.prefixCompare(byArray, PackIndexV1.idOffset(n6)) == 0) {
                    set.add(ObjectId.fromRaw(byArray, PackIndexV1.idOffset(n6)));
                    if (set.size() > n2) break;
                    ++n6;
                }
                return;
            }
            n5 = n6 + 1;
        } while (n5 < n4);
    }

    private static int idOffset(int n2) {
        return 24 * n2 + 4;
    }
}

