/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.errors.UnsupportedPackIndexVersionException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndexV2;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public abstract class PackIndex
implements Iterable,
ObjectIdSet {
    protected byte[] packChecksum;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackIndex open(File file) {
        try (SilentFileInputStream silentFileInputStream = new SilentFileInputStream(file);){
            PackIndex packIndex = PackIndex.read(silentFileInputStream);
            return packIndex;
        }
        catch (IOException iOException) {
            throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, file.getAbsolutePath()), iOException);
        }
    }

    public static PackIndex read(InputStream inputStream) {
        byte[] byArray = new byte[8];
        IO.readFully(inputStream, byArray, 0, byArray.length);
        if (PackIndex.isTOC(byArray)) {
            int n2 = NB.decodeInt32(byArray, 4);
            switch (n2) {
                case 2: {
                    return new PackIndexV2(inputStream);
                }
            }
            throw new UnsupportedPackIndexVersionException(n2);
        }
        return new PackIndexV1(inputStream, byArray);
    }

    private static boolean isTOC(byte[] byArray) {
        byte[] byArray2 = PackIndexWriter.TOC;
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean hasObject(AnyObjectId anyObjectId) {
        return this.findOffset(anyObjectId) != -1L;
    }

    @Override
    public boolean contains(AnyObjectId anyObjectId) {
        return this.findOffset(anyObjectId) != -1L;
    }

    public abstract Iterator iterator();

    public abstract long getObjectCount();

    public abstract long getOffset64Count();

    public abstract ObjectId getObjectId(long var1);

    public final ObjectId getObjectId(int n2) {
        if (n2 >= 0) {
            return this.getObjectId((long)n2);
        }
        int n3 = n2 >>> 1;
        int n4 = n2 & 1;
        return this.getObjectId((long)n3 << 1 | (long)n4);
    }

    abstract long getOffset(long var1);

    public abstract long findOffset(AnyObjectId var1);

    public abstract long findCRC32(AnyObjectId var1);

    public abstract boolean hasCRC32Support();

    public abstract void resolve(Set var1, AbbreviatedObjectId var2, int var3);

    public byte[] getChecksum() {
        return this.packChecksum;
    }
}

