/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.FS;

class PackFileSnapshot
extends FileSnapshot {
    private static final ObjectId MISSING_CHECKSUM = ObjectId.zeroId();
    private AnyObjectId checksum = MISSING_CHECKSUM;
    private boolean wasChecksumChanged;

    public static PackFileSnapshot save(File file, FS fS) {
        return new PackFileSnapshot(file, fS);
    }

    PackFileSnapshot(File file, FS fS) {
        super(file, fS);
    }

    void setChecksum(AnyObjectId anyObjectId) {
        this.checksum = anyObjectId;
    }

    @Override
    public boolean isModified(File file) {
        if (!super.isModified(file)) {
            return false;
        }
        if (this.wasSizeChanged() || this.wasFileKeyChanged() || !this.wasLastModifiedRacilyClean()) {
            return true;
        }
        return this.isChecksumChanged(file);
    }

    boolean isChecksumChanged(File file) {
        this.wasChecksumChanged = this.checksum != MISSING_CHECKSUM && !this.checksum.equals(this.readChecksum(file));
        return this.wasChecksumChanged;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnyObjectId readChecksum(File file) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            randomAccessFile.seek(randomAccessFile.length() - 20L);
            byte[] byArray = new byte[20];
            randomAccessFile.readFully(byArray, 0, 20);
            ObjectId objectId = ObjectId.fromRaw(byArray);
            return objectId;
        }
        catch (IOException iOException) {
            return MISSING_CHECKSUM;
        }
    }

    boolean wasChecksumChanged() {
        return this.wasChecksumChanged;
    }

    @Override
    public String toString() {
        return "PackFileSnapshot [checksum=" + this.checksum + ", " + super.toString() + "]";
    }
}

