/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.ObjectId;

public class PackFile
extends File {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "pack-";
    private final String base;
    private final String id;
    private final boolean hasOldPrefix;
    private final PackExt packExt;

    private static String createName(String string, PackExt packExt) {
        return PREFIX + string + '.' + packExt.getExtension();
    }

    public PackFile(File file) {
        this(file.getParentFile(), file.getName());
    }

    public PackFile(File file, ObjectId objectId, PackExt packExt) {
        this(file, objectId.name(), packExt);
    }

    public PackFile(File file, String string, PackExt packExt) {
        this(file, PackFile.createName(string, packExt));
    }

    public PackFile(File file, String string) {
        super(file, string);
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            this.base = string;
            this.hasOldPrefix = false;
            this.packExt = null;
        } else {
            this.base = string.substring(0, n2);
            String string2 = string.substring(n2 + 1);
            this.packExt = PackFile.getPackExt(string2);
            String string3 = string2.substring(0, string2.length() - this.getExtension().length());
            this.hasOldPrefix = string3.equals(PackFile.getExtPrefix(true));
        }
        this.id = this.base.startsWith(PREFIX) ? this.base.substring(PREFIX.length()) : this.base;
    }

    public String getId() {
        return this.id;
    }

    public PackExt getPackExt() {
        return this.packExt;
    }

    public PackFile create(PackExt packExt) {
        return new PackFile(this.getParentFile(), this.getName(packExt));
    }

    public PackFile createForDirectory(File file) {
        return new PackFile(file, this.getName(false));
    }

    public PackFile createPreservedForDirectory(File file) {
        return new PackFile(file, this.getName(true));
    }

    private String getName(PackExt packExt) {
        return this.base + '.' + PackFile.getExtPrefix(this.hasOldPrefix) + packExt.getExtension();
    }

    private String getName(boolean bl2) {
        return this.base + '.' + PackFile.getExtPrefix(bl2) + this.getExtension();
    }

    private String getExtension() {
        return this.packExt == null ? "" : this.packExt.getExtension();
    }

    private static String getExtPrefix(boolean bl2) {
        return bl2 ? "old-" : "";
    }

    private static PackExt getPackExt(String string) {
        for (PackExt packExt : PackExt.values()) {
            if (!string.endsWith(packExt.getExtension())) continue;
            return packExt;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unrecognizedPackExtension, string));
    }
}

