/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.errors.SearchForReuseTimeout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackDirectory$PackList;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackDirectory {
    private static final Logger LOG = LoggerFactory.getLogger(PackDirectory.class);
    private static final int MAX_PACKLIST_RESCAN_ATTEMPTS = 5;
    private static final PackDirectory$PackList NO_PACKS = new PackDirectory$PackList(FileSnapshot.DIRTY, new Pack[0]);
    private final Config config;
    private final File directory;
    private final AtomicReference packList;

    PackDirectory(Config config, File file) {
        this.config = config;
        this.directory = file;
        this.packList = new AtomicReference<PackDirectory$PackList>(NO_PACKS);
    }

    File getDirectory() {
        return this.directory;
    }

    void create() {
        FileUtils.mkdir(this.directory);
    }

    void close() {
        PackDirectory$PackList packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
        if (packDirectory$PackList != NO_PACKS && this.packList.compareAndSet(packDirectory$PackList, NO_PACKS)) {
            for (Pack pack : packDirectory$PackList.packs) {
                pack.close();
            }
        }
    }

    Collection getPacks() {
        PackDirectory$PackList packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
        if (packDirectory$PackList == NO_PACKS) {
            packDirectory$PackList = this.scanPacks(packDirectory$PackList);
        }
        Pack[] packArray = packDirectory$PackList.packs;
        return Collections.unmodifiableCollection(Arrays.asList(packArray));
    }

    public String toString() {
        return "PackDirectory[" + this.getDirectory() + "]";
    }

    boolean has(AnyObjectId anyObjectId) {
        return this.getPack(anyObjectId) != null;
    }

    @Nullable
    Pack getPack(AnyObjectId anyObjectId) {
        PackDirectory$PackList packDirectory$PackList;
        do {
            packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
            for (Pack pack : packDirectory$PackList.packs) {
                try {
                    if (!pack.hasObject(anyObjectId)) continue;
                    return pack;
                }
                catch (IOException iOException) {
                    LOG.warn(MessageFormat.format(JGitText.get().unableToReadPackfile, pack.getPackFile().getAbsolutePath()), (Throwable)iOException);
                    this.remove(pack);
                }
            }
        } while (this.searchPacksAgain(packDirectory$PackList));
        return null;
    }

    boolean resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        PackDirectory$PackList packDirectory$PackList;
        int n3 = set.size();
        do {
            packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
            for (Pack pack : packDirectory$PackList.packs) {
                try {
                    pack.resolve(set, abbreviatedObjectId, n2);
                    pack.resetTransientErrorCount();
                }
                catch (IOException iOException) {
                    this.handlePackError(iOException, pack);
                }
                if (set.size() <= n2) continue;
                return false;
            }
        } while (set.size() == n3 && this.searchPacksAgain(packDirectory$PackList));
        return true;
    }

    ObjectLoader open(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        PackDirectory$PackList packDirectory$PackList;
        do {
            int n2 = 0;
            block4: while (true) {
                packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
                for (Pack pack : packDirectory$PackList.packs) {
                    try {
                        ObjectLoader objectLoader = pack.get(windowCursor, anyObjectId);
                        pack.resetTransientErrorCount();
                        if (objectLoader == null) continue;
                        return objectLoader;
                    }
                    catch (PackMismatchException packMismatchException) {
                        if (!this.searchPacksAgain(packDirectory$PackList)) continue;
                        n2 = this.checkRescanPackThreshold(n2, packMismatchException);
                        continue block4;
                    }
                    catch (IOException iOException) {
                        this.handlePackError(iOException, pack);
                    }
                }
                break;
            }
        } while (this.searchPacksAgain(packDirectory$PackList));
        return null;
    }

    long getSize(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        PackDirectory$PackList packDirectory$PackList;
        do {
            int n2 = 0;
            block4: while (true) {
                packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
                for (Pack pack : packDirectory$PackList.packs) {
                    try {
                        long l2 = pack.getObjectSize(windowCursor, anyObjectId);
                        pack.resetTransientErrorCount();
                        if (0L > l2) continue;
                        return l2;
                    }
                    catch (PackMismatchException packMismatchException) {
                        if (!this.searchPacksAgain(packDirectory$PackList)) continue;
                        n2 = this.checkRescanPackThreshold(n2, packMismatchException);
                        continue block4;
                    }
                    catch (IOException iOException) {
                        this.handlePackError(iOException, pack);
                    }
                }
                break;
            }
        } while (this.searchPacksAgain(packDirectory$PackList));
        return -1L;
    }

    void selectRepresentation(PackWriter packWriter, ObjectToPack objectToPack, WindowCursor windowCursor) {
        PackDirectory$PackList packDirectory$PackList = (PackDirectory$PackList)this.packList.get();
        int n2 = 0;
        block4: while (true) {
            for (Pack pack : packDirectory$PackList.packs) {
                try {
                    LocalObjectRepresentation localObjectRepresentation = pack.representation(windowCursor, objectToPack);
                    pack.resetTransientErrorCount();
                    if (localObjectRepresentation == null) continue;
                    packWriter.select(objectToPack, localObjectRepresentation);
                    packWriter.checkSearchForReuseTimeout();
                }
                catch (SearchForReuseTimeout searchForReuseTimeout) {
                    break block4;
                }
                catch (PackMismatchException packMismatchException) {
                    n2 = this.checkRescanPackThreshold(n2, packMismatchException);
                    packDirectory$PackList = this.scanPacks(packDirectory$PackList);
                }
                catch (IOException iOException) {
                    this.handlePackError(iOException, pack);
                }
            }
            break;
        }
    }

    private int checkRescanPackThreshold(int n2, PackMismatchException packMismatchException) {
        if (n2++ > 5) {
            packMismatchException.setPermanent(true);
            throw packMismatchException;
        }
        return n2;
    }

    private void handlePackError(IOException iOException, Pack pack) {
        String string = null;
        int n2 = 0;
        String string2 = JGitText.get().exceptionWhileReadingPack;
        if (iOException instanceof CorruptObjectException || iOException instanceof PackInvalidException) {
            string = JGitText.get().corruptPack;
            LOG.warn(MessageFormat.format(string, pack.getPackFile().getAbsolutePath()), (Throwable)iOException);
            this.remove(pack);
        } else if (iOException instanceof FileNotFoundException) {
            if (pack.getPackFile().exists()) {
                string2 = JGitText.get().packInaccessible;
                n2 = pack.incrementTransientErrorCount();
            } else {
                string = JGitText.get().packWasDeleted;
                this.remove(pack);
            }
        } else if (FileUtils.isStaleFileHandleInCausalChain(iOException)) {
            string = JGitText.get().packHandleIsStale;
            this.remove(pack);
        } else {
            n2 = pack.incrementTransientErrorCount();
        }
        if (string != null) {
            LOG.warn(MessageFormat.format(string, pack.getPackFile().getAbsolutePath()), (Throwable)iOException);
        } else if (this.doLogExponentialBackoff(n2)) {
            LOG.error(MessageFormat.format(string2, pack.getPackFile().getAbsolutePath(), n2), (Throwable)iOException);
        }
    }

    private boolean doLogExponentialBackoff(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    boolean searchPacksAgain(PackDirectory$PackList packDirectory$PackList) {
        boolean bl2 = this.config.getBoolean("core", "trustfolderstat", true);
        return (!bl2 || packDirectory$PackList.snapshot.isModified(this.directory)) && packDirectory$PackList != this.scanPacks(packDirectory$PackList);
    }

    void insert(Pack pack) {
        Pack[] packArray;
        PackDirectory$PackList packDirectory$PackList;
        PackDirectory$PackList packDirectory$PackList2;
        do {
            packDirectory$PackList2 = (PackDirectory$PackList)this.packList.get();
            Pack[] packArray2 = packDirectory$PackList2.packs;
            String string = pack.getPackFile().getName();
            for (Pack pack2 : packArray2) {
                if (!string.equals(pack2.getPackFile().getName())) continue;
                return;
            }
            packArray = new Pack[1 + packArray2.length];
            packArray[0] = pack;
            System.arraycopy(packArray2, 0, packArray, 1, packArray2.length);
        } while (!this.packList.compareAndSet(packDirectory$PackList2, packDirectory$PackList = new PackDirectory$PackList(packDirectory$PackList2.snapshot, packArray)));
    }

    private void remove(Pack pack) {
        Pack[] packArray;
        PackDirectory$PackList packDirectory$PackList;
        PackDirectory$PackList packDirectory$PackList2;
        do {
            packDirectory$PackList2 = (PackDirectory$PackList)this.packList.get();
            Pack[] packArray2 = packDirectory$PackList2.packs;
            int n2 = PackDirectory.indexOf(packArray2, pack);
            if (n2 < 0) break;
            packArray = new Pack[packArray2.length - 1];
            System.arraycopy(packArray2, 0, packArray, 0, n2);
            System.arraycopy(packArray2, n2 + 1, packArray, n2, packArray.length - n2);
        } while (!this.packList.compareAndSet(packDirectory$PackList2, packDirectory$PackList = new PackDirectory$PackList(packDirectory$PackList2.snapshot, packArray)));
        pack.close();
    }

    private static int indexOf(Pack[] packArray, Pack pack) {
        for (int i2 = 0; i2 < packArray.length; ++i2) {
            if (packArray[i2] != pack) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackDirectory$PackList scanPacks(PackDirectory$PackList packDirectory$PackList) {
        AtomicReference atomicReference = this.packList;
        synchronized (atomicReference) {
            PackDirectory$PackList packDirectory$PackList2;
            PackDirectory$PackList packDirectory$PackList3;
            do {
                if ((packDirectory$PackList3 = (PackDirectory$PackList)this.packList.get()) != packDirectory$PackList) {
                    return packDirectory$PackList3;
                }
                packDirectory$PackList2 = this.scanPacksImpl(packDirectory$PackList3);
                if (packDirectory$PackList2 != packDirectory$PackList3) continue;
                return packDirectory$PackList2;
            } while (!this.packList.compareAndSet(packDirectory$PackList3, packDirectory$PackList2));
            return packDirectory$PackList2;
        }
    }

    private PackDirectory$PackList scanPacksImpl(PackDirectory$PackList packDirectory$PackList) {
        Map map = PackDirectory.reuseMap(packDirectory$PackList);
        FileSnapshot fileSnapshot = FileSnapshot.save(this.directory, FS.DETECTED);
        Map map2 = this.getPackFilesByExtById();
        ArrayList<Pack> arrayList = new ArrayList<Pack>(map2.size());
        boolean bl2 = false;
        for (Object object : map2.values()) {
            PackFile packFile = (PackFile)object.get((Object)PackExt.PACK);
            if (packFile == null || !object.containsKey((Object)PackExt.INDEX)) continue;
            Pack pack = (Pack)map.get(packFile.getName());
            if (pack != null && !pack.getFileSnapshot().isModified(packFile)) {
                map.remove(packFile.getName());
                arrayList.add(pack);
                continue;
            }
            arrayList.add(new Pack(packFile, (PackFile)object.get((Object)PackExt.BITMAP_INDEX)));
            bl2 = true;
        }
        if (!bl2 && map.isEmpty() && fileSnapshot.equals(packDirectory$PackList.snapshot)) {
            packDirectory$PackList.snapshot.setClean(fileSnapshot);
            return packDirectory$PackList;
        }
        for (Object object : map.values()) {
            ((Pack)object).close();
        }
        if (arrayList.isEmpty()) {
            return new PackDirectory$PackList(fileSnapshot, PackDirectory.NO_PACKS.packs);
        }
        Pack[] packArray = arrayList.toArray(new Pack[0]);
        Arrays.sort(packArray, Pack.SORT);
        return new PackDirectory$PackList(fileSnapshot, packArray);
    }

    private static Map reuseMap(PackDirectory$PackList packDirectory$PackList) {
        HashMap<String, Pack> hashMap = new HashMap<String, Pack>();
        for (Pack pack : packDirectory$PackList.packs) {
            if (pack.invalid()) {
                pack.close();
                continue;
            }
            Pack pack2 = hashMap.put(pack.getPackFile().getName(), pack);
            if (pack2 == null) continue;
            hashMap.put(pack2.getPackFile().getName(), pack2);
            pack.close();
        }
        return hashMap;
    }

    private Map getPackFilesByExtById() {
        String[] stringArray = this.directory.list();
        if (stringArray == null) {
            return Collections.emptyMap();
        }
        HashMap<String, EnumMap<PackExt, PackFile>> hashMap = new HashMap<String, EnumMap<PackExt, PackFile>>(stringArray.length / 2);
        for (String string : stringArray) {
            try {
                PackFile packFile = new PackFile(this.directory, string);
                if (packFile.getPackExt() == null) continue;
                EnumMap<PackExt, PackFile> enumMap = (EnumMap<PackExt, PackFile>)hashMap.get(packFile.getId());
                if (enumMap == null) {
                    enumMap = new EnumMap<PackExt, PackFile>(PackExt.class);
                    hashMap.put(packFile.getId(), enumMap);
                }
                enumMap.put(packFile.getPackExt(), packFile);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return hashMap;
    }
}

