/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder$StoredEntry;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.eclipse.jgit.internal.storage.file.SimpleDataOutput;
import org.eclipse.jgit.lib.Constants;

public class PackBitmapIndexWriterV1 {
    private final DigestOutputStream out;
    private final DataOutput dataOutput;

    public PackBitmapIndexWriterV1(OutputStream outputStream) {
        this.out = new DigestOutputStream(outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream), Constants.newMessageDigest());
        this.dataOutput = new SimpleDataOutput(this.out);
    }

    public void write(PackBitmapIndexBuilder packBitmapIndexBuilder, byte[] byArray) {
        if (packBitmapIndexBuilder == null || byArray.length != 20) {
            throw new IllegalStateException();
        }
        this.writeHeader(packBitmapIndexBuilder.getOptions(), packBitmapIndexBuilder.getBitmapCount(), byArray);
        this.writeBody(packBitmapIndexBuilder);
        this.writeFooter();
        this.out.flush();
    }

    private void writeHeader(int n2, int n3, byte[] byArray) {
        this.out.write(PackBitmapIndexV1.MAGIC);
        this.dataOutput.writeShort(1);
        this.dataOutput.writeShort(n2);
        this.dataOutput.writeInt(n3);
        this.out.write(byArray);
    }

    private void writeBody(PackBitmapIndexBuilder packBitmapIndexBuilder) {
        this.writeBitmap(packBitmapIndexBuilder.getCommits());
        this.writeBitmap(packBitmapIndexBuilder.getTrees());
        this.writeBitmap(packBitmapIndexBuilder.getBlobs());
        this.writeBitmap(packBitmapIndexBuilder.getTags());
        this.writeBitmaps(packBitmapIndexBuilder);
    }

    private void writeBitmap(EWAHCompressedBitmap eWAHCompressedBitmap) {
        eWAHCompressedBitmap.serialize(this.dataOutput);
    }

    private void writeBitmaps(PackBitmapIndexBuilder packBitmapIndexBuilder) {
        int n2 = 0;
        for (PackBitmapIndexBuilder$StoredEntry storedEntry : packBitmapIndexBuilder.getCompressedBitmaps()) {
            this.writeBitmapEntry(storedEntry);
            ++n2;
        }
        int n3 = packBitmapIndexBuilder.getBitmapCount();
        if (n3 != n2) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, String.valueOf(n3), String.valueOf(n2)));
        }
    }

    private void writeBitmapEntry(PackBitmapIndexBuilder$StoredEntry packBitmapIndexBuilder$StoredEntry) {
        this.dataOutput.writeInt((int)packBitmapIndexBuilder$StoredEntry.getObjectId());
        this.out.write(packBitmapIndexBuilder$StoredEntry.getXorOffset());
        this.out.write(packBitmapIndexBuilder$StoredEntry.getFlags());
        this.writeBitmap(packBitmapIndexBuilder$StoredEntry.getBitmap());
    }

    private void writeFooter() {
        this.out.on(false);
        this.out.write(this.out.getMessageDigest().digest());
    }
}

