/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex$StoredBitmap;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.file.SimpleDataInput;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackBitmapIndexV1
extends BasePackBitmapIndex {
    static final byte[] MAGIC = new byte[]{66, 73, 84, 77};
    static final int OPT_FULL = 1;
    private static final int MAX_XOR_OFFSET = 126;
    private final PackIndex packIndex;
    private final PackReverseIndex reverseIndex;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final ObjectIdOwnerMap bitmaps;

    PackBitmapIndexV1(InputStream inputStream, PackIndex packIndex, PackReverseIndex packReverseIndex) {
        super(new ObjectIdOwnerMap());
        int n2;
        this.packIndex = packIndex;
        this.reverseIndex = packReverseIndex;
        this.bitmaps = this.getBitmaps();
        byte[] byArray = new byte[32];
        IO.readFully(inputStream, byArray, 0, byArray.length);
        for (n2 = 0; n2 < MAGIC.length; ++n2) {
            if (byArray[n2] == MAGIC[n2]) continue;
            byte[] byArray2 = new byte[MAGIC.length];
            System.arraycopy(byArray, 0, byArray2, 0, MAGIC.length);
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, Arrays.toString(MAGIC), Arrays.toString(byArray2)));
        }
        n2 = NB.decodeUInt16(byArray, 4);
        if (n2 != 1) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, n2));
        }
        int n3 = NB.decodeUInt16(byArray, 6);
        if ((n3 & 1) == 0) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, 1, n3));
        }
        long l2 = NB.decodeUInt32(byArray, 8);
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
        }
        this.packChecksum = new byte[20];
        System.arraycopy(byArray, 12, this.packChecksum, 0, this.packChecksum.length);
        SimpleDataInput simpleDataInput = new SimpleDataInput(inputStream);
        this.commits = PackBitmapIndexV1.readBitmap(simpleDataInput);
        this.trees = PackBitmapIndexV1.readBitmap(simpleDataInput);
        this.blobs = PackBitmapIndexV1.readBitmap(simpleDataInput);
        this.tags = PackBitmapIndexV1.readBitmap(simpleDataInput);
        BasePackBitmapIndex$StoredBitmap[] basePackBitmapIndex$StoredBitmapArray = new BasePackBitmapIndex$StoredBitmap[126];
        for (int i2 = 0; i2 < (int)l2; ++i2) {
            int n4;
            IO.readFully(inputStream, byArray, 0, 6);
            int n5 = NB.decodeInt32(byArray, 0);
            byte by = byArray[4];
            byte by2 = byArray[5];
            EWAHCompressedBitmap eWAHCompressedBitmap = PackBitmapIndexV1.readBitmap(simpleDataInput);
            if (n5 < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(n5)));
            }
            if (by < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(by)));
            }
            if (by > 126) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(126), String.valueOf(by)));
            }
            if (by > i2) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(i2), String.valueOf(by)));
            }
            ObjectId objectId = packIndex.getObjectId(n5);
            BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap = null;
            if (by > 0 && (basePackBitmapIndex$StoredBitmap = basePackBitmapIndex$StoredBitmapArray[(n4 = i2 - by) % basePackBitmapIndex$StoredBitmapArray.length]) == null) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(by)));
            }
            BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap2 = new BasePackBitmapIndex$StoredBitmap(objectId, eWAHCompressedBitmap, basePackBitmapIndex$StoredBitmap, by2);
            this.bitmaps.add(basePackBitmapIndex$StoredBitmap2);
            basePackBitmapIndex$StoredBitmapArray[i2 % basePackBitmapIndex$StoredBitmapArray.length] = basePackBitmapIndex$StoredBitmap2;
        }
    }

    @Override
    public int findPosition(AnyObjectId anyObjectId) {
        long l2 = this.packIndex.findOffset(anyObjectId);
        if (l2 == -1L) {
            return -1;
        }
        return this.reverseIndex.findPostion(l2);
    }

    @Override
    public ObjectId getObject(int n2) {
        ObjectId objectId = this.reverseIndex.findObjectByPosition(n2);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    @Override
    public int getObjectCount() {
        return (int)this.packIndex.getObjectCount();
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap eWAHCompressedBitmap, int n2) {
        switch (n2) {
            case 3: {
                return this.blobs.and(eWAHCompressedBitmap);
            }
            case 2: {
                return this.trees.and(eWAHCompressedBitmap);
            }
            case 1: {
                return this.commits.and(eWAHCompressedBitmap);
            }
            case 4: {
                return this.tags.and(eWAHCompressedBitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getBitmapCount() {
        return this.bitmaps.size();
    }

    public boolean equals(Object object) {
        if (object instanceof PackBitmapIndexV1) {
            return this.getPackIndex() == ((PackBitmapIndexV1)object).getPackIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getPackIndex().hashCode();
    }

    PackIndex getPackIndex() {
        return this.packIndex;
    }

    private static EWAHCompressedBitmap readBitmap(DataInput dataInput) {
        EWAHCompressedBitmap eWAHCompressedBitmap = new EWAHCompressedBitmap();
        eWAHCompressedBitmap.deserialize(dataInput);
        return eWAHCompressedBitmap;
    }
}

