/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex$StoredBitmap;
import org.eclipse.jgit.internal.storage.file.BitSet;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper$1;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;

public class PackBitmapIndexRemapper
extends PackBitmapIndex
implements Iterable {
    private final BasePackBitmapIndex oldPackIndex;
    final PackBitmapIndex newPackIndex;
    private final BitSet inflated;
    private final int[] prevToNewMapping;

    public static PackBitmapIndexRemapper newPackBitmapIndex(BitmapIndex bitmapIndex, PackBitmapIndex packBitmapIndex) {
        if (!(bitmapIndex instanceof BitmapIndexImpl)) {
            return new PackBitmapIndexRemapper(packBitmapIndex);
        }
        PackBitmapIndex packBitmapIndex2 = ((BitmapIndexImpl)bitmapIndex).getPackBitmapIndex();
        if (!(packBitmapIndex2 instanceof BasePackBitmapIndex)) {
            return new PackBitmapIndexRemapper(packBitmapIndex);
        }
        return new PackBitmapIndexRemapper((BasePackBitmapIndex)packBitmapIndex2, packBitmapIndex);
    }

    private PackBitmapIndexRemapper(PackBitmapIndex packBitmapIndex) {
        this.oldPackIndex = null;
        this.newPackIndex = packBitmapIndex;
        this.inflated = null;
        this.prevToNewMapping = null;
    }

    private PackBitmapIndexRemapper(BasePackBitmapIndex basePackBitmapIndex, PackBitmapIndex packBitmapIndex) {
        this.oldPackIndex = basePackBitmapIndex;
        this.newPackIndex = packBitmapIndex;
        this.inflated = new BitSet(packBitmapIndex.getObjectCount());
        this.prevToNewMapping = new int[basePackBitmapIndex.getObjectCount()];
        for (int i2 = 0; i2 < this.prevToNewMapping.length; ++i2) {
            this.prevToNewMapping[i2] = packBitmapIndex.findPosition(basePackBitmapIndex.getObject(i2));
        }
    }

    @Override
    public int findPosition(AnyObjectId anyObjectId) {
        return this.newPackIndex.findPosition(anyObjectId);
    }

    @Override
    public ObjectId getObject(int n2) {
        return this.newPackIndex.getObject(n2);
    }

    @Override
    public int getObjectCount() {
        return this.newPackIndex.getObjectCount();
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap eWAHCompressedBitmap, int n2) {
        return this.newPackIndex.ofObjectType(eWAHCompressedBitmap, n2);
    }

    public Iterator iterator() {
        if (this.oldPackIndex == null) {
            return Collections.emptyList().iterator();
        }
        Iterator iterator = this.oldPackIndex.getBitmaps().iterator();
        return new PackBitmapIndexRemapper$1(this, iterator);
    }

    @Override
    public EWAHCompressedBitmap getBitmap(AnyObjectId anyObjectId) {
        EWAHCompressedBitmap eWAHCompressedBitmap = this.newPackIndex.getBitmap(anyObjectId);
        if (eWAHCompressedBitmap != null || this.oldPackIndex == null) {
            return eWAHCompressedBitmap;
        }
        BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap = (BasePackBitmapIndex$StoredBitmap)this.oldPackIndex.getBitmaps().get(anyObjectId);
        if (basePackBitmapIndex$StoredBitmap == null) {
            return null;
        }
        if (this.newPackIndex.findPosition(anyObjectId) == -1) {
            return null;
        }
        this.inflated.clear();
        IntIterator intIterator = basePackBitmapIndex$StoredBitmap.getBitmapWithoutCaching().intIterator();
        while (intIterator.hasNext()) {
            this.inflated.set(this.prevToNewMapping[intIterator.next()]);
        }
        eWAHCompressedBitmap = this.inflated.toEWAHCompressedBitmap();
        eWAHCompressedBitmap.trim();
        return eWAHCompressedBitmap;
    }

    @Override
    public int getBitmapCount() {
        return 0;
    }
}

