/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex$StoredBitmap;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder$1;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder$PositionEntry;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder$StoredEntry;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex$Bitmap;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.BlockList;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final BlockList byOffset;
    private final LinkedList bitmapsToWriteXorBuffer = new LinkedList();
    private List bitmapsToWrite = new ArrayList();
    final ObjectIdOwnerMap positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List list) {
        super(new ObjectIdOwnerMap());
        this.byOffset = new BlockList(list.size());
        PackBitmapIndexBuilder.sortByOffsetAndIndex(this.byOffset, this.positionEntries, list);
        int n2 = Math.max(4, this.byOffset.size() / 64 / 3);
        this.commits = new EWAHCompressedBitmap(n2);
        this.trees = new EWAHCompressedBitmap(n2);
        this.blobs = new EWAHCompressedBitmap(n2);
        this.tags = new EWAHCompressedBitmap(n2);
        block6: for (int i2 = 0; i2 < list.size(); ++i2) {
            int n3 = ((ObjectToPack)list.get(i2)).getType();
            switch (n3) {
                case 1: {
                    this.commits.set(i2);
                    continue block6;
                }
                case 2: {
                    this.trees.set(i2);
                    continue block6;
                }
                case 3: {
                    this.blobs.set(i2);
                    continue block6;
                }
                case 4: {
                    this.tags.set(i2);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(n3)));
                }
            }
        }
        this.commits.trim();
        this.trees.trim();
        this.blobs.trim();
        this.tags.trim();
    }

    private static void sortByOffsetAndIndex(BlockList blockList, ObjectIdOwnerMap objectIdOwnerMap, List list) {
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            objectIdOwnerMap.add(new PackBitmapIndexBuilder$PositionEntry((AnyObjectId)list.get(n2), n2));
        }
        Collections.sort(list, (objectToPack, objectToPack2) -> Long.signum(objectToPack.getOffset() - objectToPack2.getOffset()));
        n2 = 0;
        while (n2 < list.size()) {
            PackBitmapIndexBuilder$PositionEntry packBitmapIndexBuilder$PositionEntry = (PackBitmapIndexBuilder$PositionEntry)objectIdOwnerMap.get((AnyObjectId)list.get(n2));
            packBitmapIndexBuilder$PositionEntry.offsetPosition = n2++;
            blockList.add(packBitmapIndexBuilder$PositionEntry);
        }
    }

    public ObjectIdOwnerMap getObjectSet() {
        ObjectIdOwnerMap objectIdOwnerMap = new ObjectIdOwnerMap();
        for (PackBitmapIndexBuilder$PositionEntry packBitmapIndexBuilder$PositionEntry : this.byOffset) {
            objectIdOwnerMap.add(new PackBitmapIndexBuilder$1(this, packBitmapIndexBuilder$PositionEntry));
        }
        return objectIdOwnerMap;
    }

    public void addBitmap(AnyObjectId anyObjectId, BitmapIndex$Bitmap bitmapIndex$Bitmap, int n2) {
        this.addBitmap(anyObjectId, bitmapIndex$Bitmap.retrieveCompressed(), n2);
    }

    public void processBitmapForWrite(BitmapCommit bitmapCommit, BitmapIndex$Bitmap bitmapIndex$Bitmap, int n2) {
        EWAHCompressedBitmap eWAHCompressedBitmap = bitmapIndex$Bitmap.retrieveCompressed();
        eWAHCompressedBitmap.trim();
        BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap = new BasePackBitmapIndex$StoredBitmap(bitmapCommit, eWAHCompressedBitmap, null, n2);
        this.bitmapsToWriteXorBuffer.add(basePackBitmapIndex$StoredBitmap);
        if (this.bitmapsToWriteXorBuffer.size() > 10) {
            this.bitmapsToWrite.add(this.generateStoredEntry((BasePackBitmapIndex$StoredBitmap)this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        if (bitmapCommit.isAddToIndex()) {
            this.addBitmap((AnyObjectId)bitmapCommit, bitmapIndex$Bitmap, n2);
        }
    }

    private PackBitmapIndexBuilder$StoredEntry generateStoredEntry(BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap) {
        Object object2;
        int n2 = 0;
        EWAHCompressedBitmap eWAHCompressedBitmap = basePackBitmapIndex$StoredBitmap.getBitmap();
        int n3 = 1;
        for (Object object2 : this.bitmapsToWriteXorBuffer) {
            EWAHCompressedBitmap eWAHCompressedBitmap2 = ((BasePackBitmapIndex$StoredBitmap)object2).getBitmap().xor(basePackBitmapIndex$StoredBitmap.getBitmap());
            if (eWAHCompressedBitmap2.sizeInBytes() < eWAHCompressedBitmap.sizeInBytes()) {
                eWAHCompressedBitmap = eWAHCompressedBitmap2;
                n2 = n3;
            }
            ++n3;
        }
        PackBitmapIndexBuilder$PositionEntry packBitmapIndexBuilder$PositionEntry = (PackBitmapIndexBuilder$PositionEntry)this.positionEntries.get(basePackBitmapIndex$StoredBitmap);
        if (packBitmapIndexBuilder$PositionEntry == null) {
            throw new IllegalStateException();
        }
        eWAHCompressedBitmap.trim();
        object2 = new PackBitmapIndexBuilder$StoredEntry(packBitmapIndexBuilder$PositionEntry.namePosition, eWAHCompressedBitmap, n2, basePackBitmapIndex$StoredBitmap.getFlags());
        return object2;
    }

    public void addBitmap(AnyObjectId anyObjectId, EWAHCompressedBitmap eWAHCompressedBitmap, int n2) {
        eWAHCompressedBitmap.trim();
        BasePackBitmapIndex$StoredBitmap basePackBitmapIndex$StoredBitmap = new BasePackBitmapIndex$StoredBitmap(anyObjectId, eWAHCompressedBitmap, null, n2);
        this.getBitmaps().add(basePackBitmapIndex$StoredBitmap);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap eWAHCompressedBitmap, int n2) {
        switch (n2) {
            case 3: {
                return this.getBlobs().and(eWAHCompressedBitmap);
            }
            case 2: {
                return this.getTrees().and(eWAHCompressedBitmap);
            }
            case 1: {
                return this.getCommits().and(eWAHCompressedBitmap);
            }
            case 4: {
                return this.getTags().and(eWAHCompressedBitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId anyObjectId) {
        PackBitmapIndexBuilder$PositionEntry packBitmapIndexBuilder$PositionEntry = (PackBitmapIndexBuilder$PositionEntry)this.positionEntries.get(anyObjectId);
        if (packBitmapIndexBuilder$PositionEntry == null) {
            return -1;
        }
        return packBitmapIndexBuilder$PositionEntry.offsetPosition;
    }

    @Override
    public ObjectId getObject(int n2) {
        ObjectId objectId = (ObjectId)this.byOffset.get(n2);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    @Override
    public int getBitmapCount() {
        return this.bitmapsToWriteXorBuffer.size() + this.bitmapsToWrite.size();
    }

    public void resetBitmaps(int n2) {
        this.getBitmaps().clear();
        this.bitmapsToWrite = new ArrayList(n2);
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.size();
    }

    public List getCompressedBitmaps() {
        while (!this.bitmapsToWriteXorBuffer.isEmpty()) {
            this.bitmapsToWrite.add(this.generateStoredEntry((BasePackBitmapIndex$StoredBitmap)this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        Collections.reverse(this.bitmapsToWrite);
        return this.bitmapsToWrite;
    }
}

