/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    public static PackBitmapIndex open(File file, PackIndex packIndex, PackReverseIndex packReverseIndex) {
        Throwable throwable = null;
        try (SilentFileInputStream silentFileInputStream = new SilentFileInputStream(file);){
            PackBitmapIndex packBitmapIndex = PackBitmapIndex.read(silentFileInputStream, packIndex, packReverseIndex);
            return packBitmapIndex;
        }
        catch (IOException iOException) {
            try {
                throw new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, file.getAbsolutePath()), iOException);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static PackBitmapIndex read(InputStream inputStream, PackIndex packIndex, PackReverseIndex packReverseIndex) {
        return new PackBitmapIndexV1(inputStream, packIndex, packReverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1);

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();

    public abstract int getBitmapCount();
}

