/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException$ExceedsByteArrayLimit;
import org.eclipse.jgit.errors.LargeObjectException$OutOfMemory;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoPackSignatureException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.errors.UnsupportedPackIndexVersionException;
import org.eclipse.jgit.errors.UnsupportedPackVersionException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ByteArrayWindow;
import org.eclipse.jgit.internal.storage.file.ByteBufferWindow;
import org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.eclipse.jgit.internal.storage.file.DeltaBaseCache$Entry;
import org.eclipse.jgit.internal.storage.file.LargePackedWholeObject;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.LocalObjectToPack;
import org.eclipse.jgit.internal.storage.file.Pack$Delta;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackFileSnapshot;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectLoader$SmallObject;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pack
implements Iterable {
    private static final Logger LOG = LoggerFactory.getLogger(Pack.class);
    public static final Comparator SORT = (pack, pack2) -> pack2.packLastModified.compareTo(pack.packLastModified);
    private final PackFile packFile;
    private PackFile keepFile;
    final int hash;
    private RandomAccessFile fd;
    private final Object readLock = new Object();
    long length;
    private int activeWindows;
    private int activeCopyRawData;
    Instant packLastModified;
    private PackFileSnapshot fileSnapshot;
    private volatile boolean invalid;
    private volatile Exception invalidatingCause;
    @Nullable
    private PackFile bitmapIdxFile;
    private AtomicInteger transientErrorCount = new AtomicInteger();
    private byte[] packChecksum;
    private volatile PackIndex loadedIdx;
    private PackReverseIndex reverseIdx;
    private PackBitmapIndex bitmapIdx;
    private volatile LongList corruptObjects;

    public Pack(File file, @Nullable PackFile packFile) {
        this.packFile = new PackFile(file);
        this.fileSnapshot = PackFileSnapshot.save(file, FS.DETECTED);
        this.packLastModified = this.fileSnapshot.lastModifiedInstant();
        this.bitmapIdxFile = packFile;
        this.hash = System.identityHashCode(this) * 31;
        this.length = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackIndex idx() {
        PackIndex packIndex = this.loadedIdx;
        if (packIndex == null) {
            Pack pack = this;
            synchronized (pack) {
                packIndex = this.loadedIdx;
                if (packIndex == null) {
                    if (this.invalid) {
                        throw new PackInvalidException(this.packFile, (Throwable)this.invalidatingCause);
                    }
                    try {
                        long l2 = System.currentTimeMillis();
                        PackFile packFile = this.packFile.create(PackExt.INDEX);
                        packIndex = PackIndex.open(packFile);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Opening pack index %s, size %.3f MB took %d ms", packFile.getAbsolutePath(), Float.valueOf((float)packFile.length() / 1048576.0f), System.currentTimeMillis() - l2));
                        }
                        if (this.packChecksum == null) {
                            this.packChecksum = packIndex.packChecksum;
                            this.fileSnapshot.setChecksum(ObjectId.fromRaw(this.packChecksum));
                        } else if (!Arrays.equals(this.packChecksum, packIndex.packChecksum)) {
                            throw new PackMismatchException(MessageFormat.format(JGitText.get().packChecksumMismatch, this.packFile.getPath(), ObjectId.fromRaw(this.packChecksum).name(), ObjectId.fromRaw(packIndex.packChecksum).name()));
                        }
                        this.loadedIdx = packIndex;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        throw interruptedIOException;
                    }
                    catch (IOException iOException) {
                        this.invalid = true;
                        this.invalidatingCause = iOException;
                        throw iOException;
                    }
                }
            }
        }
        return packIndex;
    }

    public PackFile getPackFile() {
        return this.packFile;
    }

    public PackIndex getIndex() {
        return this.idx();
    }

    public String getPackName() {
        return this.packFile.getId();
    }

    public boolean hasObject(AnyObjectId anyObjectId) {
        long l2 = this.idx().findOffset(anyObjectId);
        return 0L < l2 && !this.isCorrupt(l2);
    }

    public boolean shouldBeKept() {
        if (this.keepFile == null) {
            this.keepFile = this.packFile.create(PackExt.KEEP);
        }
        return this.keepFile.exists();
    }

    ObjectLoader get(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        long l2 = this.idx().findOffset(anyObjectId);
        return 0L < l2 && !this.isCorrupt(l2) ? this.load(windowCursor, l2) : null;
    }

    void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        this.idx().resolve(set, abbreviatedObjectId, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WindowCache.purge(this);
        Pack pack = this;
        synchronized (pack) {
            this.loadedIdx = null;
            this.reverseIdx = null;
        }
    }

    public Iterator iterator() {
        try {
            return this.idx().iterator();
        }
        catch (IOException iOException) {
            return Collections.emptyList().iterator();
        }
    }

    long getObjectCount() {
        return this.idx().getObjectCount();
    }

    ObjectId findObjectForOffset(long l2) {
        return this.getReverseIdx().findObject(l2);
    }

    PackFileSnapshot getFileSnapshot() {
        return this.fileSnapshot;
    }

    AnyObjectId getPackChecksum() {
        return ObjectId.fromRaw(this.packChecksum);
    }

    private final byte[] decompress(long l2, int n2, WindowCursor windowCursor) {
        byte[] byArray;
        try {
            byArray = new byte[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
        if (windowCursor.inflate(this, l2, byArray, false) != n2) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, l2));
        }
        return byArray;
    }

    void copyPackAsIs(PackOutputStream packOutputStream, WindowCursor windowCursor) {
        windowCursor.pin(this, 0L);
        windowCursor.copyPackAsIs(this, this.length, packOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void copyAsIs(PackOutputStream packOutputStream, LocalObjectToPack localObjectToPack, boolean bl2, WindowCursor windowCursor) {
        this.beginCopyAsIs(localObjectToPack);
        try {
            this.copyAsIs2(packOutputStream, localObjectToPack, bl2, windowCursor);
        }
        finally {
            this.endCopyAsIs();
        }
    }

    private void copyAsIs2(PackOutputStream packOutputStream, LocalObjectToPack localObjectToPack, boolean bl2, WindowCursor windowCursor) {
        long l2;
        long l3;
        long l4;
        ByteArrayWindow byteArrayWindow;
        CRC32 cRC32 = bl2 ? new CRC32() : null;
        CRC32 cRC322 = bl2 ? new CRC32() : null;
        byte[] byArray = packOutputStream.getCopyBuffer();
        this.readFully(localObjectToPack.offset, byArray, 0, 20, windowCursor);
        int n2 = byArray[0] & 0xFF;
        int n3 = n2 >> 4 & 7;
        long l5 = n2 & 0xF;
        int n4 = 4;
        int n5 = 1;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n5++] & 0xFF;
            l5 += (long)(n2 & 0x7F) << n4;
            n4 += 7;
        }
        if (n3 == 6) {
            while (((n2 = byArray[n5++] & 0xFF) & 0x80) != 0) {
            }
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, n5);
                cRC322.update(byArray, 0, n5);
            }
        } else if (n3 == 7) {
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, n5);
                cRC322.update(byArray, 0, n5);
            }
            this.readFully(localObjectToPack.offset + (long)n5, byArray, 0, 20, windowCursor);
            if (bl2) {
                assert (cRC32 != null && cRC322 != null);
                cRC32.update(byArray, 0, 20);
                cRC322.update(byArray, 0, 20);
            }
            n5 += 20;
        } else if (bl2) {
            assert (cRC32 != null && cRC322 != null);
            cRC32.update(byArray, 0, n5);
            cRC322.update(byArray, 0, n5);
        }
        long l6 = localObjectToPack.offset + (long)n5;
        long l7 = localObjectToPack.length;
        try {
            byteArrayWindow = windowCursor.quickCopy(this, l6, l7);
            if (bl2 && this.idx().hasCRC32Support()) {
                assert (cRC32 != null);
                l4 = this.idx().findCRC32(localObjectToPack);
                if (byteArrayWindow != null) {
                    byteArrayWindow.crc32(cRC32, l6, (int)l7);
                } else {
                    int n6;
                    l3 = l6;
                    for (l2 = l7; l2 > 0L; l2 -= (long)n6) {
                        n6 = (int)Math.min(l2, (long)byArray.length);
                        this.readFully(l3, byArray, 0, n6, windowCursor);
                        cRC32.update(byArray, 0, n6);
                        l3 += (long)n6;
                    }
                }
                if (cRC32.getValue() != l4) {
                    this.setCorrupt(localObjectToPack.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, localObjectToPack.offset, this.getPackFile()));
                }
            } else if (bl2) {
                Inflater inflater = windowCursor.inflater();
                byte[] byArray2 = new byte[1024];
                if (byteArrayWindow != null) {
                    byteArrayWindow.check(inflater, byArray2, l6, (int)l7);
                } else {
                    int n7;
                    assert (cRC32 != null);
                    l2 = l6;
                    for (long i2 = l7; i2 > 0L; i2 -= (long)n7) {
                        n7 = (int)Math.min(i2, (long)byArray.length);
                        this.readFully(l2, byArray, 0, n7, windowCursor);
                        cRC32.update(byArray, 0, n7);
                        inflater.setInput(byArray, 0, n7);
                        while (inflater.inflate(byArray2, 0, byArray2.length) > 0) {
                        }
                        l2 += (long)n7;
                    }
                }
                if (!inflater.finished() || inflater.getBytesRead() != l7) {
                    this.setCorrupt(localObjectToPack.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, localObjectToPack.offset));
                }
                assert (cRC32 != null);
                l4 = cRC32.getValue();
            } else {
                l4 = -1L;
            }
        }
        catch (DataFormatException dataFormatException) {
            this.setCorrupt(localObjectToPack.offset);
            CorruptObjectException corruptObjectException = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, localObjectToPack.offset, this.getPackFile()), dataFormatException);
            throw new StoredObjectRepresentationNotAvailableException(localObjectToPack, (Throwable)corruptObjectException);
        }
        catch (IOException iOException) {
            throw new StoredObjectRepresentationNotAvailableException(localObjectToPack, (Throwable)iOException);
        }
        if (byteArrayWindow != null) {
            packOutputStream.writeHeader(localObjectToPack, l5);
            byteArrayWindow.write(packOutputStream, l6, (int)l7);
        } else if (l7 <= (long)byArray.length) {
            if (!bl2) {
                int n8;
                l3 = l6;
                for (l2 = l7; l2 > 0L; l2 -= (long)n8) {
                    n8 = (int)Math.min(l2, (long)byArray.length);
                    this.readFully(l3, byArray, 0, n8, windowCursor);
                    l3 += (long)n8;
                }
            }
            packOutputStream.writeHeader(localObjectToPack, l5);
            packOutputStream.write(byArray, 0, (int)l7);
        } else {
            int n9;
            packOutputStream.writeHeader(localObjectToPack, l5);
            l3 = l6;
            for (l2 = l7; l2 > 0L; l2 -= (long)n9) {
                n9 = (int)Math.min(l2, (long)byArray.length);
                this.readFully(l3, byArray, 0, n9, windowCursor);
                if (bl2) {
                    assert (cRC322 != null);
                    cRC322.update(byArray, 0, n9);
                }
                packOutputStream.write(byArray, 0, n9);
                l3 += (long)n9;
            }
            if (bl2) {
                assert (cRC322 != null);
                if (cRC322.getValue() != l4) {
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, localObjectToPack.offset, this.getPackFile()));
                }
            }
        }
    }

    boolean invalid() {
        return this.invalid;
    }

    void setInvalid() {
        this.invalid = true;
    }

    int incrementTransientErrorCount() {
        return this.transientErrorCount.incrementAndGet();
    }

    void resetTransientErrorCount() {
        this.transientErrorCount.set(0);
    }

    private void readFully(long l2, byte[] byArray, int n2, int n3, WindowCursor windowCursor) {
        if (windowCursor.copy(this, l2, byArray, n2, n3) != n3) {
            throw new EOFException();
        }
    }

    private synchronized void beginCopyAsIs(ObjectToPack objectToPack) {
        if (++this.activeCopyRawData == 1 && this.activeWindows == 0) {
            try {
                this.doOpen();
            }
            catch (IOException iOException) {
                throw new StoredObjectRepresentationNotAvailableException(objectToPack, (Throwable)iOException);
            }
        }
    }

    private synchronized void endCopyAsIs() {
        if (--this.activeCopyRawData == 0 && this.activeWindows == 0) {
            this.doClose();
        }
    }

    synchronized boolean beginWindowCache() {
        if (++this.activeWindows == 1) {
            if (this.activeCopyRawData == 0) {
                this.doOpen();
            }
            return true;
        }
        return false;
    }

    synchronized boolean endWindowCache() {
        boolean bl2;
        boolean bl3 = bl2 = --this.activeWindows == 0;
        if (bl2 && this.activeCopyRawData == 0) {
            this.doClose();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen() {
        if (this.invalid) {
            this.openFail(true, this.invalidatingCause);
            throw new PackInvalidException(this.packFile, (Throwable)this.invalidatingCause);
        }
        try {
            Object object = this.readLock;
            synchronized (object) {
                this.fd = new RandomAccessFile(this.packFile, "r");
                this.length = this.fd.length();
                this.onOpenPack();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.openFail(false, interruptedIOException);
            throw interruptedIOException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.openFail(!this.packFile.exists(), fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (EOFException | AccessDeniedException | NoSuchFileException | CorruptObjectException | NoPackSignatureException | PackMismatchException | UnpackException | UnsupportedPackIndexVersionException | UnsupportedPackVersionException iOException) {
            this.openFail(true, iOException);
            throw iOException;
        }
        catch (IOException | RuntimeException exception) {
            this.openFail(false, exception);
            throw exception;
        }
    }

    private void openFail(boolean bl2, Exception exception) {
        this.activeWindows = 0;
        this.activeCopyRawData = 0;
        this.invalid = bl2;
        this.invalidatingCause = exception;
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.fd != null) {
                try {
                    this.fd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.fd = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteArrayWindow read(long l2, int n2) {
        Object object = this.readLock;
        synchronized (object) {
            if (this.invalid || this.fd == null) {
                throw new PackInvalidException(this.packFile, (Throwable)this.invalidatingCause);
            }
            if (this.length < l2 + (long)n2) {
                n2 = (int)(this.length - l2);
            }
            byte[] byArray = new byte[n2];
            this.fd.seek(l2);
            this.fd.readFully(byArray, 0, n2);
            return new ByteArrayWindow(this, l2, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteWindow mmap(long l2, int n2) {
        Object object = this.readLock;
        synchronized (object) {
            MappedByteBuffer mappedByteBuffer;
            if (this.length < l2 + (long)n2) {
                n2 = (int)(this.length - l2);
            }
            try {
                mappedByteBuffer = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, l2, n2);
            }
            catch (IOException iOException) {
                System.gc();
                System.runFinalization();
                mappedByteBuffer = this.fd.getChannel().map(FileChannel.MapMode.READ_ONLY, l2, n2);
            }
            if (mappedByteBuffer.hasArray()) {
                return new ByteArrayWindow(this, l2, mappedByteBuffer.array());
            }
            return new ByteBufferWindow(this, l2, mappedByteBuffer);
        }
    }

    private void onOpenPack() {
        PackIndex packIndex = this.idx();
        byte[] byArray = new byte[20];
        this.fd.seek(0L);
        this.fd.readFully(byArray, 0, 12);
        if (RawParseUtils.match(byArray, 0, Constants.PACK_SIGNATURE) != 4) {
            throw new NoPackSignatureException(JGitText.get().notAPACKFile);
        }
        long l2 = NB.decodeUInt32(byArray, 4);
        long l3 = NB.decodeUInt32(byArray, 8);
        if (l2 != 2L && l2 != 3L) {
            throw new UnsupportedPackVersionException(l2);
        }
        if (l3 != packIndex.getObjectCount()) {
            throw new PackMismatchException(MessageFormat.format(JGitText.get().packObjectCountMismatch, l3, packIndex.getObjectCount(), this.getPackFile()));
        }
        this.fd.seek(this.length - 20L);
        this.fd.readFully(byArray, 0, 20);
        if (!Arrays.equals(byArray, this.packChecksum)) {
            throw new PackMismatchException(MessageFormat.format(JGitText.get().packChecksumMismatch, this.getPackFile(), ObjectId.fromRaw(byArray).name(), ObjectId.fromRaw(packIndex.packChecksum).name()));
        }
    }

    ObjectLoader load(WindowCursor windowCursor, long l2) {
        try {
            byte[] byArray = windowCursor.tempId;
            Pack$Delta pack$Delta = null;
            byte[] byArray2 = null;
            int n2 = -1;
            boolean bl2 = false;
            block9: while (true) {
                this.readFully(l2, byArray, 0, 20, windowCursor);
                int n3 = byArray[0] & 0xFF;
                int n4 = n3 >> 4 & 7;
                long l3 = n3 & 0xF;
                int n5 = 4;
                int n6 = 1;
                while ((n3 & 0x80) != 0) {
                    n3 = byArray[n6++] & 0xFF;
                    l3 += (long)(n3 & 0x7F) << n5;
                    n5 += 7;
                }
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (pack$Delta != null || l3 < (long)windowCursor.getStreamFileThreshold()) {
                            byArray2 = this.decompress(l2 + (long)n6, (int)l3, windowCursor);
                        }
                        if (pack$Delta != null) {
                            n2 = n4;
                            break block9;
                        }
                        if (byArray2 != null) {
                            return new ObjectLoader$SmallObject(n4, byArray2);
                        }
                        return new LargePackedWholeObject(n4, l3, l2, n6, this, windowCursor.db);
                    }
                    case 6: {
                        n3 = byArray[n6++] & 0xFF;
                        long l4 = n3 & 0x7F;
                        while ((n3 & 0x80) != 0) {
                            ++l4;
                            n3 = byArray[n6++] & 0xFF;
                            l4 <<= 7;
                            l4 += (long)(n3 & 0x7F);
                        }
                        l4 = l2 - l4;
                        pack$Delta = new Pack$Delta(pack$Delta, l2, (int)l3, n6, l4);
                        if (l3 != (long)pack$Delta.deltaSize) break block9;
                        DeltaBaseCache$Entry deltaBaseCache$Entry = windowCursor.getDeltaBaseCache().get(this, l4);
                        if (deltaBaseCache$Entry != null) {
                            n2 = deltaBaseCache$Entry.type;
                            byArray2 = deltaBaseCache$Entry.data;
                            bl2 = true;
                            break block9;
                        }
                        l2 = l4;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(l2 + (long)n6, byArray, 0, 20, windowCursor);
                        long l4 = this.findDeltaBase(ObjectId.fromRaw(byArray));
                        pack$Delta = new Pack$Delta(pack$Delta, l2, (int)l3, n6 + 20, l4);
                        if (l3 != (long)pack$Delta.deltaSize) break block9;
                        DeltaBaseCache$Entry deltaBaseCache$Entry = windowCursor.getDeltaBaseCache().get(this, l4);
                        if (deltaBaseCache$Entry != null) {
                            n2 = deltaBaseCache$Entry.type;
                            byArray2 = deltaBaseCache$Entry.data;
                            bl2 = true;
                            break block9;
                        }
                        l2 = l4;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n4));
                    }
                }
                break;
            }
            if (byArray2 == null) {
                throw new IOException(JGitText.get().inMemoryBufferLimitExceeded);
            }
            assert (pack$Delta != null);
            do {
                byte[] byArray3;
                if (bl2) {
                    bl2 = false;
                } else if (pack$Delta.next == null) {
                    windowCursor.getDeltaBaseCache().store(this, pack$Delta.basePos, byArray2, n2);
                }
                l2 = pack$Delta.deltaPos;
                byte[] byArray4 = this.decompress(l2 + (long)pack$Delta.hdrLen, pack$Delta.deltaSize, windowCursor);
                if (byArray4 == null) {
                    byArray2 = null;
                    throw new LargeObjectException$OutOfMemory(new OutOfMemoryError());
                }
                long l5 = BinaryDelta.getResultSize(byArray4);
                if (Integer.MAX_VALUE <= l5) {
                    throw new LargeObjectException$ExceedsByteArrayLimit();
                }
                try {
                    byArray3 = new byte[(int)l5];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    byArray2 = null;
                    throw new LargeObjectException$OutOfMemory(outOfMemoryError);
                }
                BinaryDelta.apply(byArray2, byArray4, byArray3);
                byArray2 = byArray3;
            } while ((pack$Delta = pack$Delta.next) != null);
            return new ObjectLoader$SmallObject(n2, byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, l2, this.getPackFile()), dataFormatException);
        }
    }

    private long findDeltaBase(ObjectId objectId) {
        long l2 = this.idx().findOffset(objectId);
        if (l2 < 0L) {
            throw new MissingObjectException(objectId, JGitText.get().missingDeltaBase);
        }
        return l2;
    }

    byte[] getDeltaHeader(WindowCursor windowCursor, long l2) {
        byte[] byArray = new byte[18];
        windowCursor.inflate(this, l2, byArray, true);
        return byArray;
    }

    int getObjectType(WindowCursor windowCursor, long l2) {
        int n2;
        byte[] byArray = windowCursor.tempId;
        block5: while (true) {
            this.readFully(l2, byArray, 0, 20, windowCursor);
            int n3 = byArray[0] & 0xFF;
            n2 = n3 >> 4 & 7;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return n2;
                }
                case 6: {
                    int n4 = 1;
                    while ((n3 & 0x80) != 0) {
                        n3 = byArray[n4++] & 0xFF;
                    }
                    n3 = byArray[n4++] & 0xFF;
                    long l3 = n3 & 0x7F;
                    while ((n3 & 0x80) != 0) {
                        ++l3;
                        n3 = byArray[n4++] & 0xFF;
                        l3 <<= 7;
                        l3 += (long)(n3 & 0x7F);
                    }
                    l2 -= l3;
                    continue block5;
                }
                case 7: {
                    int n4 = 1;
                    while ((n3 & 0x80) != 0) {
                        n3 = byArray[n4++] & 0xFF;
                    }
                    this.readFully(l2 + (long)n4, byArray, 0, 20, windowCursor);
                    l2 = this.findDeltaBase(ObjectId.fromRaw(byArray));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n2));
    }

    long getObjectSize(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        long l2 = this.idx().findOffset(anyObjectId);
        return 0L < l2 ? this.getObjectSize(windowCursor, l2) : -1L;
    }

    long getObjectSize(WindowCursor windowCursor, long l2) {
        long l3;
        byte[] byArray = windowCursor.tempId;
        this.readFully(l2, byArray, 0, 20, windowCursor);
        int n2 = byArray[0] & 0xFF;
        int n3 = n2 >> 4 & 7;
        long l4 = n2 & 0xF;
        int n4 = 4;
        int n5 = 1;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n5++] & 0xFF;
            l4 += (long)(n2 & 0x7F) << n4;
            n4 += 7;
        }
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return l4;
            }
            case 6: {
                n2 = byArray[n5++] & 0xFF;
                while ((n2 & 0x80) != 0) {
                    n2 = byArray[n5++] & 0xFF;
                }
                l3 = l2 + (long)n5;
                break;
            }
            case 7: {
                l3 = l2 + (long)n5 + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n3));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(windowCursor, l3));
        }
        catch (DataFormatException dataFormatException) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, l2, this.getPackFile()), dataFormatException);
        }
    }

    LocalObjectRepresentation representation(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        long l2 = this.idx().findOffset(anyObjectId);
        if (l2 < 0L) {
            return null;
        }
        byte[] byArray = windowCursor.tempId;
        this.readFully(l2, byArray, 0, 20, windowCursor);
        int n2 = byArray[0] & 0xFF;
        int n3 = 1;
        int n4 = n2 >> 4 & 7;
        while ((n2 & 0x80) != 0) {
            n2 = byArray[n3++] & 0xFF;
        }
        long l3 = this.findEndOffset(l2) - l2;
        switch (n4) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return LocalObjectRepresentation.newWhole(this, l2, l3 - (long)n3);
            }
            case 6: {
                n2 = byArray[n3++] & 0xFF;
                long l4 = n2 & 0x7F;
                while ((n2 & 0x80) != 0) {
                    ++l4;
                    n2 = byArray[n3++] & 0xFF;
                    l4 <<= 7;
                    l4 += (long)(n2 & 0x7F);
                }
                l4 = l2 - l4;
                return LocalObjectRepresentation.newDelta(this, l2, l3 - (long)n3, l4);
            }
            case 7: {
                l3 -= (long)n3;
                this.readFully(l2 + (long)n3, byArray, 0, 20, windowCursor);
                ObjectId objectId = ObjectId.fromRaw(byArray);
                return LocalObjectRepresentation.newDelta(this, l2, l3 -= 20L, objectId);
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, n4));
    }

    private long findEndOffset(long l2) {
        long l3 = this.length - 20L;
        return this.getReverseIdx().findNextOffset(l2, l3);
    }

    synchronized PackBitmapIndex getBitmapIndex() {
        if (this.invalid || this.bitmapIdxFile == null) {
            return null;
        }
        if (this.bitmapIdx == null) {
            PackBitmapIndex packBitmapIndex;
            try {
                packBitmapIndex = PackBitmapIndex.open(this.bitmapIdxFile, this.idx(), this.getReverseIdx());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.bitmapIdxFile = null;
                return null;
            }
            if (Arrays.equals(this.packChecksum, packBitmapIndex.packChecksum)) {
                this.bitmapIdx = packBitmapIndex;
            } else {
                this.bitmapIdxFile = null;
            }
        }
        return this.bitmapIdx;
    }

    private synchronized PackReverseIndex getReverseIdx() {
        if (this.reverseIdx == null) {
            this.reverseIdx = new PackReverseIndex(this.idx());
        }
        return this.reverseIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCorrupt(long l2) {
        LongList longList = this.corruptObjects;
        if (longList == null) {
            return false;
        }
        LongList longList2 = longList;
        synchronized (longList2) {
            return longList.contains(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long l2) {
        Object object;
        LongList longList = this.corruptObjects;
        if (longList == null) {
            object = this.readLock;
            synchronized (object) {
                longList = this.corruptObjects;
                if (longList == null) {
                    this.corruptObjects = longList = new LongList();
                }
            }
        }
        object = longList;
        synchronized (object) {
            longList.add(l2);
        }
    }

    public String toString() {
        return "Pack [packFileName=" + this.packFile.getName() + ", length=" + this.packFile.length() + ", packChecksum=" + ObjectId.fromRaw(this.packChecksum).name() + "]";
    }
}

