/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackParser$UnresolvedDelta;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.NB;

public class ObjectDirectoryPackParser
extends PackParser {
    private final FileObjectDatabase db;
    private final CRC32 crc;
    private final MessageDigest tailDigest;
    private int indexVersion;
    private boolean keepEmpty;
    private File tmpPack;
    private File tmpIdx;
    private RandomAccessFile out;
    private long origEnd;
    private byte[] origHash;
    private long packEnd;
    private byte[] packHash;
    private Deflater def;
    private Pack newPack;
    private PackConfig pconfig;

    ObjectDirectoryPackParser(FileObjectDatabase fileObjectDatabase, InputStream inputStream) {
        super(fileObjectDatabase, inputStream);
        this.db = fileObjectDatabase;
        this.pconfig = new PackConfig(fileObjectDatabase.getConfig());
        this.crc = new CRC32();
        this.tailDigest = Constants.newMessageDigest();
        this.indexVersion = ((CoreConfig)this.db.getConfig().get(CoreConfig.KEY)).getPackIndexVersion();
    }

    public void setIndexVersion(int n2) {
        this.indexVersion = n2;
    }

    public void setKeepEmpty(boolean bl2) {
        this.keepEmpty = bl2;
    }

    public Pack getPack() {
        return this.newPack;
    }

    @Override
    public long getPackSize() {
        if (this.newPack == null) {
            return super.getPackSize();
        }
        PackFile packFile = this.newPack.getPackFile();
        long l2 = packFile.length();
        String string = packFile.getAbsolutePath();
        String string2 = string.substring(0, string.length() - ".pack".length()) + ".idx";
        File file = new File(string2);
        if (file.isFile()) {
            l2 += file.length();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackLock parse(ProgressMonitor progressMonitor, ProgressMonitor progressMonitor2) {
        this.tmpPack = File.createTempFile("incoming_", ".pack", this.db.getDirectory());
        this.tmpIdx = new File(this.db.getDirectory(), ObjectDirectoryPackParser.baseName(this.tmpPack) + ".idx");
        try {
            this.out = new RandomAccessFile(this.tmpPack, "rw");
            super.parse(progressMonitor, progressMonitor2);
            this.out.seek(this.packEnd);
            this.out.write(this.packHash);
            this.out.getChannel().force(true);
            this.out.close();
            this.writeIdx();
            this.tmpPack.setReadOnly();
            this.tmpIdx.setReadOnly();
            PackLock packLock = this.renameAndOpenPack(this.getLockMessage());
            return packLock;
        }
        finally {
            if (this.def != null) {
                this.def.end();
            }
            try {
                if (this.out != null && this.out.getChannel().isOpen()) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            this.cleanupTemporaryFiles();
        }
    }

    @Override
    protected void onPackHeader(long l2) {
    }

    @Override
    protected void onBeginWholeObject(long l2, int n2, long l3) {
        this.crc.reset();
    }

    @Override
    protected void onEndWholeObject(PackedObjectInfo packedObjectInfo) {
        packedObjectInfo.setCRC((int)this.crc.getValue());
    }

    @Override
    protected void onBeginOfsDelta(long l2, long l3, long l4) {
        this.crc.reset();
    }

    @Override
    protected void onBeginRefDelta(long l2, AnyObjectId anyObjectId, long l3) {
        this.crc.reset();
    }

    @Override
    protected PackParser$UnresolvedDelta onEndDelta() {
        PackParser$UnresolvedDelta packParser$UnresolvedDelta = new PackParser$UnresolvedDelta();
        packParser$UnresolvedDelta.setCRC((int)this.crc.getValue());
        return packParser$UnresolvedDelta;
    }

    @Override
    protected void onInflatedObjectData(PackedObjectInfo packedObjectInfo, int n2, byte[] byArray) {
    }

    @Override
    protected void onObjectHeader(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onObjectData(PackParser.Source source, byte[] byArray, int n2, int n3) {
        this.crc.update(byArray, n2, n3);
    }

    @Override
    protected void onStoreStream(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
    }

    @Override
    protected void onPackFooter(byte[] byArray) {
        this.origEnd = this.packEnd = this.out.getFilePointer();
        this.origHash = byArray;
        this.packHash = byArray;
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackParser$UnresolvedDelta packParser$UnresolvedDelta, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.out.seek(packParser$UnresolvedDelta.getOffset());
        this.crc.reset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected PackParser.ObjectTypeAndSize seekDatabase(PackedObjectInfo packedObjectInfo, PackParser.ObjectTypeAndSize objectTypeAndSize) {
        this.out.seek(packedObjectInfo.getOffset());
        this.crc.reset();
        return this.readObjectHeader(objectTypeAndSize);
    }

    @Override
    protected int readDatabase(byte[] byArray, int n2, int n3) {
        return this.out.read(byArray, n2, n3);
    }

    @Override
    protected boolean checkCRC(int n2) {
        return n2 == (int)this.crc.getValue();
    }

    private static String baseName(File file) {
        String string = file.getName();
        return string.substring(0, string.lastIndexOf(46));
    }

    private void cleanupTemporaryFiles() {
        if (this.tmpIdx != null && !this.tmpIdx.delete() && this.tmpIdx.exists()) {
            this.tmpIdx.deleteOnExit();
        }
        if (this.tmpPack != null && !this.tmpPack.delete() && this.tmpPack.exists()) {
            this.tmpPack.deleteOnExit();
        }
    }

    @Override
    protected boolean onAppendBase(int n2, byte[] byArray, PackedObjectInfo packedObjectInfo) {
        packedObjectInfo.setOffset(this.packEnd);
        byte[] byArray2 = this.buffer();
        int n3 = byArray.length;
        int n4 = 0;
        byArray2[n4++] = (byte)(n2 << 4 | n3 & 0xF);
        n3 >>>= 4;
        while (n3 > 0) {
            int n5 = n4 - 1;
            byArray2[n5] = (byte)(byArray2[n5] | 0xFFFFFF80);
            byArray2[n4++] = (byte)(n3 & 0x7F);
            n3 >>>= 7;
        }
        this.tailDigest.update(byArray2, 0, n4);
        this.crc.reset();
        this.crc.update(byArray2, 0, n4);
        this.out.seek(this.packEnd);
        this.out.write(byArray2, 0, n4);
        this.packEnd += (long)n4;
        if (this.def == null) {
            this.def = new Deflater(-1, false);
        } else {
            this.def.reset();
        }
        this.def.setInput(byArray);
        this.def.finish();
        while (!this.def.finished()) {
            n4 = this.def.deflate(byArray2);
            this.tailDigest.update(byArray2, 0, n4);
            this.crc.update(byArray2, 0, n4);
            this.out.write(byArray2, 0, n4);
            this.packEnd += (long)n4;
        }
        packedObjectInfo.setCRC((int)this.crc.getValue());
        return true;
    }

    @Override
    protected void onEndThinPack() {
        int n2;
        byte[] byArray = this.buffer();
        MessageDigest messageDigest = Constants.newMessageDigest();
        MessageDigest messageDigest2 = Constants.newMessageDigest();
        MessageDigest messageDigest3 = Constants.newMessageDigest();
        long l2 = this.origEnd;
        this.out.seek(0L);
        this.out.readFully(byArray, 0, 12);
        messageDigest.update(byArray, 0, 12);
        l2 -= 12L;
        NB.encodeInt32(byArray, 8, this.getObjectCount());
        this.out.seek(0L);
        this.out.write(byArray, 0, 12);
        messageDigest3.update(byArray, 0, 12);
        while ((n2 = this.out.read(byArray)) >= 0) {
            if (l2 != 0L) {
                int n3 = (int)Math.min((long)n2, l2);
                messageDigest.update(byArray, 0, n3);
                if ((l2 -= (long)n3) == 0L) {
                    messageDigest2.update(byArray, n3, n2 - n3);
                }
            } else {
                messageDigest2.update(byArray, 0, n2);
            }
            messageDigest3.update(byArray, 0, n2);
        }
        if (!Arrays.equals(messageDigest.digest(), this.origHash) || !Arrays.equals(messageDigest2.digest(), this.tailDigest.digest())) {
            throw new IOException(JGitText.get().packCorruptedWhileWritingToFilesystem);
        }
        this.packHash = messageDigest3.digest();
    }

    private void writeIdx() {
        List list = this.getSortedObjectList(null);
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.tmpIdx);){
            PackIndexWriter packIndexWriter = this.indexVersion <= 0 ? PackIndexWriter.createOldestPossible(fileOutputStream, list) : PackIndexWriter.createVersion(fileOutputStream, this.indexVersion);
            packIndexWriter.write(list, this.packHash);
            fileOutputStream.getChannel().force(true);
        }
    }

    private PackLock renameAndOpenPack(String string) {
        Comparable comparable;
        if (!this.keepEmpty && this.getObjectCount() == 0) {
            this.cleanupTemporaryFiles();
            return null;
        }
        MessageDigest messageDigest = Constants.newMessageDigest();
        byte[] byArray = new byte[20];
        for (int i2 = 0; i2 < this.getObjectCount(); ++i2) {
            comparable = this.getObject(i2);
            ((AnyObjectId)comparable).copyRawTo(byArray, 0);
            messageDigest.update(byArray);
        }
        ObjectId objectId = ObjectId.fromRaw(messageDigest.digest());
        comparable = new File(this.db.getDirectory(), "pack");
        PackFile packFile = new PackFile((File)comparable, objectId, PackExt.PACK);
        PackFile packFile2 = packFile.create(PackExt.INDEX);
        PackLock packLock = new PackLock(packFile, this.db.getFS());
        if (!(((File)comparable).exists() || ((File)comparable).mkdir() || ((File)comparable).exists())) {
            this.cleanupTemporaryFiles();
            throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, ((File)comparable).getAbsolutePath()));
        }
        if (packFile.exists()) {
            this.cleanupTemporaryFiles();
            return null;
        }
        if (string != null) {
            try {
                if (!packLock.lock(string)) {
                    throw new LockFailedException(packFile, MessageFormat.format(JGitText.get().cannotLockPackIn, packFile));
                }
            }
            catch (IOException iOException) {
                this.cleanupTemporaryFiles();
                throw iOException;
            }
        }
        try {
            FileUtils.rename(this.tmpPack, packFile, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            this.cleanupTemporaryFiles();
            packLock.unlock();
            throw new IOException(MessageFormat.format(JGitText.get().cannotMovePackTo, packFile), iOException);
        }
        try {
            FileUtils.rename(this.tmpIdx, packFile2, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            this.cleanupTemporaryFiles();
            packLock.unlock();
            if (!packFile.delete()) {
                packFile.deleteOnExit();
            }
            throw new IOException(MessageFormat.format(JGitText.get().cannotMoveIndexTo, packFile2), iOException);
        }
        boolean bl2 = false;
        try {
            FileSnapshot fileSnapshot = FileSnapshot.save(packFile, this.db.getFS());
            if (this.pconfig.doWaitPreventRacyPack(fileSnapshot.size())) {
                fileSnapshot.waitUntilNotRacy();
            }
        }
        catch (InterruptedException interruptedException) {
            bl2 = true;
        }
        try {
            this.newPack = this.db.openPack(packFile);
        }
        catch (IOException iOException) {
            packLock.unlock();
            if (packFile.exists()) {
                FileUtils.delete(packFile);
            }
            if (packFile2.exists()) {
                FileUtils.delete(packFile2);
            }
            throw iOException;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
        return string != null ? packLock : null;
    }
}

