/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter$SHA1OutputStream;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.sha1.SHA1;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final FileObjectDatabase db;
    private final WriteConfig config;
    private Deflater deflate;

    ObjectDirectoryInserter(FileObjectDatabase fileObjectDatabase, Config config) {
        this.db = fileObjectDatabase;
        this.config = (WriteConfig)config.get(WriteConfig.KEY);
    }

    @Override
    public ObjectId insert(int n2, byte[] byArray, int n3, int n4) {
        return this.insert(n2, byArray, n3, n4, false);
    }

    private ObjectId insert(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        ObjectId objectId = this.idFor(n2, byArray, n3, n4);
        if (!bl2 && this.db.has(objectId)) {
            return objectId;
        }
        File file = this.toTemp(n2, byArray, n3, n4);
        return this.insertOneObject(file, objectId, bl2);
    }

    @Override
    public ObjectId insert(int n2, long l2, InputStream inputStream) {
        return this.insert(n2, l2, inputStream, false);
    }

    ObjectId insert(int n2, long l2, InputStream inputStream, boolean bl2) {
        if (l2 <= (long)this.buffer().length) {
            byte[] byArray = this.buffer();
            int n3 = IO.readFully(inputStream, byArray, 0);
            return this.insert(n2, byArray, 0, n3, bl2);
        }
        SHA1 sHA1 = this.digest();
        File file = this.toTemp(sHA1, n2, l2, inputStream);
        ObjectId objectId = sHA1.toObjectId();
        return this.insertOneObject(file, objectId, bl2);
    }

    private ObjectId insertOneObject(File file, ObjectId objectId, boolean bl2) {
        switch (this.db.insertUnpackedObject(file, objectId, bl2)) {
            case INSERTED: 
            case EXISTS_PACKED: 
            case EXISTS_LOOSE: {
                return objectId;
            }
        }
        File file2 = this.db.fileFor(objectId);
        throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToCreateNewObject, file2));
    }

    @Override
    public PackParser newPackParser(InputStream inputStream) {
        return new ObjectDirectoryPackParser(this.db, inputStream);
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db, this);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
            }
            finally {
                this.deflate = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File toTemp(SHA1 sHA1, int n2, long l2, InputStream inputStream) {
        boolean bl2 = true;
        File file = this.newTempFile();
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                Object object;
                try {
                    object = fileOutputStream;
                    if (this.config.getFSyncObjectFiles()) {
                        object = Channels.newOutputStream(fileOutputStream.getChannel());
                    }
                    DeflaterOutputStream deflaterOutputStream = this.compress((OutputStream)object);
                    ObjectDirectoryInserter$SHA1OutputStream objectDirectoryInserter$SHA1OutputStream = new ObjectDirectoryInserter$SHA1OutputStream(deflaterOutputStream, sHA1);
                    this.writeHeader(objectDirectoryInserter$SHA1OutputStream, n2, l2);
                    byte[] byArray = this.buffer();
                    while (l2 > 0L) {
                        int n3 = inputStream.read(byArray, 0, (int)Math.min(l2, (long)byArray.length));
                        if (n3 <= 0) {
                            throw ObjectDirectoryInserter.shortInput(l2);
                        }
                        objectDirectoryInserter$SHA1OutputStream.write(byArray, 0, n3);
                        l2 -= (long)n3;
                    }
                    objectDirectoryInserter$SHA1OutputStream.flush();
                    deflaterOutputStream.finish();
                }
                finally {
                    if (this.config.getFSyncObjectFiles()) {
                        fileOutputStream.getChannel().force(true);
                    }
                }
                bl2 = false;
                object = file;
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bl2) {
                FileUtils.delete(file, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File toTemp(int n2, byte[] byArray, int n3, int n4) {
        boolean bl2 = true;
        File file = this.newTempFile();
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                Object object;
                try {
                    object = fileOutputStream;
                    if (this.config.getFSyncObjectFiles()) {
                        object = Channels.newOutputStream(fileOutputStream.getChannel());
                    }
                    DeflaterOutputStream deflaterOutputStream = this.compress((OutputStream)object);
                    this.writeHeader(deflaterOutputStream, n2, n4);
                    deflaterOutputStream.write(byArray, n3, n4);
                    deflaterOutputStream.finish();
                }
                finally {
                    if (this.config.getFSyncObjectFiles()) {
                        fileOutputStream.getChannel().force(true);
                    }
                }
                bl2 = false;
                object = file;
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (bl2) {
                FileUtils.delete(file, 2);
            }
        }
    }

    void writeHeader(OutputStream outputStream, int n2, long l2) {
        outputStream.write(Constants.encodedTypeString(n2));
        outputStream.write(32);
        outputStream.write(Constants.encodeASCII(l2));
        outputStream.write(0);
    }

    File newTempFile() {
        return File.createTempFile("noz", null, this.db.getDirectory());
    }

    DeflaterOutputStream compress(OutputStream outputStream) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(outputStream, this.deflate, 8192);
    }

    private static EOFException shortInput(long l2) {
        return new EOFException(MessageFormat.format(JGitText.get().inputDidntMatchLength, l2));
    }
}

