/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.CachedObjectDirectory;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase$InsertLooseObjectResult;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LooseObjects;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateHandle;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateHandle$Id;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateRepository;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.RepositoryCache$FileKey;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class ObjectDirectory
extends FileObjectDatabase {
    private static final int RESOLVE_ABBREV_LIMIT = 256;
    private final ObjectDirectory$AlternateHandle handle = new ObjectDirectory$AlternateHandle(this);
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final LooseObjects loose;
    private final PackDirectory packed;
    private final PackDirectory preserved;
    private final File alternatesFile;
    private final FS fs;
    private final AtomicReference alternates;
    private final File shallowFile;
    private FileSnapshot shallowFileSnapshot = FileSnapshot.DIRTY;
    private Set shallowCommitsIds;

    public ObjectDirectory(Config config, File file, File[] fileArray, FS fS, File file2) {
        this.config = config;
        this.objects = file;
        this.infoDirectory = new File(this.objects, "info");
        File file3 = new File(this.objects, "pack");
        File file4 = new File(file3, "preserved");
        this.alternatesFile = new File(this.objects, "info/alternates");
        this.loose = new LooseObjects(this.objects);
        this.packed = new PackDirectory(this.config, file3);
        this.preserved = new PackDirectory(this.config, file4);
        this.fs = fS;
        this.shallowFile = file2;
        this.alternates = new AtomicReference();
        if (fileArray != null) {
            ObjectDirectory$AlternateHandle[] objectDirectory$AlternateHandleArray = new ObjectDirectory$AlternateHandle[fileArray.length];
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                objectDirectory$AlternateHandleArray[i2] = this.openAlternate(fileArray[i2]);
            }
            this.alternates.set(objectDirectory$AlternateHandleArray);
        }
    }

    @Override
    public final File getDirectory() {
        return this.loose.getDirectory();
    }

    public final File getPackDirectory() {
        return this.packed.getDirectory();
    }

    public final File getPreservedDirectory() {
        return this.preserved.getDirectory();
    }

    @Override
    public boolean exists() {
        return this.fs.exists(this.objects);
    }

    @Override
    public void create() {
        this.loose.create();
        FileUtils.mkdir(this.infoDirectory);
        this.packed.create();
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    public PackInserter newPackInserter() {
        return new PackInserter(this);
    }

    @Override
    public void close() {
        this.loose.close();
        this.packed.close();
        ObjectDirectory$AlternateHandle[] objectDirectory$AlternateHandleArray = (ObjectDirectory$AlternateHandle[])this.alternates.get();
        if (objectDirectory$AlternateHandleArray != null && this.alternates.compareAndSet(objectDirectory$AlternateHandleArray, null)) {
            for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : objectDirectory$AlternateHandleArray) {
                objectDirectory$AlternateHandle.close();
            }
        }
    }

    @Override
    public Collection getPacks() {
        return this.packed.getPacks();
    }

    @Override
    public Pack openPack(File file) {
        PackFile packFile;
        try {
            packFile = new PackFile(file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, file), illegalArgumentException);
        }
        String string = packFile.getName();
        if (string.length() != 50 || !string.startsWith("pack-") || !packFile.getPackExt().equals((Object)PackExt.PACK)) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, file));
        }
        PackFile packFile2 = packFile.create(PackExt.BITMAP_INDEX);
        Pack pack = new Pack(file, packFile2.exists() ? packFile2 : null);
        this.packed.insert(pack);
        return pack;
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    public boolean has(AnyObjectId anyObjectId) {
        return this.loose.hasCached(anyObjectId) || this.hasPackedOrLooseInSelfOrAlternate(anyObjectId) || this.restoreFromSelfOrAlternate(anyObjectId, null) && this.hasPackedOrLooseInSelfOrAlternate(anyObjectId);
    }

    private boolean hasPackedOrLooseInSelfOrAlternate(AnyObjectId anyObjectId) {
        return this.hasPackedInSelfOrAlternate(anyObjectId, null) || this.hasLooseInSelfOrAlternate(anyObjectId, null);
    }

    private boolean hasPackedInSelfOrAlternate(AnyObjectId anyObjectId, Set set) {
        if (this.hasPackedObject(anyObjectId)) {
            return true;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || !objectDirectory$AlternateHandle.db.hasPackedInSelfOrAlternate(anyObjectId, set)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLooseInSelfOrAlternate(AnyObjectId anyObjectId, Set set) {
        if (this.loose.has(anyObjectId)) {
            return true;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || !objectDirectory$AlternateHandle.db.hasLooseInSelfOrAlternate(anyObjectId, set)) continue;
            return true;
        }
        return false;
    }

    boolean hasPackedObject(AnyObjectId anyObjectId) {
        return this.packed.has(anyObjectId);
    }

    @Override
    void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId) {
        this.resolve(set, abbreviatedObjectId, null);
    }

    private void resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, Set set2) {
        if (!this.packed.resolve(set, abbreviatedObjectId, 256)) {
            return;
        }
        if (!this.loose.resolve(set, abbreviatedObjectId, 256)) {
            return;
        }
        set2 = this.addMe(set2);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set2.contains(objectDirectory$AlternateHandle.getId())) continue;
            objectDirectory$AlternateHandle.db.resolve(set, abbreviatedObjectId, set2);
            if (set.size() <= 256) continue;
            return;
        }
    }

    @Override
    ObjectLoader openObject(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        ObjectLoader objectLoader = this.openObjectWithoutRestoring(windowCursor, anyObjectId);
        if (objectLoader == null && this.restoreFromSelfOrAlternate(anyObjectId, null)) {
            objectLoader = this.openObjectWithoutRestoring(windowCursor, anyObjectId);
        }
        return objectLoader;
    }

    private ObjectLoader openObjectWithoutRestoring(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        ObjectLoader objectLoader;
        if (this.loose.hasCached(anyObjectId) && (objectLoader = this.openLooseObject(windowCursor, anyObjectId)) != null) {
            return objectLoader;
        }
        objectLoader = this.openPackedFromSelfOrAlternate(windowCursor, anyObjectId, null);
        if (objectLoader != null) {
            return objectLoader;
        }
        return this.openLooseFromSelfOrAlternate(windowCursor, anyObjectId, null);
    }

    private ObjectLoader openPackedFromSelfOrAlternate(WindowCursor windowCursor, AnyObjectId anyObjectId, Set set) {
        ObjectLoader objectLoader = this.openPackedObject(windowCursor, anyObjectId);
        if (objectLoader != null) {
            return objectLoader;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || (objectLoader = objectDirectory$AlternateHandle.db.openPackedFromSelfOrAlternate(windowCursor, anyObjectId, set)) == null) continue;
            return objectLoader;
        }
        return null;
    }

    private ObjectLoader openLooseFromSelfOrAlternate(WindowCursor windowCursor, AnyObjectId anyObjectId, Set set) {
        ObjectLoader objectLoader = this.openLooseObject(windowCursor, anyObjectId);
        if (objectLoader != null) {
            return objectLoader;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || (objectLoader = objectDirectory$AlternateHandle.db.openLooseFromSelfOrAlternate(windowCursor, anyObjectId, set)) == null) continue;
            return objectLoader;
        }
        return null;
    }

    ObjectLoader openPackedObject(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        return this.packed.open(windowCursor, anyObjectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        return this.loose.open(windowCursor, anyObjectId);
    }

    @Override
    long getObjectSize(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        long l2 = this.getObjectSizeWithoutRestoring(windowCursor, anyObjectId);
        if (0L > l2 && this.restoreFromSelfOrAlternate(anyObjectId, null)) {
            l2 = this.getObjectSizeWithoutRestoring(windowCursor, anyObjectId);
        }
        return l2;
    }

    private long getObjectSizeWithoutRestoring(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        long l2;
        if (this.loose.hasCached(anyObjectId) && 0L <= (l2 = this.loose.getSize(windowCursor, anyObjectId))) {
            return l2;
        }
        l2 = this.getPackedSizeFromSelfOrAlternate(windowCursor, anyObjectId, null);
        if (0L <= l2) {
            return l2;
        }
        return this.getLooseSizeFromSelfOrAlternate(windowCursor, anyObjectId, null);
    }

    private long getPackedSizeFromSelfOrAlternate(WindowCursor windowCursor, AnyObjectId anyObjectId, Set set) {
        long l2 = this.packed.getSize(windowCursor, anyObjectId);
        if (0L <= l2) {
            return l2;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || 0L > (l2 = objectDirectory$AlternateHandle.db.getPackedSizeFromSelfOrAlternate(windowCursor, anyObjectId, set))) continue;
            return l2;
        }
        return -1L;
    }

    private long getLooseSizeFromSelfOrAlternate(WindowCursor windowCursor, AnyObjectId anyObjectId, Set set) {
        long l2 = this.loose.getSize(windowCursor, anyObjectId);
        if (0L <= l2) {
            return l2;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || 0L > (l2 = objectDirectory$AlternateHandle.db.getLooseSizeFromSelfOrAlternate(windowCursor, anyObjectId, set))) continue;
            return l2;
        }
        return -1L;
    }

    @Override
    void selectObjectRepresentation(PackWriter packWriter, ObjectToPack objectToPack, WindowCursor windowCursor) {
        this.selectObjectRepresentation(packWriter, objectToPack, windowCursor, null);
    }

    private void selectObjectRepresentation(PackWriter packWriter, ObjectToPack objectToPack, WindowCursor windowCursor, Set set) {
        this.packed.selectRepresentation(packWriter, objectToPack, windowCursor);
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId())) continue;
            objectDirectory$AlternateHandle.db.selectObjectRepresentation(packWriter, objectToPack, windowCursor, set);
        }
    }

    private boolean restoreFromSelfOrAlternate(AnyObjectId anyObjectId, Set set) {
        if (this.restoreFromSelf(anyObjectId)) {
            return true;
        }
        set = this.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.myAlternates()) {
            if (set.contains(objectDirectory$AlternateHandle.getId()) || !objectDirectory$AlternateHandle.db.restoreFromSelfOrAlternate(anyObjectId, set)) continue;
            return true;
        }
        return false;
    }

    private boolean restoreFromSelf(AnyObjectId anyObjectId) {
        Pack pack = this.preserved.getPack(anyObjectId);
        if (pack == null) {
            return false;
        }
        PackFile packFile = new PackFile(pack.getPackFile());
        for (PackExt packExt : PackExt.values()) {
            if (PackExt.INDEX.equals((Object)packExt)) continue;
            this.restore(packFile.create(packExt));
        }
        this.restore(packFile.create(PackExt.INDEX));
        return true;
    }

    private boolean restore(PackFile packFile) {
        PackFile packFile2 = packFile.createForDirectory(this.packed.getDirectory());
        try {
            Files.createLink(packFile2.toPath(), packFile.toPath());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    FileObjectDatabase$InsertLooseObjectResult insertUnpackedObject(File file, ObjectId objectId, boolean bl2) {
        if (this.loose.hasCached(objectId)) {
            FileUtils.delete(file, 2);
            return FileObjectDatabase$InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (!bl2 && this.has(objectId)) {
            FileUtils.delete(file, 2);
            return FileObjectDatabase$InsertLooseObjectResult.EXISTS_PACKED;
        }
        return this.loose.insert(file, objectId);
    }

    @Override
    Config getConfig() {
        return this.config;
    }

    @Override
    FS getFS() {
        return this.fs;
    }

    /*
     * Exception decompiling
     */
    @Override
    Set getShallowCommits() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void closeAllPackHandles(File file) {
        if (file.exists()) {
            for (Pack pack : this.packed.getPacks()) {
                if (!file.getPath().equals(pack.getPackFile().getPath())) continue;
                pack.close();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectDirectory$AlternateHandle[] myAlternates() {
        ObjectDirectory$AlternateHandle[] objectDirectory$AlternateHandleArray = (ObjectDirectory$AlternateHandle[])this.alternates.get();
        if (objectDirectory$AlternateHandleArray == null) {
            AtomicReference atomicReference = this.alternates;
            synchronized (atomicReference) {
                objectDirectory$AlternateHandleArray = (ObjectDirectory$AlternateHandle[])this.alternates.get();
                if (objectDirectory$AlternateHandleArray == null) {
                    try {
                        objectDirectory$AlternateHandleArray = this.loadAlternates();
                    }
                    catch (IOException iOException) {
                        objectDirectory$AlternateHandleArray = new ObjectDirectory$AlternateHandle[]{};
                    }
                    this.alternates.set(objectDirectory$AlternateHandleArray);
                }
            }
        }
        return objectDirectory$AlternateHandleArray;
    }

    Set addMe(Set hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<ObjectDirectory$AlternateHandle$Id>();
        }
        hashSet.add(this.handle.getId());
        return hashSet;
    }

    private ObjectDirectory$AlternateHandle[] loadAlternates() {
        ArrayList<ObjectDirectory$AlternateHandle> arrayList = new ArrayList<ObjectDirectory$AlternateHandle>(4);
        try (BufferedReader bufferedReader = ObjectDirectory.open(this.alternatesFile);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(this.openAlternate(string));
            }
        }
        return arrayList.toArray(new ObjectDirectory$AlternateHandle[0]);
    }

    private static BufferedReader open(File file) {
        return Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
    }

    private ObjectDirectory$AlternateHandle openAlternate(String string) {
        File file = this.fs.resolve(this.objects, string);
        return this.openAlternate(file);
    }

    private ObjectDirectory$AlternateHandle openAlternate(File file) {
        File file2 = file.getParentFile();
        if (RepositoryCache$FileKey.isGitRepository(file2, this.fs)) {
            RepositoryCache$FileKey repositoryCache$FileKey = RepositoryCache$FileKey.exact(file2, this.fs);
            FileRepository fileRepository = (FileRepository)RepositoryCache.open(repositoryCache$FileKey);
            return new ObjectDirectory$AlternateRepository(fileRepository);
        }
        ObjectDirectory objectDirectory = new ObjectDirectory(this.config, file, null, this.fs, null);
        return new ObjectDirectory$AlternateHandle(objectDirectory);
    }

    @Override
    public File fileFor(AnyObjectId anyObjectId) {
        return this.loose.fileFor(anyObjectId);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    CachedObjectDirectory newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    ObjectDirectory$AlternateHandle$Id getAlternateId() {
        return new ObjectDirectory$AlternateHandle$Id(this.objects);
    }
}

