/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase$InsertLooseObjectResult;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.internal.storage.file.UnpackedObjectCache;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LooseObjects {
    private static final Logger LOG = LoggerFactory.getLogger(LooseObjects.class);
    private static final int MAX_LOOSE_OBJECT_STALE_READ_ATTEMPTS = 5;
    private final File directory;
    private final UnpackedObjectCache unpackedObjectCache;

    LooseObjects(File file) {
        this.directory = file;
        this.unpackedObjectCache = new UnpackedObjectCache();
    }

    File getDirectory() {
        return this.directory;
    }

    void create() {
        FileUtils.mkdirs(this.directory);
    }

    void close() {
        this.unpackedObjectCache().clear();
    }

    public String toString() {
        return "LooseObjects[" + this.directory + "]";
    }

    boolean hasCached(AnyObjectId anyObjectId) {
        return this.unpackedObjectCache().isUnpacked(anyObjectId);
    }

    boolean has(AnyObjectId anyObjectId) {
        return this.fileFor(anyObjectId).exists();
    }

    boolean resolve(Set set, AbbreviatedObjectId abbreviatedObjectId, int n2) {
        String string = abbreviatedObjectId.name().substring(0, 2);
        String[] stringArray = new File(this.directory, string).list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                block4: {
                    if (string2.length() != 38) continue;
                    try {
                        ObjectId objectId = ObjectId.fromString(string + string2);
                        if (abbreviatedObjectId.prefixCompare(objectId) != 0) break block4;
                        set.add(objectId);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                }
                if (set.size() <= n2) continue;
                return false;
            }
        }
        return true;
    }

    ObjectLoader open(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        for (int i2 = 0; i2 < 5; ++i2) {
            File file = this.fileFor(anyObjectId);
            try {
                return this.getObjectLoader(windowCursor, file, anyObjectId);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!file.exists()) break;
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                if (FileUtils.isStaleFileHandleInCausalChain(iOException)) continue;
                throw iOException;
            }
        }
        this.unpackedObjectCache().remove(anyObjectId);
        return null;
    }

    ObjectLoader getObjectLoader(WindowCursor windowCursor, File file, AnyObjectId anyObjectId) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.unpackedObjectCache().add(anyObjectId);
            ObjectLoader objectLoader = UnpackedObject.open(fileInputStream, file, anyObjectId, windowCursor);
            return objectLoader;
        }
    }

    UnpackedObjectCache unpackedObjectCache() {
        return this.unpackedObjectCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getSize(WindowCursor windowCursor, AnyObjectId anyObjectId) {
        File file = this.fileFor(anyObjectId);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.unpackedObjectCache().add(anyObjectId);
            long l2 = UnpackedObject.getSize(fileInputStream, anyObjectId, windowCursor);
            return l2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file.exists()) {
                throw fileNotFoundException;
            }
            this.unpackedObjectCache().remove(anyObjectId);
            return -1L;
        }
    }

    FileObjectDatabase$InsertLooseObjectResult insert(File file, ObjectId objectId) {
        File file2 = this.fileFor(objectId);
        if (file2.exists()) {
            FileUtils.delete(file, 2);
            return FileObjectDatabase$InsertLooseObjectResult.EXISTS_LOOSE;
        }
        try {
            return this.tryMove(file, file2, objectId);
        }
        catch (NoSuchFileException noSuchFileException) {
            FileUtils.mkdir(file2.getParentFile(), true);
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            FileUtils.delete(file, 2);
            return FileObjectDatabase$InsertLooseObjectResult.FAILURE;
        }
        try {
            return this.tryMove(file, file2, objectId);
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            FileUtils.delete(file, 2);
            return FileObjectDatabase$InsertLooseObjectResult.FAILURE;
        }
    }

    private FileObjectDatabase$InsertLooseObjectResult tryMove(File file, File file2, ObjectId objectId) {
        Files.move(FileUtils.toPath(file), FileUtils.toPath(file2), StandardCopyOption.ATOMIC_MOVE);
        file2.setReadOnly();
        this.unpackedObjectCache().add(objectId);
        return FileObjectDatabase$InsertLooseObjectResult.INSERTED;
    }

    File fileFor(AnyObjectId anyObjectId) {
        String string = anyObjectId.name();
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2);
        return new File(new File(this.getDirectory(), string2), string3);
    }
}

