/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile$1;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$LockToken;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFile {
    private static final Logger LOG = LoggerFactory.getLogger(LockFile.class);
    static final FilenameFilter FILTER = (file, string) -> !string.endsWith(".lock");
    private final File ref;
    private final FS fs;
    private final File lck;
    private boolean haveLck;
    private FileOutputStream os;
    private boolean needSnapshot;
    private boolean fsync;
    private boolean isAppend;
    private boolean written;
    private boolean snapshotNoConfig;
    private FileSnapshot commitSnapshot;
    private FS$LockToken token;

    public static boolean unlock(File file) {
        File file2 = LockFile.getLockFile(file);
        int n2 = 6;
        try {
            FileUtils.delete(file2, 6);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !file2.exists();
    }

    static File getLockFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".lock");
    }

    public LockFile(File file, FS fS) {
        this.ref = file;
        this.lck = LockFile.getLockFile(this.ref);
        this.fs = fS;
    }

    public LockFile(File file) {
        this.ref = file;
        this.lck = LockFile.getLockFile(this.ref);
        this.fs = FS.DETECTED;
    }

    public boolean lock() {
        if (this.haveLck) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockAlreadyHeld, this.ref));
        }
        FileUtils.mkdirs(this.lck.getParentFile(), true);
        try {
            this.token = this.fs.createNewFileAtomic(this.lck);
        }
        catch (IOException iOException) {
            LOG.error(JGitText.get().failedCreateLockFile, (Object)this.lck, (Object)iOException);
            throw iOException;
        }
        boolean bl2 = this.token.isCreated();
        if (bl2) {
            this.haveLck = true;
            this.isAppend = false;
            this.written = false;
        } else {
            this.closeToken();
        }
        return bl2;
    }

    public boolean lockForAppend() {
        if (!this.lock()) {
            return false;
        }
        this.copyCurrentContent();
        this.isAppend = true;
        this.written = false;
        return true;
    }

    boolean isLocked() {
        return this.haveLck;
    }

    private FileOutputStream getStream() {
        return new FileOutputStream(this.lck, this.isAppend);
    }

    public void copyCurrentContent() {
        this.requireLock();
        try (FileOutputStream fileOutputStream = this.getStream();){
            try (FileInputStream fileInputStream = new FileInputStream(this.ref);){
                Object object;
                if (this.fsync) {
                    long l2;
                    object = fileInputStream.getChannel();
                    long l3 = 0L;
                    for (long i2 = ((FileChannel)object).size(); 0L < i2; i2 -= l2) {
                        l2 = fileOutputStream.getChannel().transferFrom((ReadableByteChannel)object, l3, i2);
                        l3 += l2;
                    }
                } else {
                    int n2;
                    object = new byte[2048];
                    while ((n2 = fileInputStream.read((byte[])object)) >= 0) {
                        fileOutputStream.write((byte[])object, 0, n2);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.ref.exists()) {
                    throw fileNotFoundException;
                }
            }
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.unlock();
            throw throwable;
        }
    }

    public void write(ObjectId objectId) {
        byte[] byArray = new byte[41];
        objectId.copyTo(byArray, 0);
        byArray[40] = 10;
        this.write(byArray);
    }

    public void write(byte[] byArray) {
        this.requireLock();
        try (FileOutputStream fileOutputStream = this.getStream();){
            if (this.written) {
                throw new IOException(MessageFormat.format(JGitText.get().lockStreamClosed, this.ref));
            }
            if (this.fsync) {
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                while (0 < byteBuffer.remaining()) {
                    fileChannel.write(byteBuffer);
                }
                fileChannel.force(true);
            } else {
                fileOutputStream.write(byArray);
            }
            this.written = true;
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.unlock();
            throw throwable;
        }
    }

    public OutputStream getOutputStream() {
        this.requireLock();
        if (this.written || this.os != null) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockStreamMultiple, this.ref));
        }
        return new LockFile$1(this);
    }

    void requireLock() {
        if (!this.haveLck) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotHeld, this.ref));
        }
    }

    public void setNeedStatInformation(boolean bl2) {
        this.setNeedSnapshot(bl2);
    }

    public void setNeedSnapshot(boolean bl2) {
        this.needSnapshot = bl2;
    }

    public void setNeedSnapshotNoConfig(boolean bl2) {
        this.needSnapshot = bl2;
        this.snapshotNoConfig = bl2;
    }

    public void setFSync(boolean bl2) {
        this.fsync = bl2;
    }

    public void waitForStatChange() {
        FileSnapshot fileSnapshot = FileSnapshot.save(this.ref, this.fs);
        FileSnapshot fileSnapshot2 = FileSnapshot.save(this.lck, this.fs);
        long l2 = FS.getFileStoreAttributes(this.lck.toPath(), this.fs).getFsTimestampResolution().toNanos();
        while (fileSnapshot.equals(fileSnapshot2)) {
            TimeUnit.NANOSECONDS.sleep(l2);
            try {
                Files.setLastModifiedTime(this.lck.toPath(), FileTime.from(Instant.now()));
            }
            catch (IOException iOException) {
                fileSnapshot2.waitUntilNotRacy();
            }
            fileSnapshot2 = FileSnapshot.save(this.lck, this.fs);
        }
    }

    public boolean commit() {
        if (this.os != null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotClosed, this.ref));
        }
        this.saveStatInformation();
        try {
            FileUtils.rename(this.lck, this.ref, StandardCopyOption.ATOMIC_MOVE);
            this.haveLck = false;
            this.isAppend = false;
            this.written = false;
            this.closeToken();
            return true;
        }
        catch (IOException iOException) {
            this.unlock();
            return false;
        }
    }

    private void closeToken() {
        if (this.token != null) {
            this.token.close();
            this.token = null;
        }
    }

    private void saveStatInformation() {
        if (this.needSnapshot) {
            this.commitSnapshot = this.snapshotNoConfig ? FileSnapshot.saveNoConfig(this.lck, this.fs) : FileSnapshot.save(this.lck, this.fs);
        }
    }

    @Deprecated
    public long getCommitLastModified() {
        return this.commitSnapshot.lastModified();
    }

    public Instant getCommitLastModifiedInstant() {
        return this.commitSnapshot.lastModifiedInstant();
    }

    public FileSnapshot getCommitSnapshot() {
        return this.commitSnapshot;
    }

    public void createCommitSnapshot() {
        this.saveStatInformation();
    }

    public void unlock() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                LOG.error(MessageFormat.format(JGitText.get().unlockLockFileFailed, this.lck), (Throwable)iOException);
            }
            this.os = null;
        }
        if (this.haveLck) {
            this.haveLck = false;
            try {
                FileUtils.delete(this.lck, 2);
            }
            catch (IOException iOException) {
                LOG.error(MessageFormat.format(JGitText.get().unlockLockFileFailed, this.lck), (Throwable)iOException);
            }
            finally {
                this.closeToken();
            }
        }
        this.isAppend = false;
        this.written = false;
    }

    public String toString() {
        return "LockFile[" + this.lck + ", haveLck=" + this.haveLck + "]";
    }

    static /* synthetic */ boolean access$000(LockFile lockFile) {
        return lockFile.written;
    }

    static /* synthetic */ File access$100(LockFile lockFile) {
        return lockFile.ref;
    }

    static /* synthetic */ FileOutputStream access$202(LockFile lockFile, FileOutputStream fileOutputStream) {
        lockFile.os = fileOutputStream;
        return lockFile.os;
    }

    static /* synthetic */ FileOutputStream access$300(LockFile lockFile) {
        return lockFile.getStream();
    }

    static /* synthetic */ boolean access$400(LockFile lockFile) {
        return lockFile.fsync;
    }

    static /* synthetic */ FileOutputStream access$200(LockFile lockFile) {
        return lockFile.os;
    }

    static /* synthetic */ boolean access$002(LockFile lockFile, boolean bl2) {
        lockFile.written = bl2;
        return lockFile.written;
    }
}

