/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;

class LocalCachedPack
extends CachedPack {
    private final ObjectDirectory odb;
    private final String[] packNames;
    private Pack[] packs;

    LocalCachedPack(ObjectDirectory objectDirectory, List list) {
        this.odb = objectDirectory;
        this.packNames = list.toArray(new String[0]);
    }

    LocalCachedPack(List list) {
        this.odb = null;
        this.packNames = null;
        this.packs = list.toArray(new Pack[0]);
    }

    @Override
    public long getObjectCount() {
        long l2 = 0L;
        for (Pack pack : this.getPacks()) {
            l2 += pack.getObjectCount();
        }
        return l2;
    }

    void copyAsIs(PackOutputStream packOutputStream, WindowCursor windowCursor) {
        for (Pack pack : this.getPacks()) {
            pack.copyPackAsIs(packOutputStream, windowCursor);
        }
    }

    @Override
    public boolean hasObject(ObjectToPack objectToPack, StoredObjectRepresentation storedObjectRepresentation) {
        try {
            LocalObjectRepresentation localObjectRepresentation = (LocalObjectRepresentation)storedObjectRepresentation;
            for (Pack pack : this.getPacks()) {
                if (localObjectRepresentation.pack != pack) continue;
                return true;
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    private Pack[] getPacks() {
        if (this.packs == null) {
            Pack[] packArray = new Pack[this.packNames.length];
            for (int i2 = 0; i2 < this.packNames.length; ++i2) {
                packArray[i2] = this.getPackFile(this.packNames[i2]);
            }
            this.packs = packArray;
        }
        return this.packs;
    }

    private Pack getPackFile(String string) {
        for (Pack pack : this.odb.getPacks()) {
            if (!string.equals(pack.getPackName())) continue;
            return pack;
        }
        throw new FileNotFoundException(this.getPackFilePath(string));
    }

    private String getPackFilePath(String string) {
        File file = this.odb.getPackDirectory();
        return new PackFile(file, string, PackExt.PACK).getPath();
    }
}

