/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.internal.storage.file.LazyObjectIdSetFile$Entry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectIdSet;

public class LazyObjectIdSetFile
implements ObjectIdSet {
    private final File src;
    private ObjectIdOwnerMap set;

    public LazyObjectIdSetFile(File file) {
        this.src = file;
    }

    @Override
    public boolean contains(AnyObjectId anyObjectId) {
        if (this.set == null) {
            this.set = this.load();
        }
        return this.set.contains(anyObjectId);
    }

    private ObjectIdOwnerMap load() {
        ObjectIdOwnerMap objectIdOwnerMap = new ObjectIdOwnerMap();
        try (FileInputStream fileInputStream = new FileInputStream(this.src);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            MutableObjectId mutableObjectId = new MutableObjectId();
            while ((string = bufferedReader.readLine()) != null) {
                mutableObjectId.fromString(string);
                if (objectIdOwnerMap.contains(mutableObjectId)) continue;
                objectIdOwnerMap.add(new LazyObjectIdSetFile$Entry(mutableObjectId));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return objectIdOwnerMap;
    }
}

