/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackInputStream;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ObjectStream$Filter;

class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final Pack pack;
    private final FileObjectDatabase db;

    LargePackedWholeObject(int n2, long l2, long l3, int n3, Pack pack, FileObjectDatabase fileObjectDatabase) {
        this.type = n2;
        this.size = l2;
        this.objectOffset = l3;
        this.headerLength = n3;
        this.pack = pack;
        this.db = fileObjectDatabase;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() {
        try {
            throw new LargeObjectException(this.getObjectId());
        }
        catch (IOException iOException) {
            throw new LargeObjectException(iOException);
        }
    }

    @Override
    public ObjectStream openStream() {
        InputStream inputStream;
        WindowCursor windowCursor = new WindowCursor(this.db);
        try {
            inputStream = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, windowCursor);
        }
        catch (IOException iOException) {
            return windowCursor.open(this.getObjectId(), this.type).openStream();
        }
        inputStream = new BufferedInputStream(new InflaterInputStream(inputStream, windowCursor.inflater(), 8192), 8192);
        return new ObjectStream$Filter(this.type, this.size, inputStream);
    }

    private ObjectId getObjectId() {
        return this.pack.findObjectForOffset(this.objectOffset);
    }
}

