/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;

final class InflatingBitSet {
    private static final long[] EMPTY = new long[0];
    private final EWAHCompressedBitmap bitmap;
    private IntIterator iterator;
    private long[] inflated;
    private int nextPosition = -1;
    private final int sizeInBits;

    InflatingBitSet(EWAHCompressedBitmap eWAHCompressedBitmap) {
        this(eWAHCompressedBitmap, EMPTY);
    }

    private InflatingBitSet(EWAHCompressedBitmap eWAHCompressedBitmap, long[] lArray) {
        this.bitmap = eWAHCompressedBitmap;
        this.inflated = lArray;
        this.sizeInBits = this.bitmap.sizeInBits();
    }

    final boolean maybeContains(int n2) {
        if (this.get(n2)) {
            return true;
        }
        return this.nextPosition <= n2 && n2 < this.sizeInBits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean contains(int n2) {
        if (this.get(n2)) {
            return true;
        }
        if (n2 <= this.nextPosition || n2 >= this.sizeInBits) {
            if (n2 != this.nextPosition) return false;
            return true;
        }
        if (this.iterator == null) {
            this.iterator = this.bitmap.intIterator();
            if (!this.iterator.hasNext()) return false;
            this.nextPosition = this.iterator.next();
        } else if (!this.iterator.hasNext()) {
            return false;
        }
        int n3 = InflatingBitSet.block(n2);
        if (n3 >= this.inflated.length) {
            long[] lArray = new long[InflatingBitSet.block(this.sizeInBits) + 1];
            System.arraycopy(this.inflated, 0, lArray, 0, this.inflated.length);
            this.inflated = lArray;
        }
        int n4 = InflatingBitSet.block(this.nextPosition);
        long l2 = InflatingBitSet.mask(this.nextPosition);
        int n5 = Math.max(this.nextPosition, n2) | 0x3F;
        while (this.iterator.hasNext()) {
            this.nextPosition = this.iterator.next();
            if (n5 < this.nextPosition) break;
            int n6 = InflatingBitSet.block(this.nextPosition);
            long l3 = InflatingBitSet.mask(this.nextPosition);
            if (n4 == n6) {
                l2 |= l3;
                continue;
            }
            this.inflated[n4] = l2;
            n4 = n6;
            l2 = l3;
        }
        this.inflated[n4] = l2;
        if (n4 != n3) return false;
        if ((l2 & InflatingBitSet.mask(n2)) == 0L) return false;
        return true;
    }

    private final boolean get(int n2) {
        int n3 = InflatingBitSet.block(n2);
        return n3 < this.inflated.length && (this.inflated[n3] & InflatingBitSet.mask(n2)) != 0L;
    }

    private static final int block(int n2) {
        return n2 >> 6;
    }

    private static final long mask(int n2) {
        return 1L << n2;
    }

    private final boolean isEmpty() {
        return this.sizeInBits == 0;
    }

    final InflatingBitSet or(EWAHCompressedBitmap eWAHCompressedBitmap) {
        if (eWAHCompressedBitmap.sizeInBits() == 0) {
            return this;
        }
        return new InflatingBitSet(this.bitmap.or(eWAHCompressedBitmap), this.inflated);
    }

    final InflatingBitSet andNot(EWAHCompressedBitmap eWAHCompressedBitmap) {
        if (this.isEmpty()) {
            return this;
        }
        return new InflatingBitSet(this.bitmap.andNot(eWAHCompressedBitmap));
    }

    final InflatingBitSet xor(EWAHCompressedBitmap eWAHCompressedBitmap) {
        if (this.isEmpty()) {
            if (eWAHCompressedBitmap.sizeInBits() == 0) {
                return this;
            }
            return new InflatingBitSet(eWAHCompressedBitmap);
        }
        return new InflatingBitSet(this.bitmap.xor(eWAHCompressedBitmap));
    }

    final EWAHCompressedBitmap getBitmap() {
        return this.bitmap;
    }
}

