/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.time.Instant;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;

class GcLog {
    private final FileRepository repo;
    private final File logFile;
    private final LockFile lock;
    private Instant gcLogExpire;
    private static final String LOG_EXPIRY_DEFAULT = "1.day.ago";
    private boolean nonEmpty = false;

    GcLog(FileRepository fileRepository) {
        this.repo = fileRepository;
        this.logFile = new File(fileRepository.getDirectory(), "gc.log");
        this.lock = new LockFile(this.logFile, fileRepository.getFS());
    }

    private Instant getLogExpiry() {
        if (this.gcLogExpire == null) {
            String string = this.repo.getConfig().getString("gc", null, "logExpiry");
            if (string == null) {
                string = LOG_EXPIRY_DEFAULT;
            }
            this.gcLogExpire = GitDateParser.parse(string, null, SystemReader.getInstance().getLocale()).toInstant();
        }
        return this.gcLogExpire;
    }

    private boolean autoGcBlockedByOldLockFile() {
        try {
            FileTime fileTime = Files.getLastModifiedTime(FileUtils.toPath(this.logFile), new LinkOption[0]);
            if (fileTime.toInstant().compareTo(this.getLogExpiry()) > 0) {
                return true;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException | ParseException exception) {
            throw new JGitInternalException(exception.getMessage(), exception);
        }
        return false;
    }

    boolean lock() {
        try {
            if (!this.lock.lock()) {
                return false;
            }
        }
        catch (IOException iOException) {
            throw new JGitInternalException(iOException.getMessage(), iOException);
        }
        if (this.autoGcBlockedByOldLockFile()) {
            this.lock.unlock();
            return false;
        }
        return true;
    }

    void unlock() {
        this.lock.unlock();
    }

    boolean commit() {
        if (this.nonEmpty) {
            return this.lock.commit();
        }
        this.logFile.delete();
        this.lock.unlock();
        return true;
    }

    void write(String string) {
        if (string.length() > 0) {
            this.nonEmpty = true;
        }
        this.lock.write(string.getBytes(StandardCharsets.UTF_8));
    }
}

