/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CancelledException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC$PidLock;
import org.eclipse.jgit.internal.storage.file.GC$RepoStatistics;
import org.eclipse.jgit.internal.storage.file.GcLog;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex$MutableEntry;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GC {
    private static final Logger LOG = LoggerFactory.getLogger(GC.class);
    private static final String PRUNE_EXPIRE_DEFAULT = "2.weeks.ago";
    private static final String PRUNE_PACK_EXPIRE_DEFAULT = "1.hour.ago";
    private static final Pattern PATTERN_LOOSE_OBJECT = Pattern.compile("[0-9a-fA-F]{38}");
    private static final String PACK_EXT = "." + PackExt.PACK.getExtension();
    private static final String BITMAP_EXT = "." + PackExt.BITMAP_INDEX.getExtension();
    private static final String INDEX_EXT = "." + PackExt.INDEX.getExtension();
    private static final String KEEP_EXT = "." + PackExt.KEEP.getExtension();
    private static final int DEFAULT_AUTOPACKLIMIT = 50;
    private static final int DEFAULT_AUTOLIMIT = 6700;
    private static volatile ExecutorService executor;
    private final FileRepository repo;
    private ProgressMonitor pm;
    private long expireAgeMillis = -1L;
    private Date expire;
    private long packExpireAgeMillis = -1L;
    private Date packExpire;
    private Boolean packKeptObjects;
    private PackConfig pconfig;
    private Collection lastPackedRefs;
    private long lastRepackTime;
    private boolean automatic;
    private boolean background;

    public static void setExecutor(ExecutorService executorService) {
        executor = executorService;
    }

    public GC(FileRepository fileRepository) {
        this.repo = fileRepository;
        this.pconfig = new PackConfig(fileRepository);
        this.pm = NullProgressMonitor.INSTANCE;
    }

    public Collection gc() {
        if (!this.background) {
            return this.doGc();
        }
        GcLog gcLog = new GcLog(this.repo);
        if (!gcLog.lock()) {
            return Collections.emptyList();
        }
        Callable<Collection> callable = () -> {
            try {
                Object object;
                Collection collection = this.doGc();
                if (this.automatic && this.tooManyLooseObjects()) {
                    object = JGitText.get().gcTooManyUnpruned;
                    gcLog.write((String)object);
                    gcLog.commit();
                }
                object = collection;
                return object;
            }
            catch (IOException | ParseException exception) {
                try {
                    gcLog.write(exception.getMessage());
                    StringWriter stringWriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringWriter));
                    gcLog.write(stringWriter.toString());
                    gcLog.commit();
                }
                catch (IOException iOException) {
                    iOException.addSuppressed(exception);
                    LOG.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            finally {
                gcLog.unlock();
            }
            return Collections.emptyList();
        };
        this.executor().submit(callable);
        return Collections.emptyList();
    }

    private ExecutorService executor() {
        return executor != null ? executor : WorkQueue.getExecutor();
    }

    private Collection doGc() {
        if (this.automatic && !this.needGc()) {
            return Collections.emptyList();
        }
        try (GC$PidLock gC$PidLock = new GC$PidLock(this);){
            if (!gC$PidLock.lock()) {
                List list = Collections.emptyList();
                return list;
            }
            this.pm.start(6);
            this.packRefs();
            Collection collection = this.repack();
            this.prune(Collections.emptySet());
            Collection collection2 = collection;
            return collection2;
        }
    }

    private void loosen(ObjectDirectoryInserter objectDirectoryInserter, ObjectReader objectReader, Pack pack, HashSet hashSet) {
        for (PackIndex$MutableEntry packIndex$MutableEntry : pack) {
            ObjectId objectId = packIndex$MutableEntry.toObjectId();
            if (hashSet.contains(objectId)) continue;
            hashSet.add(objectId);
            ObjectLoader objectLoader = objectReader.open(objectId);
            objectDirectoryInserter.insert(objectLoader.getType(), objectLoader.getSize(), objectLoader.openStream(), true);
        }
    }

    private void deleteOldPacks(Collection collection, Collection collection2) {
        Object object;
        Object object22;
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        for (Object object22 : collection2) {
            object = ((Pack)object22).iterator();
            while (object.hasNext()) {
                PackIndex$MutableEntry packIndex$MutableEntry = (PackIndex$MutableEntry)object.next();
                hashSet.add(packIndex$MutableEntry.toObjectId());
            }
        }
        ObjectReader objectReader = this.repo.newObjectReader();
        object22 = this.repo.getObjectDatabase();
        object = ((ObjectDirectory)object22).newInserter();
        boolean bl2 = !"now".equals(this.getPruneExpireStr()) && this.getExpireDate() < Long.MAX_VALUE;
        this.prunePreserved();
        long l2 = this.getPackExpireDate();
        ArrayList<PackFile> arrayList = new ArrayList<PackFile>();
        block2: for (Pack pack : collection) {
            this.checkCancelled();
            String string = pack.getPackName();
            for (Pack pack2 : collection2) {
                if (!string.equals(pack2.getPackName())) continue;
                continue block2;
            }
            if (pack.shouldBeKept() || this.repo.getFS().lastModifiedInstant(pack.getPackFile()).toEpochMilli() >= l2) continue;
            if (bl2) {
                this.loosen((ObjectDirectoryInserter)object, objectReader, pack, hashSet);
            }
            pack.close();
            arrayList.add(pack.getPackFile());
        }
        arrayList.forEach(this::prunePack);
        this.repo.getObjectDatabase().close();
    }

    private void removeOldPack(PackFile packFile, int n2) {
        if (this.pconfig.isPreserveOldPacks()) {
            File file = this.repo.getObjectDatabase().getPreservedDirectory();
            FileUtils.mkdir(file, true);
            PackFile packFile2 = packFile.createPreservedForDirectory(file);
            FileUtils.rename(packFile, packFile2);
        } else {
            FileUtils.delete(packFile, n2);
        }
    }

    private void prunePreserved() {
        if (this.pconfig.isPrunePreserved()) {
            try {
                FileUtils.delete(this.repo.getObjectDatabase().getPreservedDirectory(), 7);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void prunePack(PackFile packFile) {
        try {
            int n2 = 6;
            this.removeOldPack(packFile.create(PackExt.PACK), n2);
            n2 |= 8;
            for (PackExt packExt : PackExt.values()) {
                if (PackExt.PACK.equals((Object)packExt)) continue;
                this.removeOldPack(packFile.create(packExt), n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePacked() {
        ObjectDirectory objectDirectory = this.repo.getObjectDatabase();
        Collection collection = objectDirectory.getPacks();
        File file = this.repo.getObjectsDirectory();
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            this.pm.beginTask(JGitText.get().pruneLoosePackedObjects, stringArray.length);
            try {
                for (String string : stringArray) {
                    String[] stringArray2;
                    this.checkCancelled();
                    this.pm.update(1);
                    if (string.length() != 2 || (stringArray2 = new File(file, string).list()) == null) continue;
                    for (String string2 : stringArray2) {
                        ObjectId objectId;
                        this.checkCancelled();
                        if (string2.length() != 38) continue;
                        try {
                            objectId = ObjectId.fromString(string + string2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                        boolean bl2 = false;
                        for (Pack pack : collection) {
                            this.checkCancelled();
                            if (!pack.hasObject(objectId)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                        FileUtils.delete(objectDirectory.fileFor(objectId), 14);
                    }
                }
            }
            finally {
                this.pm.endTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Set set) {
        Object object;
        Object object22;
        long l2 = this.getExpireDate();
        HashMap<ObjectId, File> hashMap = new HashMap<ObjectId, File>();
        Set set2 = null;
        File file = this.repo.getObjectsDirectory();
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.pm.beginTask(JGitText.get().pruneLooseUnreferencedObjects, stringArray.length);
        try {
            for (String object32 : stringArray) {
                this.checkCancelled();
                this.pm.update(1);
                if (object32.length() != 2) continue;
                object22 = new File(file, object32);
                Object object3 = ((File)object22).listFiles();
                if (object3 == null || ((File[])object3).length == 0) {
                    FileUtils.delete((File)object22, 8);
                    continue;
                }
                for (File file2 : object3) {
                    this.checkCancelled();
                    String string = file2.getName();
                    if (string.length() != 38 || this.repo.getFS().lastModifiedInstant(file2).toEpochMilli() >= l2) continue;
                    try {
                        ObjectId objectId = ObjectId.fromString(object32 + string);
                        if (set.contains(objectId)) continue;
                        if (set2 == null) {
                            set2 = this.listNonHEADIndexObjects();
                        }
                        if (set2.contains(objectId)) continue;
                        hashMap.put(objectId, file2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.pm.endTask();
        }
        if (hashMap.isEmpty()) {
            return;
        }
        this.checkCancelled();
        if (this.lastPackedRefs == null || this.lastPackedRefs.isEmpty()) {
            object = this.getAllRefs();
        } else {
            HashMap<String, Ref> hashMap2 = new HashMap<String, Ref>();
            for (Ref ref : this.lastPackedRefs) {
                hashMap2.put(ref.getName(), ref);
            }
            object = new ArrayList();
            for (Ref ref : this.getAllRefs()) {
                if (GC.equals(ref, (Ref)(object22 = (Ref)hashMap2.get(ref.getName())))) continue;
                object.add(ref);
            }
        }
        if (!object.isEmpty()) {
            ObjectWalk objectWalk = new ObjectWalk(this.repo);
            try {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Ref ref = (Ref)iterator.next();
                    this.checkCancelled();
                    objectWalk.markStart(objectWalk.parseAny(ref.getObjectId()));
                }
                if (this.lastPackedRefs != null) {
                    for (Ref ref : this.lastPackedRefs) {
                        objectWalk.markUninteresting(objectWalk.parseAny(ref.getObjectId()));
                    }
                }
                this.removeReferenced(hashMap, objectWalk);
            }
            finally {
                objectWalk.dispose();
            }
        }
        if (hashMap.isEmpty()) {
            return;
        }
        ObjectWalk objectWalk = new ObjectWalk(this.repo);
        try {
            for (Ref ref : this.getAllRefs()) {
                for (Object object3 : this.listRefLogObjects(ref, this.lastRepackTime)) {
                    this.checkCancelled();
                    objectWalk.markStart(objectWalk.parseAny((AnyObjectId)object3));
                }
            }
            if (this.lastPackedRefs != null) {
                for (Ref ref : this.lastPackedRefs) {
                    this.checkCancelled();
                    objectWalk.markUninteresting(objectWalk.parseAny(ref.getObjectId()));
                }
            }
            this.removeReferenced(hashMap, objectWalk);
        }
        finally {
            objectWalk.dispose();
        }
        if (hashMap.isEmpty()) {
            return;
        }
        this.checkCancelled();
        HashSet hashSet = new HashSet();
        for (Object object22 : hashMap.values()) {
            if (((File)object22).lastModified() >= l2) continue;
            ((File)object22).delete();
            hashSet.add(((File)object22).getParentFile());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object22 = (File)iterator.next();
            FileUtils.delete((File)object22, 24);
        }
        this.repo.getObjectDatabase().close();
    }

    private long getExpireDate() {
        long l2 = Long.MAX_VALUE;
        if (this.expire == null && this.expireAgeMillis == -1L) {
            String string = this.getPruneExpireStr();
            if (string == null) {
                string = PRUNE_EXPIRE_DEFAULT;
            }
            this.expire = GitDateParser.parse(string, null, SystemReader.getInstance().getLocale());
            this.expireAgeMillis = -1L;
        }
        if (this.expire != null) {
            l2 = this.expire.getTime();
        }
        if (this.expireAgeMillis != -1L) {
            l2 = System.currentTimeMillis() - this.expireAgeMillis;
        }
        return l2;
    }

    private String getPruneExpireStr() {
        return this.repo.getConfig().getString("gc", null, "pruneexpire");
    }

    private long getPackExpireDate() {
        long l2 = Long.MAX_VALUE;
        if (this.packExpire == null && this.packExpireAgeMillis == -1L) {
            String string = this.repo.getConfig().getString("gc", null, "prunepackexpire");
            if (string == null) {
                string = PRUNE_PACK_EXPIRE_DEFAULT;
            }
            this.packExpire = GitDateParser.parse(string, null, SystemReader.getInstance().getLocale());
            this.packExpireAgeMillis = -1L;
        }
        if (this.packExpire != null) {
            l2 = this.packExpire.getTime();
        }
        if (this.packExpireAgeMillis != -1L) {
            l2 = System.currentTimeMillis() - this.packExpireAgeMillis;
        }
        return l2;
    }

    private void removeReferenced(Map map, ObjectWalk objectWalk) {
        RevObject revObject = objectWalk.next();
        while (revObject != null) {
            this.checkCancelled();
            if (map.remove(revObject.getId()) != null && map.isEmpty()) {
                return;
            }
            revObject = objectWalk.next();
        }
        revObject = objectWalk.nextObject();
        while (revObject != null) {
            this.checkCancelled();
            if (map.remove(revObject.getId()) != null && map.isEmpty()) {
                return;
            }
            revObject = objectWalk.nextObject();
        }
    }

    private static boolean equals(Ref ref, Ref ref2) {
        if (ref == null || ref2 == null) {
            return false;
        }
        if (ref.isSymbolic()) {
            return ref2.isSymbolic() && ref.getTarget().getName().equals(ref2.getTarget().getName());
        }
        return !ref2.isSymbolic() && Objects.equals(ref.getObjectId(), ref2.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packRefs() {
        RefDatabase refDatabase = this.repo.getRefDatabase();
        if (refDatabase instanceof FileReftableDatabase) {
            this.pm.beginTask(JGitText.get().packRefs, 1);
            try {
                ((FileReftableDatabase)refDatabase).compactFully();
            }
            finally {
                this.pm.endTask();
            }
            return;
        }
        List list = refDatabase.getRefsByPrefix("refs/");
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        this.pm.beginTask(JGitText.get().packRefs, list.size());
        try {
            for (Ref ref : list) {
                this.checkCancelled();
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    arrayList.add(ref.getName());
                }
                this.pm.update(1);
            }
            ((RefDirectory)this.repo.getRefDatabase()).pack(arrayList);
        }
        finally {
            this.pm.endTask();
        }
    }

    public Collection repack() {
        Pack pack;
        Pack pack22;
        ArrayList<Pack> arrayList2;
        Collection collection = this.repo.getObjectDatabase().getPacks();
        long l2 = System.currentTimeMillis();
        Collection collection2 = this.getAllRefs();
        HashSet hashSet = new HashSet();
        HashSet<ObjectId> hashSet2 = new HashSet<ObjectId>();
        HashSet<ObjectId> hashSet3 = new HashSet<ObjectId>();
        HashSet<ObjectId> hashSet4 = new HashSet<ObjectId>();
        HashSet hashSet5 = new HashSet();
        HashSet<ObjectId> hashSet6 = new HashSet<ObjectId>();
        Set set = this.listNonHEADIndexObjects();
        Set set2 = this.repo.getRefDatabase().getRefsByPrefix(this.pconfig.getBitmapExcludedRefsPrefixes()).stream().map(Ref::getObjectId).collect(Collectors.toSet());
        for (ArrayList<Pack> arrayList2 : collection2) {
            this.checkCancelled();
            hashSet4.addAll(this.listRefLogObjects((Ref)((Object)arrayList2), 0L));
            if (arrayList2.isSymbolic() || arrayList2.getObjectId() == null) continue;
            if (GC.isHead((Ref)((Object)arrayList2))) {
                hashSet2.add(arrayList2.getObjectId());
            } else if (GC.isTag((Ref)((Object)arrayList2))) {
                hashSet3.add(arrayList2.getObjectId());
            } else {
                hashSet4.add(arrayList2.getObjectId());
            }
            if (arrayList2.getPeeledObjectId() == null) continue;
            hashSet6.add(arrayList2.getPeeledObjectId());
        }
        LinkedList linkedList = new LinkedList();
        for (Pack pack22 : this.repo.getObjectDatabase().getPacks()) {
            this.checkCancelled();
            if (this.shouldPackKeptObjects() || !pack22.shouldBeKept()) continue;
            linkedList.add(pack22.getIndex());
        }
        hashSet3.removeAll(hashSet2);
        hashSet.addAll(hashSet2);
        hashSet.addAll(hashSet3);
        hashSet6.addAll(hashSet);
        hashSet4.addAll(set);
        if (this.pconfig.getSinglePack()) {
            hashSet.addAll(hashSet4);
            hashSet4.clear();
        }
        arrayList2 = new ArrayList<Pack>(2);
        pack22 = null;
        if (!hashSet.isEmpty() && (pack22 = this.writePack(hashSet, PackWriter.NONE, hashSet3, set2, hashSet6, linkedList, true)) != null) {
            arrayList2.add(pack22);
            linkedList.add(0, pack22.getIndex());
        }
        if (!hashSet4.isEmpty() && (pack = this.writePack(hashSet4, hashSet, PackWriter.NONE, PackWriter.NONE, hashSet6, linkedList, false)) != null) {
            arrayList2.add(pack);
        }
        if (!hashSet5.isEmpty() && (pack = this.writePack(hashSet5, PackWriter.NONE, PackWriter.NONE, PackWriter.NONE, null, linkedList, false)) != null) {
            arrayList2.add(pack);
        }
        try {
            this.deleteOldPacks(collection, arrayList2);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException);
        }
        this.prunePacked();
        if (this.repo.getRefDatabase() instanceof RefDirectory) {
            this.deleteEmptyRefsFolders();
        }
        this.deleteOrphans();
        this.deleteTempPacksIdx();
        this.lastPackedRefs = collection2;
        this.lastRepackTime = l2;
        return arrayList2;
    }

    private static boolean isHead(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private void deleteEmptyRefsFolders() {
        Path path2 = this.repo.getDirectoryChild("refs/").toPath();
        Instant instant = Instant.now().minus(30L, ChronoUnit.SECONDS);
        try (Stream<Path> stream = Files.list(path2).filter(path -> Files.isDirectory(path, new LinkOption[0]));){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Stream<Path> stream2 = Files.list((Path)iterator.next());
                Throwable throwable = null;
                try {
                    stream2.filter(path -> this.canBeSafelyDeleted((Path)path, instant)).forEach(this::deleteDir);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream2 == null) continue;
                    if (throwable != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream2.close();
                }
            }
        }
    }

    private boolean canBeSafelyDeleted(Path path, Instant instant) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(instant);
        }
        catch (IOException iOException) {
            LOG.warn(MessageFormat.format(JGitText.get().cannotAccessLastModifiedForSafeDeletion, path), (Throwable)iOException);
            return false;
        }
    }

    private void deleteDir(Path path) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.filter(this::isDirectory).sorted(Comparator.reverseOrder()).forEach(this::delete);
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private boolean isDirectory(Path path) {
        return path.toFile().isDirectory();
    }

    private void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
        }
        catch (IOException iOException) {
            LOG.error(MessageFormat.format(JGitText.get().cannotDeleteFile, path), (Throwable)iOException);
        }
    }

    private void deleteOrphans() {
        Object object;
        Path path2 = this.repo.getObjectDatabase().getPackDirectory().toPath();
        List list = null;
        try {
            object = Files.list(path2);
            Object object2 = null;
            try {
                list = object.map(path -> path.getFileName().toString()).filter(string -> string.endsWith(PACK_EXT) || string.endsWith(BITMAP_EXT) || string.endsWith(INDEX_EXT) || string.endsWith(KEEP_EXT)).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            return;
        }
        if (list == null) {
            return;
        }
        object = null;
        for (String string2 : list) {
            PackFile packFile = new PackFile(path2.toFile(), string2);
            PackExt packExt = packFile.getPackExt();
            if (packExt.equals((Object)PackExt.PACK) || packExt.equals((Object)PackExt.KEEP)) {
                object = packFile.getId();
            }
            if (object != null && packFile.getId().equals(object)) continue;
            try {
                FileUtils.delete(packFile, 6);
                LOG.warn(JGitText.get().deletedOrphanInPackDir, (Object)packFile);
            }
            catch (IOException iOException) {
                LOG.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private void deleteTempPacksIdx() {
        Path path2 = this.repo.getObjectDatabase().getPackDirectory().toPath();
        Instant instant = Instant.now().minus(1L, ChronoUnit.DAYS);
        if (!Files.exists(path2, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, "gc_*_tmp");){
            directoryStream.forEach(path -> {
                try {
                    Instant instant2 = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                    if (instant2.isBefore(instant)) {
                        Files.deleteIfExists(path);
                    }
                }
                catch (IOException iOException) {
                    LOG.error(iOException.getMessage(), (Throwable)iOException);
                }
            });
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private Set listRefLogObjects(Ref ref, long l2) {
        ReflogEntry reflogEntry;
        ReflogReader reflogReader = this.repo.getReflogReader(ref);
        List list = reflogReader.getReverseEntries();
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (reflogEntry = (ReflogEntry)iterator.next()).getWho().getWhen().getTime() >= l2) {
            ObjectId objectId;
            ObjectId objectId2 = reflogEntry.getNewId();
            if (objectId2 != null && !ObjectId.zeroId().equals(objectId2)) {
                hashSet.add(objectId2);
            }
            if ((objectId = reflogEntry.getOldId()) == null || ObjectId.zeroId().equals(objectId)) continue;
            hashSet.add(objectId);
        }
        return hashSet;
    }

    private Collection getAllRefs() {
        RefDatabase refDatabase = this.repo.getRefDatabase();
        List list = refDatabase.getRefs();
        List list2 = refDatabase.getAdditionalRefs();
        if (!list2.isEmpty()) {
            ArrayList<Ref> arrayList = new ArrayList<Ref>(list.size() + list2.size());
            arrayList.addAll(list);
            for (Ref ref : list2) {
                this.checkCancelled();
                if (!ref.getName().startsWith("refs/")) continue;
                arrayList.add(ref);
            }
            return arrayList;
        }
        return list;
    }

    private Set listNonHEADIndexObjects() {
        if (this.repo.isBare()) {
            return Collections.emptySet();
        }
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            Object object;
            Iterable iterable;
            treeWalk.addTree(new DirCacheIterator(this.repo.readDirCache()));
            ObjectId objectId = this.repo.resolve("HEAD");
            if (objectId != null) {
                iterable = new RevWalk(this.repo);
                object = null;
                try {
                    treeWalk.addTree(((RevWalk)iterable).parseTree(objectId));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (iterable != null) {
                        if (object != null) {
                            try {
                                ((RevWalk)iterable).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((RevWalk)iterable).close();
                        }
                    }
                }
            }
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            treeWalk.setRecursive(true);
            iterable = new HashSet();
            block22: while (treeWalk.next()) {
                this.checkCancelled();
                object = treeWalk.getObjectId(0);
                switch (treeWalk.getRawMode(0) & 0xF000) {
                    case 0: 
                    case 57344: {
                        continue block22;
                    }
                    case 16384: 
                    case 32768: 
                    case 40960: {
                        iterable.add(object);
                        continue block22;
                    }
                }
                throw new IOException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", treeWalk.getRawMode(0)), object == null ? "null" : ((AnyObjectId)object).name(), treeWalk.getPathString(), this.repo.getIndexFile()));
            }
            object = iterable;
            return object;
        }
    }

    /*
     * Exception decompiling
     */
    private Pack writePack(@NonNull Set var1_1, @NonNull Set var2_2, @NonNull Set var3_3, @NonNull Set var4_4, Set var5_5, List var6_6, boolean var7_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 44[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set union(Set set, Set set2) {
        HashSet hashSet = new HashSet(set.size() + set2.size());
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private void checkCancelled() {
        if (this.pm.isCancelled() || Thread.currentThread().isInterrupted()) {
            throw new CancelledException(JGitText.get().operationCanceled);
        }
    }

    public void setPackKeptObjects(boolean bl2) {
        this.packKeptObjects = bl2;
    }

    private boolean shouldPackKeptObjects() {
        return Optional.ofNullable(this.packKeptObjects).orElse(this.pconfig.isPackKeptObjects());
    }

    public GC$RepoStatistics getStatistics() {
        String[] stringArray2;
        GC$RepoStatistics gC$RepoStatistics = new GC$RepoStatistics();
        Collection collection = this.repo.getObjectDatabase().getPacks();
        for (String[] stringArray2 : collection) {
            gC$RepoStatistics.numberOfPackedObjects += stringArray2.getIndex().getObjectCount();
            ++gC$RepoStatistics.numberOfPackFiles;
            gC$RepoStatistics.sizeOfPackedObjects += stringArray2.getPackFile().length();
            if (stringArray2.getBitmapIndex() == null) continue;
            gC$RepoStatistics.numberOfBitmaps += (long)stringArray2.getBitmapIndex().getBitmapCount();
        }
        File file = this.repo.getObjectsDirectory();
        stringArray2 = file.list();
        if (stringArray2 != null && stringArray2.length > 0) {
            for (Object object : stringArray2) {
                File[] fileArray;
                if (object.length() != 2 || (fileArray = new File(file, (String)object).listFiles()) == null) continue;
                for (File file2 : fileArray) {
                    if (file2.getName().length() != 38) continue;
                    ++gC$RepoStatistics.numberOfLooseObjects;
                    gC$RepoStatistics.sizeOfLooseObjects += file2.length();
                }
            }
        }
        String[] stringArray3 = this.repo.getRefDatabase();
        for (Ref ref : stringArray3.getRefs()) {
            Object object;
            object = ref.getStorage();
            if (object == Ref$Storage.LOOSE || object == Ref$Storage.LOOSE_PACKED) {
                ++gC$RepoStatistics.numberOfLooseRefs;
            }
            if (object != Ref$Storage.PACKED && object != Ref$Storage.LOOSE_PACKED) continue;
            ++gC$RepoStatistics.numberOfPackedRefs;
        }
        return gC$RepoStatistics;
    }

    public GC setProgressMonitor(ProgressMonitor progressMonitor) {
        this.pm = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        return this;
    }

    public void setExpireAgeMillis(long l2) {
        this.expireAgeMillis = l2;
        this.expire = null;
    }

    public void setPackExpireAgeMillis(long l2) {
        this.packExpireAgeMillis = l2;
        this.expire = null;
    }

    public void setPackConfig(@NonNull PackConfig packConfig) {
        this.pconfig = packConfig;
    }

    public void setExpire(Date date) {
        this.expire = date;
        this.expireAgeMillis = -1L;
    }

    public void setPackExpire(Date date) {
        this.packExpire = date;
        this.packExpireAgeMillis = -1L;
    }

    public void setAuto(boolean bl2) {
        this.automatic = bl2;
    }

    void setBackground(boolean bl2) {
        this.background = bl2;
    }

    private boolean needGc() {
        if (!this.tooManyPacks()) {
            return this.tooManyLooseObjects();
        }
        this.addRepackAllOption();
        return true;
    }

    private void addRepackAllOption() {
    }

    boolean tooManyPacks() {
        int n2 = this.repo.getConfig().getInt("gc", "autopacklimit", 50);
        if (n2 <= 0) {
            return false;
        }
        return this.repo.getObjectDatabase().getPacks().size() > n2 + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tooManyLooseObjects() {
        int n2 = this.getLooseObjectLimit();
        if (n2 <= 0) {
            return false;
        }
        int n3 = 0;
        int n4 = (n2 + 255) / 256;
        Path path2 = this.repo.getObjectsDirectory().toPath().resolve("17");
        if (!path2.toFile().exists()) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, path -> {
            Path path2 = path.getFileName();
            return path.toFile().isFile() && path2 != null && PATTERN_LOOSE_OBJECT.matcher(path2.toString()).matches();
        });){
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                if (++n3 > n4) {
                    boolean bl2 = true;
                    return bl2;
                }
                iterator.next();
            }
            return false;
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
        }
        return false;
    }

    private int getLooseObjectLimit() {
        return this.repo.getConfig().getInt("gc", "auto", 6700);
    }

    private static /* synthetic */ int lambda$writePack$6(PackExt packExt, PackExt packExt2) {
        if (packExt == packExt2) {
            return 0;
        }
        if (packExt == PackExt.INDEX) {
            return 1;
        }
        if (packExt2 == PackExt.INDEX) {
            return -1;
        }
        return Integer.signum(packExt.hashCode() - packExt2.hashCode());
    }

    static /* synthetic */ FileRepository access$000(GC gC) {
        return gC.repo;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

