/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$LockToken;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;

class GC$PidLock
implements AutoCloseable {
    private static final String GC_PID = "gc.pid";
    private final Path pidFile;
    private FS$LockToken token;
    private FileLock lock;
    private RandomAccessFile f;
    private FileChannel channel;
    final /* synthetic */ GC this$0;

    GC$PidLock(GC gC) {
        this.this$0 = gC;
        this.pidFile = GC.access$000(gC).getDirectory().toPath().resolve(GC_PID);
    }

    boolean lock() {
        Object object;
        if (Files.exists(this.pidFile, new LinkOption[0])) {
            Instant instant;
            object = FS.DETECTED.lastModifiedInstant(this.pidFile.toFile());
            if (((Instant)object).compareTo(instant = Instant.now().minus(12L, ChronoUnit.HOURS)) > 0) {
                this.gcAlreadyRunning();
                return false;
            }
            GC.access$100().warn(MessageFormat.format(JGitText.get().stalePidLock, this.pidFile, object));
        }
        try {
            this.token = FS.DETECTED.createNewFileAtomic(this.pidFile.toFile());
            this.f = new RandomAccessFile(this.pidFile.toFile(), "rw");
            this.channel = this.f.getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock == null || !this.lock.isValid()) {
                this.gcAlreadyRunning();
                return false;
            }
            this.channel.write(ByteBuffer.wrap(this.getProcDesc().getBytes(StandardCharsets.UTF_8)));
            object = new Thread(() -> this.close());
            try {
                Runtime.getRuntime().addShutdownHook((Thread)object);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (IOException | OverlappingFileLockException exception) {
            try {
                this.failedToLock();
            }
            catch (Exception exception2) {
                GC.access$100().error(MessageFormat.format(JGitText.get().closePidLockFailed, this.pidFile), (Throwable)exception2);
            }
            throw exception;
        }
        return true;
    }

    private void failedToLock() {
        this.close();
        GC.access$100().error(MessageFormat.format(JGitText.get().failedPidLock, this.pidFile));
    }

    private void gcAlreadyRunning() {
        this.close();
        try (Stream<String> stream = Files.lines(this.pidFile);){
            Optional<String> optional = stream.findFirst();
            String string = null;
            String string2 = null;
            if (optional.isPresent()) {
                String[] stringArray = optional.get().split("\\s+");
                string2 = stringArray[0];
                string = stringArray[1];
            }
            if (!StringUtils.isEmptyOrNull(string) && !StringUtils.isEmptyOrNull(string2)) {
                GC.access$100().error(MessageFormat.format(JGitText.get().gcAlreadyRunning, string, string2));
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GC.access$100().error(MessageFormat.format(JGitText.get().failedPidLock, this.pidFile));
    }

    private String getProcDesc() {
        StringBuffer stringBuffer = new StringBuffer(Long.toString(this.getPID()));
        stringBuffer.append(' ');
        stringBuffer.append(this.getHostName());
        return stringBuffer.toString();
    }

    private long getPID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        if (string != null && string.length() > 0) {
            try {
                return Long.parseLong(string.split("@")[0]);
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return 0L;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    @Override
    public void close() {
        boolean bl2 = false;
        try {
            if (this.lock != null && this.lock.isValid()) {
                this.lock.release();
                bl2 = true;
            }
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.f != null) {
                this.f.close();
            }
            if (this.token != null) {
                this.token.close();
            }
            if (bl2) {
                FileUtils.delete(this.pidFile.toFile(), 2);
            }
        }
        catch (IOException iOException) {
            GC.access$100().error(MessageFormat.format(JGitText.get().closePidLockFailed, this.pidFile), (Throwable)iOException);
        }
    }
}

