/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.storage.file.FileSnapshot$1;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS$FileStoreAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(FileSnapshot.class);
    public static final long UNKNOWN_SIZE = -1L;
    private static final Instant UNKNOWN_TIME = Instant.ofEpochMilli(-1L);
    private static final Object MISSING_FILEKEY = new Object();
    private static final DateTimeFormatter dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    public static final FileSnapshot DIRTY = new FileSnapshot(UNKNOWN_TIME, UNKNOWN_TIME, -1L, Duration.ZERO, MISSING_FILEKEY);
    public static final FileSnapshot MISSING_FILE = new FileSnapshot$1(Instant.EPOCH, Instant.EPOCH, 0L, Duration.ZERO, MISSING_FILEKEY);
    private final Instant lastModified;
    private volatile Instant lastRead;
    private boolean cannotBeRacilyClean;
    private final long size;
    private FS$FileStoreAttributes fileStoreAttributeCache;
    private boolean useConfig;
    private final Object fileKey;
    private final File file;
    private boolean sizeChanged;
    private boolean fileKeyChanged;
    private boolean lastModifiedChanged;
    private boolean wasRacyClean;
    private long delta;
    private long racyThreshold;

    public static FileSnapshot save(File file, FS fS) {
        return new FileSnapshot(file, fS);
    }

    public static FileSnapshot saveNoConfig(File file, FS fS) {
        return new FileSnapshot(file, false, fS);
    }

    private static Object getFileKey(BasicFileAttributes basicFileAttributes) {
        Object object = basicFileAttributes.fileKey();
        return object == null ? MISSING_FILEKEY : object;
    }

    @Deprecated
    public static FileSnapshot save(long l2) {
        Instant instant = Instant.now();
        return new FileSnapshot(instant, Instant.ofEpochMilli(l2), -1L, FS$FileStoreAttributes.FALLBACK_TIMESTAMP_RESOLUTION, MISSING_FILEKEY);
    }

    public static FileSnapshot save(Instant instant) {
        Instant instant2 = Instant.now();
        return new FileSnapshot(instant2, instant, -1L, FS$FileStoreAttributes.FALLBACK_TIMESTAMP_RESOLUTION, MISSING_FILEKEY);
    }

    protected FileSnapshot(File file, FS fS) {
        this(file, true, fS);
    }

    protected FileSnapshot(File file, boolean bl2, FS fS) {
        this.file = file;
        this.lastRead = Instant.now();
        this.useConfig = bl2;
        BasicFileAttributes basicFileAttributes = null;
        try {
            basicFileAttributes = FS.DETECTED.fileAttributes(file);
        }
        catch (NoSuchFileException noSuchFileException) {
            this.lastModified = Instant.EPOCH;
            this.size = 0L;
            this.fileKey = MISSING_FILEKEY;
            return;
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            this.lastModified = Instant.EPOCH;
            this.size = 0L;
            this.fileKey = MISSING_FILEKEY;
            return;
        }
        this.lastModified = basicFileAttributes.lastModifiedTime().toInstant();
        this.size = basicFileAttributes.size();
        this.fileKey = FileSnapshot.getFileKey(basicFileAttributes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("file={}, create new FileSnapshot: lastRead={}, lastModified={}, size={}, fileKey={}", new Object[]{file, dateFmt.format(this.lastRead), dateFmt.format(this.lastModified), this.size, this.fileKey.toString()});
        }
    }

    private FileSnapshot(Instant instant, Instant instant2, long l2, @NonNull Duration duration, @NonNull Object object) {
        this.file = null;
        this.lastRead = instant;
        this.lastModified = instant2;
        this.fileStoreAttributeCache = new FS$FileStoreAttributes(duration);
        this.size = l2;
        this.fileKey = object;
    }

    @Deprecated
    public long lastModified() {
        return this.lastModified.toEpochMilli();
    }

    public Instant lastModifiedInstant() {
        return this.lastModified;
    }

    public long size() {
        return this.size;
    }

    public boolean isModified(File file) {
        Object object;
        long l2;
        Instant instant;
        try {
            BasicFileAttributes basicFileAttributes = FS.DETECTED.fileAttributes(file);
            instant = basicFileAttributes.lastModifiedTime().toInstant();
            l2 = basicFileAttributes.size();
            object = FileSnapshot.getFileKey(basicFileAttributes);
        }
        catch (NoSuchFileException noSuchFileException) {
            instant = Instant.EPOCH;
            l2 = 0L;
            object = MISSING_FILEKEY;
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), (Throwable)iOException);
            instant = Instant.EPOCH;
            l2 = 0L;
            object = MISSING_FILEKEY;
        }
        this.sizeChanged = this.isSizeChanged(l2);
        if (this.sizeChanged) {
            return true;
        }
        this.fileKeyChanged = this.isFileKeyChanged(object);
        if (this.fileKeyChanged) {
            return true;
        }
        this.lastModifiedChanged = this.isModified(instant);
        return this.lastModifiedChanged;
    }

    public void setClean(FileSnapshot fileSnapshot) {
        Instant instant = fileSnapshot.lastRead;
        if (!this.isRacyClean(instant)) {
            this.cannotBeRacilyClean = true;
        }
        this.lastRead = instant;
    }

    public void waitUntilNotRacy() {
        long l2 = this.fileStoreAttributeCache().getFsTimestampResolution().toNanos();
        while (this.isRacyClean(Instant.now())) {
            TimeUnit.NANOSECONDS.sleep(l2);
        }
    }

    public boolean equals(FileSnapshot fileSnapshot) {
        boolean bl2 = this.size == -1L || fileSnapshot.size == -1L || this.size == fileSnapshot.size;
        return this.lastModified.equals(fileSnapshot.lastModified) && bl2 && Objects.equals(this.fileKey, fileSnapshot.fileKey);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FileSnapshot)) {
            return false;
        }
        FileSnapshot fileSnapshot = (FileSnapshot)object;
        return this.equals(fileSnapshot);
    }

    public int hashCode() {
        return Objects.hash(this.lastModified, this.size, this.fileKey);
    }

    boolean wasSizeChanged() {
        return this.sizeChanged;
    }

    boolean wasFileKeyChanged() {
        return this.fileKeyChanged;
    }

    boolean wasLastModifiedChanged() {
        return this.lastModifiedChanged;
    }

    boolean wasLastModifiedRacilyClean() {
        return this.wasRacyClean;
    }

    public long lastDelta() {
        return this.delta;
    }

    public long lastRacyThreshold() {
        return this.racyThreshold;
    }

    public String toString() {
        if (this == DIRTY) {
            return "DIRTY";
        }
        if (this == MISSING_FILE) {
            return "MISSING_FILE";
        }
        return "FileSnapshot[modified: " + dateFmt.format(this.lastModified) + ", read: " + dateFmt.format(this.lastRead) + ", size:" + this.size + ", fileKey: " + this.fileKey + "]";
    }

    private boolean isRacyClean(Instant instant) {
        this.racyThreshold = this.getEffectiveRacyThreshold();
        this.delta = Duration.between(this.lastModified, instant).toNanos();
        boolean bl2 = this.wasRacyClean = this.delta <= this.racyThreshold;
        if (LOG.isDebugEnabled()) {
            LOG.debug("file={}, isRacyClean={}, read={}, lastModified={}, delta={} ns, racy<={} ns", new Object[]{this.file, this.wasRacyClean, dateFmt.format(instant), dateFmt.format(this.lastModified), this.delta, this.racyThreshold});
        }
        return this.wasRacyClean;
    }

    private long getEffectiveRacyThreshold() {
        long l2;
        long l3 = this.fileStoreAttributeCache().getFsTimestampResolution().toNanos();
        long l4 = Math.max(l3, l2 = this.fileStoreAttributeCache().getMinimalRacyInterval().toNanos());
        return l4 < 100000000L ? l4 * 5L / 2L : l4 * 5L / 4L;
    }

    private boolean isModified(Instant instant) {
        boolean bl2 = this.lastModifiedChanged = !this.lastModified.equals(instant);
        if (this.lastModifiedChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("file={}, lastModified changed from {} to {}", new Object[]{this.file, dateFmt.format(this.lastModified), dateFmt.format(instant)});
            }
            return true;
        }
        if (this.cannotBeRacilyClean) {
            LOG.debug("file={}, cannot be racily clean", (Object)this.file);
            return false;
        }
        if (!this.isRacyClean(this.lastRead)) {
            LOG.debug("file={}, is unmodified", (Object)this.file);
            return false;
        }
        LOG.debug("file={}, is racily clean", (Object)this.file);
        return true;
    }

    private boolean isFileKeyChanged(Object object) {
        boolean bl2;
        boolean bl3 = bl2 = object != MISSING_FILEKEY && !object.equals(this.fileKey);
        if (bl2) {
            LOG.debug("file={}, FileKey changed from {} to {}", new Object[]{this.file, this.fileKey, object});
        }
        return bl2;
    }

    private boolean isSizeChanged(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = l2 != -1L && l2 != this.size;
        if (bl2) {
            LOG.debug("file={}, size changed from {} to {} bytes", new Object[]{this.file, this.size, l2});
        }
        return bl2;
    }

    private FS$FileStoreAttributes fileStoreAttributeCache() {
        if (this.fileStoreAttributeCache == null) {
            this.fileStoreAttributeCache = this.useConfig ? FS.getFileStoreAttributes(this.file.toPath().getParent(), FS.DETECTED) : FS$FileStoreAttributes.FALLBACK_FILESTORE_ATTRIBUTES;
        }
        return this.fileStoreAttributeCache;
    }

    /* synthetic */ FileSnapshot(Instant instant, Instant instant2, long l2, Duration duration, Object object, FileSnapshot$1 var7_6) {
        this(instant, instant2, l2, duration, object);
    }
}

