/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase;
import org.eclipse.jgit.internal.storage.file.FileRepository$AttributesNodeProviderImpl;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateHandle;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory$AlternateRepository;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.ReflogReaderImpl;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig$HideDotFiles;
import org.eclipse.jgit.lib.CoreConfig$SymLinks;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceiveCommand$Result;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepository
extends Repository {
    private static final Logger LOG = LoggerFactory.getLogger(FileRepository.class);
    private static final String UNNAMED = "Unnamed repository; edit this file to name it for gitweb.";
    private final FileBasedConfig repoConfig;
    private RefDatabase refs;
    private final ObjectDirectory objectDatabase;
    private final Object snapshotLock = new Object();
    private FileSnapshot snapshot;

    public FileRepository(File file) {
        this(((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(file)).setup());
    }

    public FileRepository(String string) {
        this(new File(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileRepository(BaseRepositoryBuilder baseRepositoryBuilder) {
        super(baseRepositoryBuilder);
        StoredConfig storedConfig = null;
        try {
            storedConfig = SystemReader.getInstance().getUserConfig(this.getFS());
        }
        catch (ConfigInvalidException configInvalidException) {
            LOG.error(configInvalidException.getMessage(), (Throwable)configInvalidException);
            throw new IOException(configInvalidException.getMessage(), configInvalidException);
        }
        this.repoConfig = new FileBasedConfig(storedConfig, this.resolveDirectoryChild("config"), this.getFS());
        this.loadRepoConfig();
        this.repoConfig.addChangeListener(this::fireEvent);
        long l2 = this.getConfig().getLong("core", null, "repositoryformatversion", 0L);
        String string = this.repoConfig.getString("extensions", null, "refStorage");
        if (l2 >= 1L && string != null) {
            if (!StringUtils.equalsIgnoreCase(string, "reftable")) throw new IOException(JGitText.get().unknownRepositoryFormat);
            this.refs = new FileReftableDatabase(this);
        } else {
            this.refs = new RefDirectory(this);
        }
        this.objectDatabase = new ObjectDirectory(this.repoConfig, baseRepositoryBuilder.getObjectDirectory(), baseRepositoryBuilder.getAlternateObjectDirectories(), this.getFS(), this.getDirectoryChild("shallow"));
        if (this.objectDatabase.exists() && l2 > 1L) {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRepositoryFormat2, l2));
        }
        if (this.isBare()) return;
        this.snapshot = FileSnapshot.save(this.getIndexFile(), this.getFS());
    }

    private void loadRepoConfig() {
        try {
            this.repoConfig.load();
        }
        catch (ConfigInvalidException configInvalidException) {
            throw new IOException(JGitText.get().unknownRepositoryFormat, configInvalidException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(boolean bl2) {
        boolean bl3;
        Object object;
        FileBasedConfig fileBasedConfig = this.getConfig();
        if (fileBasedConfig.getFile().exists()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, this.getDirectory()));
        }
        FileUtils.mkdirs(this.getDirectory(), true);
        CoreConfig$HideDotFiles coreConfig$HideDotFiles = (CoreConfig$HideDotFiles)this.getConfig().getEnum("core", null, "hidedotfiles", CoreConfig$HideDotFiles.DOTGITONLY);
        if (coreConfig$HideDotFiles != CoreConfig$HideDotFiles.FALSE && !this.isBare() && this.getDirectory().getName().startsWith(".")) {
            this.getFS().setHidden(this.getDirectory(), true);
        }
        this.refs.create();
        this.objectDatabase.create();
        FileUtils.mkdir(this.getDirectoryChild("branches"));
        FileUtils.mkdir(this.getDirectoryChild("hooks"));
        RefUpdate refUpdate = this.updateRef("HEAD");
        refUpdate.disableRefLog();
        refUpdate.link("refs/heads/" + this.getInitialBranch());
        if (this.getFS().supportsExecute()) {
            object = File.createTempFile("try", "execute", this.getDirectory());
            this.getFS().setExecute((File)object, true);
            boolean bl4 = this.getFS().canExecute((File)object);
            this.getFS().setExecute((File)object, false);
            boolean bl5 = this.getFS().canExecute((File)object);
            FileUtils.delete((File)object);
            bl3 = bl4 && !bl5;
        } else {
            bl3 = false;
        }
        object = CoreConfig$SymLinks.FALSE;
        if (this.getFS().supportsSymlinks()) {
            File file = new File(this.getDirectory(), "tmplink");
            try {
                this.getFS().createSymLink(file, "target");
                object = null;
                FileUtils.delete(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object != null) {
            fileBasedConfig.setString("core", null, "symlinks", ((Enum)object).name().toLowerCase(Locale.ROOT));
        }
        fileBasedConfig.setInt("core", null, "repositoryformatversion", 0);
        fileBasedConfig.setBoolean("core", null, "filemode", bl3);
        if (bl2) {
            fileBasedConfig.setBoolean("core", null, "bare", true);
        }
        fileBasedConfig.setBoolean("core", null, "logallrefupdates", !bl2);
        if (SystemReader.getInstance().isMacOS()) {
            fileBasedConfig.setBoolean("core", null, "precomposeunicode", true);
        }
        if (!bl2) {
            File file = this.getWorkTree();
            if (!this.getDirectory().getParentFile().equals(file)) {
                fileBasedConfig.setString("core", null, "worktree", this.getWorkTree().getAbsolutePath());
                LockFile lockFile = new LockFile(new File(file, ".git"), this.getFS());
                try {
                    if (lockFile.lock()) {
                        lockFile.write(Constants.encode("gitdir: " + this.getDirectory().getAbsolutePath()));
                        lockFile.commit();
                    }
                }
                finally {
                    lockFile.unlock();
                }
            }
        }
        fileBasedConfig.save();
    }

    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    @Override
    public ObjectDirectory getObjectDatabase() {
        return this.objectDatabase;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    @Override
    public String getIdentifier() {
        File file = this.getDirectory();
        if (file != null) {
            return file.getPath();
        }
        throw new IllegalStateException();
    }

    @Override
    public FileBasedConfig getConfig() {
        try {
            SystemReader.getInstance().getUserConfig(this.getFS());
            if (this.repoConfig.isOutdated()) {
                this.loadRepoConfig();
            }
        }
        catch (IOException | ConfigInvalidException exception) {
            throw new RuntimeException(exception);
        }
        return this.repoConfig;
    }

    @Override
    @Nullable
    public String getGitwebDescription() {
        String string;
        try {
            string = RawParseUtils.decode(IO.readFully(this.descriptionFile()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        if (string != null && ((string = string.trim()).isEmpty() || UNNAMED.equals(string))) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGitwebDescription(@Nullable String string) {
        String string2 = this.getGitwebDescription();
        if (Objects.equals(string2, string)) {
            return;
        }
        File file = this.descriptionFile();
        LockFile lockFile = new LockFile(file, this.getFS());
        if (!lockFile.lock()) {
            throw new IOException(MessageFormat.format(JGitText.get().lockError, file.getAbsolutePath()));
        }
        try {
            String string3 = string;
            if (string3 != null) {
                if (!(string3 = string3.trim()).isEmpty()) {
                    string3 = string3 + '\n';
                }
            } else {
                string3 = "";
            }
            lockFile.write(Constants.encode(string3));
            lockFile.commit();
        }
        finally {
            lockFile.unlock();
        }
    }

    private File descriptionFile() {
        return this.getDirectoryChild("description");
    }

    @Override
    public Set getAdditionalHaves() {
        return this.getAdditionalHaves(null);
    }

    private Set getAdditionalHaves(Set set) {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        set = this.objectDatabase.addMe(set);
        for (ObjectDirectory$AlternateHandle objectDirectory$AlternateHandle : this.objectDatabase.myAlternates()) {
            if (!(objectDirectory$AlternateHandle instanceof ObjectDirectory$AlternateRepository) || set.contains(objectDirectory$AlternateHandle.getId())) continue;
            FileRepository fileRepository = ((ObjectDirectory$AlternateRepository)objectDirectory$AlternateHandle).repository;
            for (Ref ref : fileRepository.getAllRefs().values()) {
                if (ref.getObjectId() != null) {
                    hashSet.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                hashSet.add(ref.getPeeledObjectId());
            }
            hashSet.addAll(fileRepository.getAdditionalHaves(set));
        }
        return hashSet;
    }

    public void openPack(File file) {
        this.objectDatabase.openPack(file);
    }

    @Override
    public void scanForRepoChanges() {
        this.getRefDatabase().getRefs();
        this.detectIndexChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectIndexChanges() {
        if (this.isBare()) {
            return;
        }
        File file = this.getIndexFile();
        Object object = this.snapshotLock;
        synchronized (object) {
            if (this.snapshot == null) {
                this.snapshot = FileSnapshot.save(file, this.getFS());
                return;
            }
            if (!this.snapshot.isModified(file)) {
                return;
            }
        }
        this.notifyIndexChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIndexChanged(boolean bl2) {
        Object object = this.snapshotLock;
        synchronized (object) {
            this.snapshot = FileSnapshot.save(this.getIndexFile(), this.getFS());
        }
        this.fireEvent(new IndexChangedEvent(bl2));
    }

    @Override
    public ReflogReader getReflogReader(String string) {
        if (this.refs instanceof FileReftableDatabase) {
            return ((FileReftableDatabase)this.refs).getReflogReader(string);
        }
        Ref ref = this.findRef(string);
        if (ref == null) {
            return null;
        }
        return new ReflogReaderImpl(this, ref.getName());
    }

    @Override
    @NonNull
    public ReflogReader getReflogReader(@NonNull Ref ref) {
        return new ReflogReaderImpl(this, ref.getName());
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return new FileRepository$AttributesNodeProviderImpl(this);
    }

    private boolean shouldAutoDetach() {
        return this.getConfig().getBoolean("gc", "autoDetach", true);
    }

    @Override
    public void autoGC(ProgressMonitor progressMonitor) {
    }

    void convertToPackedRefs(boolean bl2, boolean bl3) {
        Object object322;
        List list = this.refs.getRefs();
        File file = new File(this.getDirectory(), "packed-refs");
        if (file.exists()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileAlreadyExists, file.getName()));
        }
        File file2 = new File(this.getDirectory(), "refs");
        File file3 = new File(file2, "heads");
        File file4 = new File(this.getDirectory(), "HEAD");
        FileReftableDatabase fileReftableDatabase = (FileReftableDatabase)this.refs;
        file3.delete();
        file2.delete();
        file4.delete();
        RefDirectory refDirectory = new RefDirectory(this);
        this.refs = refDirectory;
        this.refs.create();
        ReflogWriter reflogWriter = refDirectory.newLogWriter(true);
        ArrayList<Ref> arrayList = new ArrayList<Ref>();
        BatchRefUpdate batchRefUpdate = this.refs.newBatchUpdate();
        for (Object object322 : list) {
            if (object322.isSymbolic()) {
                arrayList.add((Ref)object322);
            } else {
                batchRefUpdate.addCommand(new ReceiveCommand(ObjectId.zeroId(), object322.getObjectId(), object322.getName()));
            }
            if (!bl2) continue;
            List object4 = fileReftableDatabase.getReflogReader(object322.getName()).getReverseEntries();
            Collections.reverse(object4);
            for (Object object : object4) {
                reflogWriter.log(object322.getName(), (ReflogEntry)object);
            }
        }
        ArrayList<String> arrayList2 = new RevWalk(this);
        object322 = null;
        try {
            batchRefUpdate.execute((RevWalk)((Object)arrayList2), NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable) {
            object322 = throwable;
            throw throwable;
        }
        finally {
            if (arrayList2 != null) {
                if (object322 != null) {
                    try {
                        ((RevWalk)((Object)arrayList2)).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object322).addSuppressed(throwable);
                    }
                } else {
                    ((RevWalk)((Object)arrayList2)).close();
                }
            }
        }
        arrayList2 = new ArrayList<String>();
        for (ReceiveCommand receiveCommand : batchRefUpdate.getCommands()) {
            if (receiveCommand.getResult() == ReceiveCommand$Result.OK) continue;
            arrayList2.add(receiveCommand.getRefName() + ": " + (Object)((Object)receiveCommand.getResult()));
        }
        if (!arrayList2.isEmpty()) {
            throw new IOException(String.format("%s: %s", JGitText.get().failedToConvert, StringUtils.join(arrayList2, ", ")));
        }
        for (Ref ref : arrayList) {
            Object object;
            RefUpdate refUpdate = this.refs.newUpdate(ref.getName(), false);
            refUpdate.setForceUpdate(true);
            object = refUpdate.link(ref.getTarget().getName());
            if (object == RefUpdate$Result.NEW || object == RefUpdate$Result.NO_CHANGE) continue;
            throw new IOException(String.format("ref %s: %s", ref.getName(), object));
        }
        if (!bl3) {
            object322 = new File(this.getDirectory(), "reftable");
            FileUtils.delete((File)object322, 9);
        }
        this.repoConfig.unset("extensions", null, "refStorage");
        this.repoConfig.save();
    }

    void convertToReftable(boolean bl2, boolean bl3) {
        Object object2;
        File file = new File(this.getDirectory(), "reftable");
        File file2 = new File(this.getDirectory(), "HEAD");
        if (file.exists() && FileUtils.hasFiles(file.toPath())) {
            throw new IOException(JGitText.get().reftableDirExists);
        }
        FileReftableDatabase.convertFrom(this, bl2);
        File file3 = new File(this.getDirectory(), "refs");
        File file4 = new File(this.getDirectory(), "packed-refs");
        File file5 = new File(this.getDirectory(), "logs");
        List list = this.getRefDatabase().getAdditionalRefs().stream().map(Ref::getName).collect(Collectors.toList());
        list.add("HEAD");
        if (bl3) {
            FileUtils.rename(file3, new File(this.getDirectory(), "refs.old"));
            if (file4.exists()) {
                FileUtils.rename(file4, new File(this.getDirectory(), "packed-refs.old"));
            }
            if (file5.exists()) {
                FileUtils.rename(file5, new File(this.getDirectory(), "logs.old"));
            }
            for (Object object2 : list) {
                FileUtils.rename(new File(this.getDirectory(), (String)object2), new File(this.getDirectory(), (String)object2 + ".old"));
            }
        } else {
            FileUtils.delete(file4, 4);
            FileUtils.delete(file2, 4);
            FileUtils.delete(file5, 5);
            FileUtils.delete(file3, 5);
            for (Object object2 : list) {
                new File(this.getDirectory(), (String)object2).delete();
            }
        }
        FileUtils.mkdir(file3, true);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        object2 = null;
        try {
            ((OutputStream)fileOutputStream).write(Constants.encodeASCII("ref: refs/heads/.invalid"));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (fileOutputStream != null) {
                if (object2 != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)fileOutputStream).close();
                }
            }
        }
        FileUtils.createNewFile(new File(file3, "heads"));
        this.repoConfig.setString("extensions", null, "refStorage", "reftable");
        this.repoConfig.setLong("core", null, "repositoryformatversion", 1L);
        this.repoConfig.save();
        this.refs.close();
        this.refs = new FileReftableDatabase(this);
    }

    public void convertRefStorage(String string, boolean bl2, boolean bl3) {
        if (string.equals("reftable")) {
            if (this.refs instanceof RefDirectory) {
                this.convertToReftable(bl2, bl3);
            }
        } else if (string.equals("refdir")) {
            if (this.refs instanceof FileReftableDatabase) {
                this.convertToPackedRefs(bl2, bl3);
            }
        } else {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRefStorageFormat, string));
        }
    }
}

