/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.internal.storage.file.GlobalAttributesNode;
import org.eclipse.jgit.internal.storage.file.InfoAttributesNode;
import org.eclipse.jgit.lib.Repository;

class FileRepository$AttributesNodeProviderImpl
implements AttributesNodeProvider {
    private AttributesNode infoAttributesNode;
    private AttributesNode globalAttributesNode;

    protected FileRepository$AttributesNodeProviderImpl(Repository repository) {
        this.infoAttributesNode = new InfoAttributesNode(repository);
        this.globalAttributesNode = new GlobalAttributesNode(repository);
    }

    @Override
    public AttributesNode getInfoAttributesNode() {
        if (this.infoAttributesNode instanceof InfoAttributesNode) {
            this.infoAttributesNode = ((InfoAttributesNode)this.infoAttributesNode).load();
        }
        return this.infoAttributesNode;
    }

    @Override
    public AttributesNode getGlobalAttributesNode() {
        if (this.globalAttributesNode instanceof GlobalAttributesNode) {
            this.globalAttributesNode = ((GlobalAttributesNode)this.globalAttributesNode).load();
        }
        return this.globalAttributesNode;
    }

    static void loadRulesFromFile(AttributesNode attributesNode, File file) {
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                attributesNode.parse(fileInputStream);
            }
        }
    }
}

