/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.storage.file.FileReftableStack$CompactionStats;
import org.eclipse.jgit.internal.storage.file.FileReftableStack$Segment;
import org.eclipse.jgit.internal.storage.file.FileReftableStack$StackEntry;
import org.eclipse.jgit.internal.storage.file.FileReftableStack$Writer;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter$Stats;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.util.FileUtils;

public class FileReftableStack
implements AutoCloseable {
    private MergedReftable mergedReftable;
    private List stack;
    private long lastNextUpdateIndex;
    private final File stackPath;
    private final File reftableDir;
    private final Runnable onChange;
    private final SecureRandom random = new SecureRandom();
    private final Supplier configSupplier;
    private final FileReftableStack$CompactionStats stats;
    private static long OVERHEAD = 91L;

    public FileReftableStack(File file, File file2, @Nullable Runnable runnable, Supplier supplier) {
        this.stackPath = file;
        this.reftableDir = file2;
        this.stack = new ArrayList();
        this.configSupplier = supplier;
        this.onChange = runnable;
        this.lastNextUpdateIndex = 0L;
        this.reload();
        this.stats = new FileReftableStack$CompactionStats();
    }

    FileReftableStack$CompactionStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadOnce(List list) {
        Map<String, ReftableReader> map = this.stack.stream().collect(Collectors.toMap(fileReftableStack$StackEntry -> fileReftableStack$StackEntry.name, fileReftableStack$StackEntry -> fileReftableStack$StackEntry.reftableReader));
        ArrayList<ReftableReader> arrayList = new ArrayList<ReftableReader>();
        ArrayList<FileReftableStack$StackEntry> arrayList2 = new ArrayList<FileReftableStack$StackEntry>(this.stack.size() + 1);
        try {
            for (String string : list) {
                FileReftableStack$StackEntry fileReftableStack$StackEntry2 = new FileReftableStack$StackEntry(null);
                fileReftableStack$StackEntry2.name = string;
                ReftableReader reftableReader2 = null;
                if (map.containsKey(string)) {
                    reftableReader2 = map.remove(string);
                } else {
                    File file = new File(this.reftableDir, string);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    reftableReader2 = new ReftableReader(BlockSource.from(fileInputStream));
                    arrayList.add(reftableReader2);
                }
                fileReftableStack$StackEntry2.reftableReader = reftableReader2;
                arrayList2.add(fileReftableStack$StackEntry2);
            }
            this.stack = arrayList2;
            arrayList.clear();
            map.values().forEach(reftableReader -> {
                try {
                    reftableReader.close();
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
            });
        }
        finally {
            arrayList.forEach(reftableReader -> {
                try {
                    reftableReader.close();
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
            });
        }
    }

    void reload() {
        long l2 = System.currentTimeMillis() + 2500L;
        long l3 = 1L;
        long l4 = 1000L;
        long l5 = 0L;
        boolean bl2 = false;
        for (int i2 = 0; i2 < 3 || System.currentTimeMillis() < l2; ++i2) {
            List list = this.readTableNames();
            try {
                this.reloadOnce(list);
                bl2 = true;
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
                List list2 = this.readTableNames();
                if (list2.equals(list)) {
                    throw fileNotFoundException;
                }
                l5 = FileUtils.delay(l5, l3, l4);
                try {
                    Thread.sleep(l5);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptedException);
                }
            }
        }
        if (!bl2) {
            throw new LockFailedException(this.stackPath);
        }
        this.mergedReftable = new MergedReftable(this.stack.stream().map(fileReftableStack$StackEntry -> fileReftableStack$StackEntry.reftableReader).collect(Collectors.toList()));
        long l6 = this.nextUpdateIndex();
        if (this.lastNextUpdateIndex > 0L && this.lastNextUpdateIndex != l6 && this.onChange != null) {
            this.onChange.run();
        }
        this.lastNextUpdateIndex = l6;
    }

    public MergedReftable getMergedReftable() {
        return this.mergedReftable;
    }

    private List readTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.stack.size() + 1);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.stackPath), StandardCharsets.UTF_8));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty()) continue;
                arrayList.add(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return arrayList;
    }

    boolean isUpToDate() {
        try {
            List list = this.readTableNames();
            if (list.size() != this.stack.size()) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (((String)list.get(i2)).equals(((FileReftableStack$StackEntry)this.stack.get((int)i2)).name)) continue;
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.stack.isEmpty();
        }
        return true;
    }

    @Override
    public void close() {
        for (FileReftableStack$StackEntry fileReftableStack$StackEntry : this.stack) {
            try {
                fileReftableStack$StackEntry.reftableReader.close();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    private long nextUpdateIndex() {
        return this.stack.size() > 0 ? ((FileReftableStack$StackEntry)this.stack.get((int)(this.stack.size() - 1))).reftableReader.maxUpdateIndex() + 1L : 1L;
    }

    private String filename(long l2, long l3) {
        return String.format("%012x-%012x-%08x", l2, l3, this.random.nextInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReftable(FileReftableStack$Writer fileReftableStack$Writer) {
        LockFile lockFile = new LockFile(this.stackPath);
        try {
            ReftableWriter$Stats reftableWriter$Stats;
            if (!lockFile.lockForAppend()) {
                boolean bl2 = false;
                return bl2;
            }
            if (!this.isUpToDate()) {
                boolean bl3 = false;
                return bl3;
            }
            String string = this.filename(this.nextUpdateIndex(), this.nextUpdateIndex());
            File file = File.createTempFile(string + "_", ".ref", this.stackPath.getParentFile());
            try (Object object = new FileOutputStream(file);){
                ReftableWriter reftableWriter = new ReftableWriter(this.reftableConfig(), (OutputStream)object);
                fileReftableStack$Writer.call(reftableWriter);
                reftableWriter.finish();
                reftableWriter$Stats = reftableWriter.getStats();
            }
            if (reftableWriter$Stats.minUpdateIndex() < this.nextUpdateIndex()) {
                boolean bl4 = false;
                return bl4;
            }
            string = string + (reftableWriter$Stats.refCount() > 0L ? ".ref" : ".log");
            object = new File(this.reftableDir, string);
            FileUtils.rename(file, (File)object, StandardCopyOption.ATOMIC_MOVE);
            lockFile.write((string + "\n").getBytes(StandardCharsets.UTF_8));
            if (!lockFile.commit()) {
                FileUtils.delete((File)object);
                boolean bl5 = false;
                return bl5;
            }
            this.reload();
            this.autoCompact();
        }
        finally {
            lockFile.unlock();
        }
        return true;
    }

    private ReftableConfig reftableConfig() {
        return new ReftableConfig((Config)this.configSupplier.get());
    }

    private File compactLocked(int n2, int n3) {
        String string = this.filename(n2, n3);
        File file = File.createTempFile(string + "_", ".ref", this.stackPath.getParentFile());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ReftableCompactor reftableCompactor = new ReftableCompactor(fileOutputStream).setConfig(this.reftableConfig()).setIncludeDeletes(n2 > 0);
            ArrayList<ReftableReader> arrayList = new ArrayList<ReftableReader>();
            long l2 = 0L;
            for (int i2 = n2; i2 <= n3; ++i2) {
                arrayList.add(((FileReftableStack$StackEntry)this.stack.get((int)i2)).reftableReader);
                l2 += ((FileReftableStack$StackEntry)this.stack.get((int)i2)).reftableReader.size();
            }
            reftableCompactor.addAll(arrayList);
            reftableCompactor.compact();
            this.stats.bytes += l2;
            this.stats.tables += (long)(n2 - n3 + 1);
            ++this.stats.attempted;
            this.stats.refCount += reftableCompactor.getStats().refCount();
            this.stats.logCount += reftableCompactor.getStats().logCount();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compactRange(int n2, int n3) {
        if (n2 >= n3) {
            return true;
        }
        LockFile lockFile = new LockFile(this.stackPath);
        File file = null;
        ArrayList<LockFile> arrayList = new ArrayList<LockFile>();
        try {
            int n4;
            Object object;
            Object object2;
            int n5;
            if (!lockFile.lock()) {
                boolean bl2 = false;
                return bl2;
            }
            if (!this.isUpToDate()) {
                boolean bl3 = false;
                return bl3;
            }
            ArrayList arrayList2 = new ArrayList();
            for (n5 = n2; n5 <= n3; n5 += 1) {
                object2 = new File(this.reftableDir, ((FileReftableStack$StackEntry)this.stack.get((int)n5)).name);
                object = new LockFile((File)object2);
                if (!((LockFile)object).lock()) {
                    boolean bl4 = false;
                    return bl4;
                }
                arrayList.add((LockFile)object);
                arrayList2.add(object2);
            }
            lockFile.unlock();
            lockFile = null;
            file = this.compactLocked(n2, n3);
            lockFile = new LockFile(this.stackPath);
            if (!lockFile.lock()) {
                n5 = 0;
                return n5 != 0;
            }
            if (!this.isUpToDate()) {
                n5 = 0;
                return n5 != 0;
            }
            String string = this.filename(((FileReftableStack$StackEntry)this.stack.get((int)n2)).reftableReader.minUpdateIndex(), ((FileReftableStack$StackEntry)this.stack.get((int)n3)).reftableReader.maxUpdateIndex());
            string = string + ".ref";
            object2 = new File(this.reftableDir, string);
            FileUtils.rename(file, (File)object2, StandardCopyOption.ATOMIC_MOVE);
            file = null;
            object = new StringBuilder();
            for (n4 = 0; n4 < n2; n4 += 1) {
                ((StringBuilder)object).append(((FileReftableStack$StackEntry)this.stack.get((int)n4)).name + "\n");
            }
            ((StringBuilder)object).append(string + "\n");
            for (n4 = n3 + 1; n4 < this.stack.size(); n4 += 1) {
                ((StringBuilder)object).append(((FileReftableStack$StackEntry)this.stack.get((int)n4)).name + "\n");
            }
            lockFile.write(((StringBuilder)object).toString().getBytes(StandardCharsets.UTF_8));
            if (!lockFile.commit()) {
                ((File)object2).delete();
                n4 = 0;
                return n4 != 0;
            }
            for (File object3 : arrayList2) {
                Files.delete(object3.toPath());
            }
            this.reload();
            boolean bl5 = true;
            return bl5;
        }
        finally {
            if (file != null) {
                file.delete();
            }
            for (LockFile lockFile2 : arrayList) {
                lockFile2.unlock();
            }
            if (lockFile != null) {
                lockFile.unlock();
            }
        }
    }

    static int log(long l2) {
        long l3 = 2L;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("log2 negative");
        }
        int n2 = 0;
        while (l2 > 0L) {
            ++n2;
            l2 /= l3;
        }
        return n2 - 1;
    }

    static List segmentSizes(long[] lArray) {
        ArrayList<FileReftableStack$Segment> arrayList = new ArrayList<FileReftableStack$Segment>();
        FileReftableStack$Segment fileReftableStack$Segment = new FileReftableStack$Segment();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            int n2 = FileReftableStack.log(lArray[i2]);
            if (n2 != fileReftableStack$Segment.log && fileReftableStack$Segment.bytes > 0L) {
                arrayList.add(fileReftableStack$Segment);
                fileReftableStack$Segment = new FileReftableStack$Segment();
                fileReftableStack$Segment.start = i2;
                fileReftableStack$Segment.log = n2;
            }
            fileReftableStack$Segment.log = n2;
            fileReftableStack$Segment.end = i2 + 1;
            fileReftableStack$Segment.bytes += lArray[i2];
        }
        arrayList.add(fileReftableStack$Segment);
        return arrayList;
    }

    private static Optional autoCompactCandidate(long[] lArray) {
        if (lArray.length == 0) {
            return Optional.empty();
        }
        List list = FileReftableStack.segmentSizes(lArray);
        if ((list = list.stream().filter(fileReftableStack$Segment -> fileReftableStack$Segment.size() > 1).collect(Collectors.toList())).isEmpty()) {
            return Optional.empty();
        }
        Optional<FileReftableStack$Segment> optional = list.stream().min(Comparator.comparing(fileReftableStack$Segment -> fileReftableStack$Segment.log));
        FileReftableStack$Segment fileReftableStack$Segment2 = optional.get();
        while (fileReftableStack$Segment2.start > 0) {
            int n2 = fileReftableStack$Segment2.start - 1;
            long l2 = lArray[n2];
            if (FileReftableStack.log(fileReftableStack$Segment2.bytes) < FileReftableStack.log(l2)) break;
            fileReftableStack$Segment2.start = n2;
            fileReftableStack$Segment2.bytes += l2;
        }
        return Optional.of(fileReftableStack$Segment2);
    }

    private void autoCompact() {
        Optional optional = FileReftableStack.autoCompactCandidate(this.tableSizes());
        if (optional.isPresent() && !this.compactRange(((FileReftableStack$Segment)optional.get()).start, ((FileReftableStack$Segment)optional.get()).end - 1)) {
            ++this.stats.failed;
        }
    }

    private long[] tableSizes() {
        long[] lArray = new long[this.stack.size()];
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            lArray[i2] = ((FileReftableStack$StackEntry)this.stack.get((int)i2)).reftableReader.size() - OVERHEAD;
        }
        return lArray;
    }

    void compactFully() {
        if (!this.compactRange(0, this.stack.size() - 1)) {
            ++this.stats.failed;
        }
    }
}

