/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase$1;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase$FileRefRename;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase$FileReftableBatchRefUpdate;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase$FileReftableRefUpdate;
import org.eclipse.jgit.internal.storage.file.FileReftableStack;
import org.eclipse.jgit.internal.storage.file.FileReftableStack$Writer;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.reftable.ReftableDatabase;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefList$Builder;
import org.eclipse.jgit.util.RefMap;

public class FileReftableDatabase
extends RefDatabase {
    private final ReftableDatabase reftableDatabase;
    private final FileRepository fileRepository;
    private final FileReftableStack reftableStack;

    FileReftableDatabase(FileRepository fileRepository) {
        this(fileRepository, new File(new File(fileRepository.getDirectory(), "reftable"), "tables.list"));
    }

    FileReftableDatabase(FileRepository fileRepository, File file) {
        this.fileRepository = fileRepository;
        this.reftableStack = new FileReftableStack(file, new File(this.fileRepository.getDirectory(), "reftable"), () -> this.fileRepository.fireEvent(new RefsChangedEvent()), () -> this.fileRepository.getConfig());
        this.reftableDatabase = new FileReftableDatabase$1(this);
    }

    ReflogReader getReflogReader(String string) {
        return this.reftableDatabase.getReflogReader(string);
    }

    public static boolean isReftable(File file) {
        return new File(file, "reftable").isDirectory();
    }

    @Override
    public boolean hasFastTipsWithSha1() {
        return this.reftableDatabase.hasFastTipsWithSha1();
    }

    public void compactFully() {
        ReentrantLock reentrantLock = this.reftableDatabase.getLock();
        reentrantLock.lock();
        try {
            this.reftableStack.compactFully();
            this.reftableDatabase.clearCache();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private ReentrantLock getLock() {
        return this.reftableDatabase.getLock();
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new FileReftableDatabase$FileReftableBatchRefUpdate(this, this, this.fileRepository);
    }

    @Override
    public RefUpdate newUpdate(String string, boolean bl2) {
        boolean bl3 = false;
        Ref ref = this.exactRef(string);
        if (ref == null) {
            ref = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null);
        } else {
            bl3 = bl2 && ref.isSymbolic();
        }
        FileReftableDatabase$FileReftableRefUpdate fileReftableDatabase$FileReftableRefUpdate = new FileReftableDatabase$FileReftableRefUpdate(this, ref);
        if (bl3) {
            fileReftableDatabase$FileReftableRefUpdate.setDetachingSymbolicRef();
        }
        return fileReftableDatabase$FileReftableRefUpdate;
    }

    @Override
    public Ref exactRef(String string) {
        return this.reftableDatabase.exactRef(string);
    }

    @Override
    public List getRefs() {
        return super.getRefs();
    }

    @Override
    public Map getRefs(String string) {
        List list = this.reftableDatabase.getRefsByPrefix(string);
        RefList$Builder refList$Builder = new RefList$Builder(list.size());
        for (Ref ref : list) {
            refList$Builder.add(ref);
        }
        return new RefMap(string, refList$Builder.toRefList(), RefList.emptyList(), RefList.emptyList());
    }

    @Override
    public List getRefsByPrefixWithExclusions(String string, Set set) {
        return this.reftableDatabase.getRefsByPrefixWithExclusions(string, set);
    }

    @Override
    public List getAdditionalRefs() {
        return Collections.emptyList();
    }

    @Override
    public Ref peel(Ref ref) {
        Ref ref2 = ref.getLeaf();
        if (ref2.isPeeled() || ref2.getObjectId() == null) {
            return ref;
        }
        return FileReftableDatabase.recreate(ref, this.doPeel(ref2), this.hasVersioning());
    }

    private Ref doPeel(Ref ref) {
        try (RevWalk revWalk = new RevWalk(this.fileRepository);){
            RevObject revObject = revWalk.parseAny(ref.getObjectId());
            if (revObject instanceof RevTag) {
                ObjectIdRef$PeeledTag objectIdRef$PeeledTag = new ObjectIdRef$PeeledTag(ref.getStorage(), ref.getName(), ref.getObjectId(), revWalk.peel(revObject).copy(), this.hasVersioning() ? ref.getUpdateIndex() : -1L);
                return objectIdRef$PeeledTag;
            }
            ObjectIdRef$PeeledNonTag objectIdRef$PeeledNonTag = new ObjectIdRef$PeeledNonTag(ref.getStorage(), ref.getName(), ref.getObjectId(), this.hasVersioning() ? ref.getUpdateIndex() : -1L);
            return objectIdRef$PeeledNonTag;
        }
    }

    private static Ref recreate(Ref ref, Ref ref2, boolean bl2) {
        if (ref.isSymbolic()) {
            Ref ref3 = FileReftableDatabase.recreate(ref.getTarget(), ref2, bl2);
            return new SymbolicRef(ref.getName(), ref3, bl2 ? ref.getUpdateIndex() : -1L);
        }
        return ref2;
    }

    @Override
    public RefRename newRename(String string, String string2) {
        RefUpdate refUpdate = this.newUpdate(string, true);
        RefUpdate refUpdate2 = this.newUpdate(string2, true);
        return new FileReftableDatabase$FileRefRename(this, refUpdate, refUpdate2);
    }

    @Override
    public boolean isNameConflicting(String string) {
        return this.reftableDatabase.isNameConflicting(string, new TreeSet(), new HashSet());
    }

    @Override
    public void close() {
        this.reftableStack.close();
    }

    @Override
    public void create() {
        FileUtils.mkdir(new File(this.fileRepository.getDirectory(), "reftable"), true);
    }

    private boolean addReftable(FileReftableStack$Writer fileReftableStack$Writer) {
        if (!this.reftableStack.addReftable(fileReftableStack$Writer)) {
            this.reftableStack.reload();
            this.reftableDatabase.clearCache();
            return false;
        }
        this.reftableDatabase.clearCache();
        return true;
    }

    private static void writeConvertTable(Repository repository, ReftableWriter reftableWriter, boolean bl2) {
        Object object;
        Object object22;
        int n2 = 0;
        List list = repository.getRefDatabase().getRefs();
        if (bl2) {
            for (Object object22 : list) {
                object = repository.getReflogReader(object22.getName());
                if (object == null) continue;
                n2 = Math.max(object.getReverseEntries().size(), n2);
            }
        }
        reftableWriter.setMinUpdateIndex(1L).setMaxUpdateIndex(n2 + 1).begin();
        Iterator iterator = new RevWalk(repository);
        object22 = null;
        try {
            object = new ArrayList(list.size());
            for (Object object3 : list) {
                object.add(FileReftableDatabase.refForWrite((RevWalk)((Object)iterator), (Ref)object3));
            }
            reftableWriter.sortAndWriteRefs((Collection)object);
        }
        catch (Throwable throwable) {
            object22 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (object22 != null) {
                    try {
                        ((RevWalk)((Object)iterator)).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object22).addSuppressed(throwable);
                    }
                } else {
                    ((RevWalk)((Object)iterator)).close();
                }
            }
        }
        if (bl2) {
            for (Object object22 : list) {
                Object object3;
                long l2 = n2;
                object3 = repository.getReflogReader(object22.getName());
                if (object3 == null) continue;
                for (ReflogEntry reflogEntry : object3.getReverseEntries()) {
                    reftableWriter.writeLog(object22.getName(), l2, reflogEntry.getWho(), reflogEntry.getOldId(), reflogEntry.getNewId(), reflogEntry.getComment());
                    --l2;
                }
            }
        }
    }

    private static Ref refForWrite(RevWalk revWalk, Ref ref) {
        if (ref.isSymbolic()) {
            return new SymbolicRef(ref.getName(), new ObjectIdRef$Unpeeled(Ref$Storage.NEW, ref.getTarget().getName(), null));
        }
        ObjectId objectId = ref.getObjectId();
        RevObject revObject = null;
        try {
            RevObject revObject2 = revWalk.parseAny(objectId);
            if (revObject2 instanceof RevTag) {
                revObject = revWalk.peel(revObject2);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
        if (revObject != null) {
            return new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, ref.getName(), objectId, revObject.copy());
        }
        return new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, ref.getName(), objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileReftableDatabase convertFrom(FileRepository fileRepository, boolean bl2) {
        FileReftableDatabase fileReftableDatabase = null;
        File file = null;
        try {
            File file2 = new File(fileRepository.getDirectory(), "reftable");
            file = new File(file2, "tables.list");
            if (!file2.isDirectory()) {
                file2.mkdir();
            }
            try (FileReftableStack fileReftableStack = new FileReftableStack(file, file2, null, () -> fileRepository.getConfig());){
                fileReftableStack.addReftable(reftableWriter -> FileReftableDatabase.writeConvertTable(fileRepository, reftableWriter, bl2));
            }
            file = null;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return fileReftableDatabase;
    }

    static /* synthetic */ FileReftableStack access$000(FileReftableDatabase fileReftableDatabase) {
        return fileReftableDatabase.reftableStack;
    }

    static /* synthetic */ ReftableDatabase access$100(FileReftableDatabase fileReftableDatabase) {
        return fileReftableDatabase.reftableDatabase;
    }

    static /* synthetic */ FileRepository access$200(FileReftableDatabase fileReftableDatabase) {
        return fileReftableDatabase.fileRepository;
    }

    static /* synthetic */ boolean access$300(FileReftableDatabase fileReftableDatabase, FileReftableStack$Writer fileReftableStack$Writer) {
        return fileReftableDatabase.addReftable(fileReftableStack$Writer);
    }

    static /* synthetic */ ReentrantLock access$400(FileReftableDatabase fileReftableDatabase) {
        return fileReftableDatabase.getLock();
    }
}

