/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import org.eclipse.jgit.internal.storage.file.FileReftableDatabase;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

class FileReftableDatabase$FileReftableRefUpdate
extends RefUpdate {
    private RevWalk rw;
    private Ref dstRef;
    final /* synthetic */ FileReftableDatabase this$0;

    FileReftableDatabase$FileReftableRefUpdate(FileReftableDatabase fileReftableDatabase, Ref ref) {
        this.this$0 = fileReftableDatabase;
        super(ref);
    }

    @Override
    protected RefDatabase getRefDatabase() {
        return this.this$0;
    }

    @Override
    protected Repository getRepository() {
        return FileReftableDatabase.access$200(this.this$0);
    }

    @Override
    protected void unlock() {
    }

    @Override
    public RefUpdate$Result update(RevWalk revWalk) {
        try {
            this.rw = revWalk;
            RefUpdate$Result refUpdate$Result = super.update(revWalk);
            return refUpdate$Result;
        }
        finally {
            this.rw = null;
        }
    }

    @Override
    protected boolean tryLock(boolean bl2) {
        Ref ref;
        this.dstRef = this.getRef();
        if (bl2) {
            this.dstRef = this.dstRef.getLeaf();
        }
        if ((ref = this.this$0.exactRef(this.dstRef.getName())) != null) {
            this.setOldObjectId(ref.getObjectId());
        }
        return true;
    }

    void writeUpdate(ReftableWriter reftableWriter) {
        RevObject revObject;
        ObjectIdRef objectIdRef = null;
        if (this.rw != null && !ObjectId.zeroId().equals(this.getNewObjectId()) && (revObject = this.rw.parseAny(this.getNewObjectId())) instanceof RevTag) {
            objectIdRef = new ObjectIdRef$PeeledTag(Ref$Storage.PACKED, this.dstRef.getName(), this.getNewObjectId(), this.rw.peel(revObject).copy());
        }
        if (objectIdRef == null) {
            objectIdRef = new ObjectIdRef$PeeledNonTag(Ref$Storage.PACKED, this.dstRef.getName(), this.getNewObjectId());
        }
        long l2 = FileReftableDatabase.access$100(this.this$0).nextUpdateIndex();
        reftableWriter.setMinUpdateIndex(l2).setMaxUpdateIndex(l2).begin().writeRef(objectIdRef);
        ObjectId objectId = this.getOldObjectId();
        if (objectId == null) {
            objectId = ObjectId.zeroId();
        }
        reftableWriter.writeLog(this.dstRef.getName(), l2, this.getRefLogIdent(), objectId, this.getNewObjectId(), this.getRefLogMessage());
    }

    @Override
    public PersonIdent getRefLogIdent() {
        PersonIdent personIdent = super.getRefLogIdent();
        if (personIdent == null) {
            personIdent = new PersonIdent(this.getRepository());
        }
        return personIdent;
    }

    void writeDelete(ReftableWriter reftableWriter) {
        ObjectIdRef$Unpeeled objectIdRef$Unpeeled = new ObjectIdRef$Unpeeled(Ref$Storage.NEW, this.dstRef.getName(), null);
        long l2 = FileReftableDatabase.access$100(this.this$0).nextUpdateIndex();
        reftableWriter.setMinUpdateIndex(l2).setMaxUpdateIndex(l2).begin().writeRef(objectIdRef$Unpeeled);
        ObjectId objectId = ObjectId.zeroId();
        Ref ref = this.this$0.exactRef(this.dstRef.getName());
        if (ref != null && (ref = ref.getLeaf()).getObjectId() != null) {
            objectId = ref.getObjectId();
        }
        reftableWriter.writeLog(this.dstRef.getName(), l2, this.getRefLogIdent(), objectId, ObjectId.zeroId(), this.getRefLogMessage());
    }

    @Override
    protected RefUpdate$Result doUpdate(RefUpdate$Result refUpdate$Result) {
        if (this.isRefLogIncludingResult()) {
            this.setRefLogMessage(this.getRefLogMessage() + ": " + refUpdate$Result.toString(), false);
        }
        if (!FileReftableDatabase.access$300(this.this$0, this::writeUpdate)) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        return refUpdate$Result;
    }

    @Override
    protected RefUpdate$Result doDelete(RefUpdate$Result refUpdate$Result) {
        if (this.isRefLogIncludingResult()) {
            this.setRefLogMessage(this.getRefLogMessage() + ": " + refUpdate$Result.toString(), false);
        }
        if (!FileReftableDatabase.access$300(this.this$0, this::writeDelete)) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        return refUpdate$Result;
    }

    void writeLink(ReftableWriter reftableWriter) {
        long l2 = FileReftableDatabase.access$100(this.this$0).nextUpdateIndex();
        reftableWriter.setMinUpdateIndex(l2).setMaxUpdateIndex(l2).begin().writeRef(this.dstRef);
        ObjectId objectId = ObjectId.zeroId();
        Ref ref = this.this$0.exactRef(this.dstRef.getName());
        if (ref != null && (ref = ref.getLeaf()).getObjectId() != null) {
            objectId = ref.getObjectId();
        }
        Ref ref2 = this.dstRef.getLeaf();
        ObjectId objectId2 = ObjectId.zeroId();
        if (ref2.getObjectId() != null) {
            objectId2 = ref2.getObjectId();
        }
        reftableWriter.writeLog(this.dstRef.getName(), l2, this.getRefLogIdent(), objectId, objectId2, this.getRefLogMessage());
    }

    @Override
    protected RefUpdate$Result doLink(String string) {
        if (this.isRefLogIncludingResult()) {
            this.setRefLogMessage(this.getRefLogMessage() + ": " + RefUpdate$Result.FORCED.toString(), false);
        }
        boolean bl2 = this.this$0.exactRef(this.getName()) != null;
        this.dstRef = new SymbolicRef(this.getName(), new ObjectIdRef$Unpeeled(Ref$Storage.NEW, string, null), FileReftableDatabase.access$100(this.this$0).nextUpdateIndex());
        if (!FileReftableDatabase.access$300(this.this$0, this::writeLink)) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        return bl2 ? RefUpdate$Result.FORCED : RefUpdate$Result.NEW;
    }
}

