/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.internal.storage.file.FileReftableDatabase;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef$PeeledNonTag;
import org.eclipse.jgit.lib.ObjectIdRef$Unpeeled;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Ref$Storage;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefUpdate$Result;
import org.eclipse.jgit.lib.SymbolicRef;

class FileReftableDatabase$FileRefRename
extends RefRename {
    final /* synthetic */ FileReftableDatabase this$0;

    FileReftableDatabase$FileRefRename(FileReftableDatabase fileReftableDatabase, RefUpdate refUpdate, RefUpdate refUpdate2) {
        this.this$0 = fileReftableDatabase;
        super(refUpdate, refUpdate2);
    }

    void writeRename(ReftableWriter reftableWriter) {
        long l2 = FileReftableDatabase.access$100(this.this$0).nextUpdateIndex();
        reftableWriter.setMinUpdateIndex(l2).setMaxUpdateIndex(l2).begin();
        ArrayList<Ref> arrayList = new ArrayList<Ref>(3);
        Ref ref2 = this.destination.getRef();
        Ref ref3 = this.this$0.exactRef("HEAD");
        if (ref3 != null && ref3.isSymbolic() && ref3.getLeaf().getName().equals(this.source.getName())) {
            ref3 = new SymbolicRef("HEAD", ref2, l2);
            arrayList.add(ref3);
        }
        ObjectId objectId = this.source.getRef().getObjectId();
        arrayList.add(new ObjectIdRef$PeeledNonTag(Ref$Storage.NEW, this.destination.getName(), objectId));
        arrayList.add(new ObjectIdRef$Unpeeled(Ref$Storage.NEW, this.source.getName(), null));
        reftableWriter.sortAndWriteRefs(arrayList);
        PersonIdent personIdent = this.destination.getRefLogIdent();
        if (personIdent == null) {
            personIdent = new PersonIdent(FileReftableDatabase.access$200(this.this$0));
        }
        if (!this.destination.getRefLogMessage().isEmpty()) {
            List list = arrayList.stream().map(ref -> ref.getName()).collect(Collectors.toList());
            Collections.sort(list);
            for (String string : list) {
                ObjectId objectId2 = "HEAD".equals(string) || string.equals(this.source.getName()) ? objectId : ObjectId.zeroId();
                ObjectId objectId3 = "HEAD".equals(string) || string.equals(this.destination.getName()) ? objectId : ObjectId.zeroId();
                reftableWriter.writeLog(string, l2, personIdent, objectId2, objectId3, this.destination.getRefLogMessage());
            }
        }
    }

    @Override
    protected RefUpdate$Result doRename() {
        Ref ref = this.this$0.exactRef(this.source.getName());
        if (this.this$0.exactRef(this.destination.getName()) != null || ref == null || !this.source.getOldObjectId().equals(ref.getObjectId())) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        if (ref.isSymbolic()) {
            return RefUpdate$Result.IO_FAILURE;
        }
        if (!FileReftableDatabase.access$300(this.this$0, this::writeRename)) {
            return RefUpdate$Result.LOCK_FAILURE;
        }
        return RefUpdate$Result.RENAMED;
    }
}

